/*
 * Decompiled with CFR 0.152.
 */
package gwt.jsonix.marshallers.xjc.plugin.builders;

import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import gwt.jsonix.marshallers.xjc.plugin.utils.BuilderUtils;
import gwt.jsonix.marshallers.xjc.plugin.utils.ClassNameUtils;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import org.apache.commons.lang3.StringUtils;
import org.hisrc.jsonix.settings.LogLevelSetting;

public class JSINameBuilder {
    private static final String[] FIELDS = new String[]{"namespaceURI", "localPart", "prefix", "key", "string"};

    private JSINameBuilder() {
    }

    public static JDefinedClass generateJSINameClass(JCodeModel jCodeModel, String jsMainPackage) throws JClassAlreadyExistsException {
        JDefinedClass toReturn = JSINameBuilder.getJSINameClass(jCodeModel, jsMainPackage);
        JSINameBuilder.populateJSINameClass(jCodeModel, toReturn);
        return toReturn;
    }

    protected static void populateJSINameClass(JCodeModel jCodeModel, JDefinedClass jDefinedClass) {
        for (String field : FIELDS) {
            JSINameBuilder.addField(jCodeModel, jDefinedClass, field);
        }
    }

    protected static void addField(JCodeModel jCodeModel, JDefinedClass jDefinedClass, String field) {
        BuilderUtils.addNativeGetter(jCodeModel, jDefinedClass, jCodeModel.ref(String.class), StringUtils.capitalize((String)field), field);
        BuilderUtils.addNativeSetter(jCodeModel, jDefinedClass, jCodeModel.ref(String.class), StringUtils.capitalize((String)field), field);
    }

    protected static JDefinedClass getJSINameClass(JCodeModel jCodeModel, String jsMainPackage) throws JClassAlreadyExistsException {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Creating JSIName class");
        String className = "Name";
        if (!jsMainPackage.isEmpty() && !jsMainPackage.endsWith(".")) {
            jsMainPackage = jsMainPackage + ".";
        }
        JFieldRef nameSpaceExpression = jCodeModel.ref(JsPackage.class).staticRef("GLOBAL");
        JDefinedClass toReturn = jCodeModel._class(jsMainPackage + "JSI" + "Name");
        String jsTypeName = ClassNameUtils.getJsInteropTypeName(toReturn.fullName());
        toReturn.annotate(jCodeModel.ref(JsType.class)).param("namespace", (JExpression)nameSpaceExpression).param("name", jsTypeName).param("isNative", true);
        JDocComment comment = toReturn.javadoc();
        comment.append((Object)"Class representing the <b>name</b> attribute of a <b>wrapped</b> object");
        return toReturn;
    }
}

