/*
 * Decompiled with CFR 0.152.
 */
package gwt.jsonix.marshallers.xjc.plugin;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.tools.xjc.outline.Outline;
import gwt.jsonix.marshallers.xjc.plugin.GWTSettings;
import gwt.jsonix.marshallers.xjc.plugin.builders.CallbacksBuilder;
import gwt.jsonix.marshallers.xjc.plugin.builders.ContainerObjectBuilder;
import gwt.jsonix.marshallers.xjc.plugin.builders.JSINameBuilder;
import gwt.jsonix.marshallers.xjc.plugin.builders.JsUtilsBuilder;
import gwt.jsonix.marshallers.xjc.plugin.builders.MainJsBuilder;
import gwt.jsonix.marshallers.xjc.plugin.builders.ModelBuilder;
import gwt.jsonix.marshallers.xjc.plugin.dtos.ConstructorMapper;
import gwt.jsonix.marshallers.xjc.plugin.utils.BuilderUtils;
import gwt.jsonix.marshallers.xjc.plugin.utils.ClassNameUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hisrc.jsonix.args4j.PartialCmdLineParser;
import org.hisrc.jsonix.configuration.JsonSchemaConfiguration;
import org.hisrc.jsonix.configuration.MappingConfiguration;
import org.hisrc.jsonix.configuration.ModulesConfiguration;
import org.hisrc.jsonix.configuration.ModulesConfigurationUnmarshaller;
import org.hisrc.jsonix.configuration.OutputConfiguration;
import org.hisrc.jsonix.context.DefaultJsonixContext;
import org.hisrc.jsonix.context.JsonixContext;
import org.hisrc.jsonix.settings.LogLevelSetting;
import org.hisrc.jsonix.xjc.plugin.JsonixPlugin;
import org.kohsuke.args4j.CmdLineException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class JsonixGWTPlugin
extends JsonixPlugin {
    public static final String OPTION_NAME = "Xgwtjsonix";
    public static final String MAIN_JS = "MainJs";
    private GWTSettings settings = new GWTSettings();

    public GWTSettings getSettings() {
        return this.settings;
    }

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return "  -Xgwtjsonix :  Generates Jsonix mappings and JSInterop code.\n                    See (to_be_defined)";
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException {
        PartialCmdLineParser cmdLineParser = new PartialCmdLineParser((Object)this.getSettings());
        try {
            return cmdLineParser.parseArgument(args, i);
        }
        catch (CmdLineException clex) {
            throw new BadCommandLineException("Error parsing arguments.", (Throwable)clex);
        }
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) throws SAXException {
        super.run(outline, options, errorHandler);
        BuilderUtils.log(LogLevelSetting.DEBUG, "run");
        try {
            Model model = outline.getModel();
            JCodeModel jCodeModel = new JCodeModel();
            CodeWriter codeWriter = BuilderUtils.createCodeWriter(model, this.getSettings());
            JDefinedClass jsiNameClass = JSINameBuilder.generateJSINameClass(jCodeModel, this.settings.getJsMainPackage());
            JDefinedClass jsUtilsClass = JsUtilsBuilder.generateJsUtilsClass(jCodeModel, this.settings.getJsMainPackage());
            Map<String, String> packageModuleMap = this.getPackageModuleMap(model);
            HashMap<String, JClass> definedClassesMap = new HashMap<String, JClass>();
            Map<String, List<ConstructorMapper>> constructorsMap = this.getConstructorsMap(jsiNameClass);
            ModelBuilder.generateJSInteropModels(definedClassesMap, model, jCodeModel, packageModuleMap, jsUtilsClass, jsiNameClass, constructorsMap);
            Map<String, Map<String, JClass>> topLevelElementsMap = this.getTopLevelElementsMap(packageModuleMap.keySet(), definedClassesMap, model.getAllElements());
            List<JDefinedClass> containersClasses = ContainerObjectBuilder.generateJSInteropContainerObjects(packageModuleMap, topLevelElementsMap, jCodeModel);
            Map<String, Map<String, JDefinedClass>> callbacksMap = CallbacksBuilder.generateJSInteropCallbacks(containersClasses, jCodeModel);
            MainJsBuilder.generateJSInteropMainJs(callbacksMap, containersClasses, constructorsMap, jCodeModel, this.settings.getMainJsName());
            BuilderUtils.writeJSInteropCode(jCodeModel, codeWriter);
        }
        catch (Exception e) {
            BuilderUtils.log(LogLevelSetting.ERROR, e.getMessage(), e);
            throw new SAXException(e);
        }
        return true;
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
    }

    protected Map<String, List<ConstructorMapper>> getConstructorsMap(JDefinedClass jsiNameClass) {
        HashMap<String, List<ConstructorMapper>> toReturn = new HashMap<String, List<ConstructorMapper>>();
        toReturn.put("GWT_JSONIX", Collections.singletonList(new ConstructorMapper(null, ClassNameUtils.getJsInteropTypeName(jsiNameClass.fullName()), null)));
        return toReturn;
    }

    protected Map<String, Map<String, JClass>> getTopLevelElementsMap(Set<String> packageNames, Map<String, JClass> definedClassesMap, Iterable<? extends CElementInfo> allElements) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "getTopLevelElementsMap");
        Spliterator<? extends CElementInfo> spliterator = allElements.spliterator();
        List allElementsList = StreamSupport.stream(spliterator, false).collect(Collectors.toList());
        HashMap<String, Map<String, JClass>> toReturn = new HashMap<String, Map<String, JClass>>();
        for (String packageName : packageNames) {
            Map<String, JClass> toPut = allElementsList.stream().filter(cElementInfo -> Objects.equals(packageName, cElementInfo._package().name())).filter(cElementInfo -> definedClassesMap.containsKey(((NType)cElementInfo.getContentType().getType()).fullName())).collect(Collectors.toMap(cElementInfo -> cElementInfo.getElementName().getLocalPart(), cElementInfo -> (JClass)definedClassesMap.get(((NType)cElementInfo.getContentType().getType()).fullName())));
            toReturn.put(packageName, toPut);
        }
        return toReturn;
    }

    protected Map<String, String> getPackageModuleMap(Model model) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "getPackageModuleMap");
        GWTSettings gwtSettings = this.getSettings();
        DefaultJsonixContext context = new DefaultJsonixContext();
        OutputConfiguration defaultOutputConfiguration = new OutputConfiguration(gwtSettings.getDefaultNaming().getName(), "${module.name}.js");
        JsonSchemaConfiguration defaultJsonSchemaConfiguration = gwtSettings.isGenerateJsonSchema() ? new JsonSchemaConfiguration("${module.name}.jsonschema") : null;
        ModulesConfigurationUnmarshaller customizationHandler = new ModulesConfigurationUnmarshaller((JsonixContext)context);
        ModulesConfiguration modulesConfiguration = customizationHandler.unmarshal(model, defaultOutputConfiguration, defaultJsonSchemaConfiguration);
        return modulesConfiguration.getMappingConfigurations().stream().collect(Collectors.toMap(MappingConfiguration::getPackage, MappingConfiguration::getName));
    }
}

