/*
 * Decompiled with CFR 0.152.
 */
package gwt.jsonix.marshallers.xjc.plugin.builders;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JForLoop;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.JVar;
import gwt.jsonix.marshallers.xjc.plugin.utils.BuilderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.xml.namespace.QName;
import jsinterop.base.Js;
import jsinterop.base.JsArrayLike;
import org.hisrc.jsonix.settings.LogLevelSetting;

public class JsUtilsBuilder {
    protected static final String GENERIC_TYPE_NAME = "D";
    protected static final String GENERIC_EXTEND_TYPE_NAME = "E";
    protected static final String ELEMENT = "element";
    protected static final int PUBLIC_STATIC_MODS = 17;
    protected static final int PUBLIC_STATIC_NATIVE_MODS = 81;
    protected static final int PRIVATE_STATIC_MODS = 20;
    private static final String NEW_WRAPPED_INSTANCE_TEMPLATE = "\r\n     /**\n     * Returns a <b>stub</b> object with <b>name</b> and <b>value</b> attributes\n     * @return\n     */\n     public static native <D> D newWrappedInstance() /*-{\n        var json = \"{\\\"name\\\": \\\"\\\", \\\"value\\\": \\\"\\\"}\";\n        var retrieved = JSON.parse(json)\n        return retrieved\n    }-*/;\n";
    private static final String SET_NAME_ON_WRAPPED_TEMPLATE = "\r\n     /**\n     * Set the <b>name</b> attribute of the given <b>wrapped</b> <code>D</code> with the <b>json</b> representation of the given <code>JSIName</code>\n     * @param wrappedObject\n     * @param name\n     */\n    public static native <D> void setNameOnWrapped(D wrappedObject, JSIName name) /*-{\n        wrappedObject.name = name\n    }-*/;";
    private static final String SET_VALUE_ON_WRAPPED_TEMPLATE = "\r\n     /**\n     * Set the <b>value</b> attribute of the given <b>wrapped</b> <code>D</code> with the <b>json</b> representation of <b>value</b> <code>E</code>\n     * @param wrappedObject\n     * @param value\n     */\n    public static native <D, E> void setValueOnWrapped(D wrappedObject, E value) /*-{\n        wrappedObject.value = value\n    }-*/;";
    private static final String GET_UNWRAPPED_ELEMENTS_ARRAY_METHOD = "\r\n     /**\n     * Returns a <code>JsArrayLike</code> where each element represents the <b>unwrapped</b> object (i.e. object.value) of the original one.\n     * It the original <code>JsArrayLike</code> is <code>null</code>, returns a new, empty one\n     * @param original\n     * @param <D>\n     * @return\n     */\n     public static native <D> JsArrayLike<D> getUnwrappedElementsArray(final JsArrayLike<D> original) /*-{\n        var toReturn = [];\n        if(original != null) {\n            toReturn = original.map(function (arrayItem) {\n                var retrieved = arrayItem.value\n                var toSet = retrieved == null ? arrayItem : retrieved\n                return toSet;\n            });\n        }\n        return toReturn;\n    }-*/;\n";
    private static final String GET_NATIVE_ELEMENTS_ARRAY_METHOD = "\r\n     /**\n     * Returns the original <code>JsArrayLike</code> or, ift the original <code>JsArrayLike</code> is <code>null</code>, a new, empty one\n     * @param original\n     * @param <D>\n     * @return\n     */\n     public static native <D> JsArrayLike<D> getNativeElementsArray(final JsArrayLike<D> original) /*-{\n        if(original == null) {\n            return [];\n        } else {\n            return original;\n        }\n    }-*/;";
    private static final String GET_UNWRAPPED_ELEMENT_METHOD = "\r\n     public static native Object getUnwrappedElement(final Object original) /*-{\n        var toReturn = original.value;\n        var toSet = toReturn == null ? original : toReturn;\n        return toSet;\n    }-*/;\n";
    private static final String GET_WRAPPED_ELEMENT_METHOD = "\r\n     public static native <D> D getWrappedElement(final Object value) /*-{\n        var json = \"{\\\"name\\\": \\\"\\\", \\\"value\\\": \\\"\\\"}\";\n        var toReturn = JSON.parse(json)\n        toReturn.value =  value;\n        return toReturn;\n    }-*/;\n";
    private static final String GET_NATIVE_ARRAY_METHOD = "\r\n     /**\n     * Helper method to create a new, empty <code>JsArrayLike</code>\n     * @return\n     */\n     public static native <D> JsArrayLike<D> getNativeArray() /*-{\n        return [];\n    }-*/;\n";
    private static final String TO_ATTRIBUTES_MAP_METHOD = "\r\n     private static native void toAttributesMap(final Map<QName, String> toReturn,\n                                               final Object original) /*-{\n        var keys = Object.keys(original);\n        for (var i = 0; i < keys.length; i++) {\n            var key = keys[i];\n            var value = original[key];\n            @%1$s.JsUtils::putToAttributesMap(Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;)(toReturn, key, value);\n        }\n    }-*/;\n";
    private static final String GET_EMPTY_JS_OBJECT_METHOD = "\r\n    /**\n     * Helper method to create a new empty JavaScript object.\n     * @return\n     */\n    private static native <D> D getJsObject() /*-{\n        return {};\n    }-*/;\n";
    private static final String PUT_TO_JS_OBJECT_METHOD = "\r\n    /**\n     * Helper method to add a value to a JavaScript object at the associated key.\n     */\n    private static native <D, K, V> void putToJavaScriptObject(final D jso, final K key, final V value) /*-{\n        jso[key] = value;\n    }-*/;\n";
    private static final String GET_TYPE_NAME = "\r\n    public static native String getTypeName(final Object instance) /*-{\n        return instance.TYPE_NAME\n    }-*/;\n";
    protected static final String GET_JSI_NAME_TEMPLATE = "\r\n    public static native JSIName getJSIName(final String namespaceURI,\n                                            final String localPart,\n                                            final String prefix)/*-{\n        var json = \"{\\\"namespaceURI\\\": \\\"\" + namespaceURI + \"\\\", \\\"localPart\\\": \\\"\" + localPart + \"\\\", \\\"prefix\\\": \\\"\" + prefix + \"\\\", \\\"key\\\": \\\"{\" + namespaceURI + \"}\" + localPart + \"\\\", \\\"string\\\": \\\"{\" + namespaceURI + \"}\" + prefix + \":\" + localPart + \"\\\"}\";\n        return JSON.parse(json);\n\r\n}-*/;";

    private JsUtilsBuilder() {
    }

    public static JDefinedClass generateJsUtilsClass(JCodeModel jCodeModel, String jsMainPackage) throws JClassAlreadyExistsException {
        JDefinedClass toReturn = JsUtilsBuilder.getJsUtilsClass(jCodeModel, jsMainPackage);
        JsUtilsBuilder.populateJsUtilClass(jCodeModel, toReturn, jsMainPackage);
        return toReturn;
    }

    protected static void populateJsUtilClass(JCodeModel jCodeModel, JDefinedClass toPopulate, String jsMainPackage) {
        JsUtilsBuilder.addEmptyConstructor(toPopulate);
        JMethod addMethod = JsUtilsBuilder.addAddMethod(jCodeModel, toPopulate);
        JsUtilsBuilder.addAddAllMethod(jCodeModel, toPopulate, addMethod);
        JsUtilsBuilder.addRemoveMethod(jCodeModel, toPopulate);
        JsUtilsBuilder.addToListMethod(jCodeModel, toPopulate);
        JsUtilsBuilder.addToJsArrayLikeMethod(jCodeModel, toPopulate);
        JsUtilsBuilder.addNewWrappedInstance(toPopulate);
        JsUtilsBuilder.addSetNameOnWrappedObject(toPopulate);
        JsUtilsBuilder.addSetValueOnWrappedObject(toPopulate);
        JsUtilsBuilder.addGetNativeElementsArrayMethod(toPopulate);
        JsUtilsBuilder.addGetUnwrappedElementsArrayMethod(toPopulate);
        JsUtilsBuilder.addGetUnwrappedElementMethod(toPopulate);
        JsUtilsBuilder.addGetWrappedElementMethod(toPopulate);
        JsUtilsBuilder.addGetNativeArray(toPopulate);
        JsUtilsBuilder.addJavaToAttributesMapMethod(jCodeModel, toPopulate);
        JsUtilsBuilder.addNativeToAttributesMapMethod(toPopulate, jsMainPackage);
        JsUtilsBuilder.addPutToAttributesMap(jCodeModel, toPopulate);
        JsUtilsBuilder.addJavaFromAttributesMapMethod(jCodeModel, toPopulate);
        JsUtilsBuilder.addNativeGetJsObjectMethod(toPopulate);
        JsUtilsBuilder.addNativePutToJsObjectMethod(toPopulate);
        JsUtilsBuilder.addGetTypeName(toPopulate);
        JsUtilsBuilder.addGetJSIName(toPopulate);
    }

    protected static void addGetJSIName(JDefinedClass jDefinedClass) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add native 'getJSIName' method...");
        jDefinedClass.direct(GET_JSI_NAME_TEMPLATE);
    }

    protected static void addGetTypeName(JDefinedClass jDefinedClass) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add native 'getTypeName' method...");
        jDefinedClass.direct(GET_TYPE_NAME);
    }

    protected static JDefinedClass getJsUtilsClass(JCodeModel jCodeModel, String jsMainPackage) throws JClassAlreadyExistsException {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Creating  JsUtils class");
        if (!jsMainPackage.isEmpty() && !jsMainPackage.endsWith(".")) {
            jsMainPackage = jsMainPackage + ".";
        }
        JDefinedClass toReturn = jCodeModel._class(jsMainPackage + "JsUtils");
        JDocComment comment = toReturn.javadoc();
        comment.append((Object)"Utility class to provide generic methods used by all specific JSInterop classes");
        return toReturn;
    }

    protected static void addEmptyConstructor(JDefinedClass jsUtils) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add empty constructor...");
        jsUtils.constructor(4).body().directStatement(" //Private constructor to prevent instantiation");
    }

    protected static JMethod addAddMethod(JCodeModel jCodeModel, JDefinedClass jsUtils) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add 'add' method...");
        JClass genericT = JsUtilsBuilder.getGenericT(jCodeModel);
        JMethod toReturn = JsUtilsBuilder.getGenerifiedJMethod(jsUtils, Void.TYPE, "add");
        JVar jsArrayLikeParameter = JsUtilsBuilder.getJSArrayNarrowedJVar(jCodeModel, toReturn);
        JVar elementParam = toReturn.param(8, (JType)genericT, ELEMENT);
        JBlock block = toReturn.body();
        JVar length = block.decl((JType)jCodeModel.INT, "length");
        length.init((JExpression)JExpr.invoke((JExpression)jsArrayLikeParameter, (String)"getLength"));
        block.add((JStatement)jsArrayLikeParameter.invoke("setLength").arg(length.plus(JExpr.lit((int)1))));
        block.add((JStatement)jsArrayLikeParameter.invoke("setAt").arg((JExpression)length).arg((JExpression)elementParam));
        return toReturn;
    }

    protected static JMethod addAddAllMethod(JCodeModel jCodeModel, JDefinedClass jsUtils, JMethod addMethod) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add 'addAll' method...");
        JClass genericT = JsUtilsBuilder.getGenericT(jCodeModel);
        JClass genericE = JsUtilsBuilder.getGenericTExtends(jCodeModel);
        JMethod toReturn = JsUtilsBuilder.getGenerifiedJMethod(jsUtils, Void.TYPE, "addAll");
        toReturn.generify(GENERIC_EXTEND_TYPE_NAME, genericT);
        JVar jsArrayLikeParameter = JsUtilsBuilder.getJSArrayNarrowedJVar(jCodeModel, toReturn);
        JVar elementParam = toReturn.varParam((JType)genericE, "elements");
        elementParam.mods().setFinal(true);
        JBlock block = toReturn.body();
        JInvocation addInvocation = jsUtils.staticInvoke(addMethod).arg((JExpression)jsArrayLikeParameter).arg((JExpression)JExpr.ref((String)ELEMENT));
        JForEach forEachElement = block.forEach((JType)genericT, ELEMENT, (JExpression)elementParam);
        forEachElement.body().add((JStatement)addInvocation);
        return toReturn;
    }

    protected static JMethod addRemoveMethod(JCodeModel jCodeModel, JDefinedClass jsUtils) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add 'remove' method...");
        JMethod toReturn = JsUtilsBuilder.getGenerifiedJMethod(jsUtils, Void.TYPE, "remove");
        JVar jsArrayLikeParameter = JsUtilsBuilder.getJSArrayNarrowedJVar(jCodeModel, toReturn);
        JVar indexParam = toReturn.param(8, (JType)jCodeModel.INT, "index");
        JBlock block = toReturn.body();
        JVar targetIndex = block.decl((JType)jCodeModel.INT, "targetIndex", JExpr.lit((int)0));
        JForLoop jForLoop = block._for();
        JVar sourceIndex = jForLoop.init((JType)jCodeModel.INT, "sourceIndex", JExpr.lit((int)0));
        jForLoop.test(sourceIndex.lt((JExpression)jsArrayLikeParameter.invoke("getLength")));
        jForLoop.update(sourceIndex.incr());
        JConditional jConditional = jForLoop.body()._if(sourceIndex.ne((JExpression)indexParam));
        jConditional._then().add((JStatement)jsArrayLikeParameter.invoke("setAt").arg(targetIndex.incr()).arg((JExpression)jsArrayLikeParameter.invoke("getAt").arg((JExpression)sourceIndex)));
        block.add((JStatement)jsArrayLikeParameter.invoke("setLength").arg((JExpression)targetIndex));
        return toReturn;
    }

    protected static JMethod addToListMethod(JCodeModel jCodeModel, JDefinedClass jsUtils) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add 'toList' method...");
        JClass rawListClass = jCodeModel.ref(List.class);
        JClass genericT = JsUtilsBuilder.getGenericT(jCodeModel);
        JClass narrowedList = rawListClass.narrow(genericT);
        JClass rawArrayListClass = jCodeModel.ref(ArrayList.class);
        JClass arrayListField = rawArrayListClass.narrow(genericT);
        JMethod toReturn = JsUtilsBuilder.getGenerifiedJMethod(jsUtils, narrowedList, "toList");
        JVar jsArrayLikeParameter = JsUtilsBuilder.getJSArrayNarrowedJVar(jCodeModel, toReturn);
        JBlock block = toReturn.body();
        JVar listToReturn = block.decl(8, (JType)narrowedList, "toReturn", (JExpression)JExpr._new((JClass)arrayListField));
        JConditional nonNull = block._if((JExpression)jCodeModel.ref(Objects.class).staticInvoke("nonNull").arg((JExpression)jsArrayLikeParameter));
        JForLoop jForLoop = nonNull._then()._for();
        JVar i = jForLoop.init((JType)jCodeModel.INT, "i", JExpr.lit((int)0));
        jForLoop.test(i.lt((JExpression)jsArrayLikeParameter.invoke("getLength")));
        jForLoop.update(i.incr());
        JBlock forLoopBody = jForLoop.body();
        JVar toAdd = forLoopBody.decl(8, (JType)genericT, "toAdd", (JExpression)jCodeModel.ref(Js.class).staticInvoke("uncheckedCast").arg((JExpression)jsArrayLikeParameter.invoke("getAt").arg((JExpression)i)));
        forLoopBody.add((JStatement)listToReturn.invoke("add").arg((JExpression)toAdd));
        block._return((JExpression)listToReturn);
        return toReturn;
    }

    protected static JMethod addToJsArrayLikeMethod(JCodeModel jCodeModel, JDefinedClass jsUtils) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add 'toJsArrayLike' method...");
        JClass genericT = JsUtilsBuilder.getGenericT(jCodeModel);
        JClass narrowedJsArrayLike = JsUtilsBuilder.getJsArrayNarrowedClass(jCodeModel);
        JClass rawArrayListClass = jCodeModel.ref(List.class);
        JClass listField = rawArrayListClass.narrow(genericT);
        JMethod toReturn = JsUtilsBuilder.getGenerifiedJMethod(jsUtils, narrowedJsArrayLike, "toJsArrayLike");
        JVar listParameter = toReturn.param(8, (JType)listField, "list");
        JBlock block = toReturn.body();
        JVar listToReturn = block.decl(8, (JType)narrowedJsArrayLike, "toReturn", (JExpression)JExpr.invoke((String)"getNativeArray"));
        JConditional nonNull = block._if((JExpression)jCodeModel.ref(Objects.class).staticInvoke("nonNull").arg((JExpression)listParameter));
        JForLoop jForLoop = nonNull._then()._for();
        JVar i = jForLoop.init((JType)jCodeModel.INT, "i", JExpr.lit((int)0));
        jForLoop.test(i.lt((JExpression)listParameter.invoke("size")));
        jForLoop.update(i.incr());
        JBlock forLoopBody = jForLoop.body();
        JVar toAdd = forLoopBody.decl(8, (JType)genericT, "toAdd", (JExpression)jCodeModel.ref(Js.class).staticInvoke("uncheckedCast").arg((JExpression)listParameter.invoke("get").arg((JExpression)i)));
        forLoopBody.add((JStatement)listToReturn.invoke("setAt").arg((JExpression)listToReturn.invoke("getLength")).arg((JExpression)toAdd));
        block._return((JExpression)listToReturn);
        return toReturn;
    }

    protected static void addNewWrappedInstance(JDefinedClass jDefinedClass) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add 'newWrappedInstance' method...");
        String directString = String.format(NEW_WRAPPED_INSTANCE_TEMPLATE, jDefinedClass.name());
        jDefinedClass.direct(directString);
    }

    protected static void addSetNameOnWrappedObject(JDefinedClass jDefinedClass) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add 'setNameOnWrapped' method...");
        String directString = String.format(SET_NAME_ON_WRAPPED_TEMPLATE, jDefinedClass.name());
        jDefinedClass.direct(directString);
    }

    protected static void addSetValueOnWrappedObject(JDefinedClass jDefinedClass) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add 'setValueOnWrapped' method...");
        String directString = String.format(SET_VALUE_ON_WRAPPED_TEMPLATE, jDefinedClass.name());
        jDefinedClass.direct(directString);
    }

    protected static void addGetUnwrappedElementsArrayMethod(JDefinedClass jsUtils) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add 'getUnwrappedElementsArray' method...");
        jsUtils.direct(GET_UNWRAPPED_ELEMENTS_ARRAY_METHOD);
    }

    protected static void addGetNativeElementsArrayMethod(JDefinedClass jsUtils) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add 'getNativeElementsArray' method...");
        jsUtils.direct(GET_NATIVE_ELEMENTS_ARRAY_METHOD);
    }

    protected static void addGetUnwrappedElementMethod(JDefinedClass jsUtils) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add 'getUnwrappedElement' method...");
        jsUtils.direct(GET_UNWRAPPED_ELEMENT_METHOD);
    }

    protected static void addGetWrappedElementMethod(JDefinedClass jsUtils) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add 'getWrappedElement' method...");
        jsUtils.direct(GET_WRAPPED_ELEMENT_METHOD);
    }

    protected static void addGetNativeArray(JDefinedClass jsUtils) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add 'getNativeArray' method...");
        jsUtils.direct(GET_NATIVE_ARRAY_METHOD);
    }

    protected static void addNativeGetJsObjectMethod(JDefinedClass jsUtils) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add native 'getJsObject' method...");
        jsUtils.direct(GET_EMPTY_JS_OBJECT_METHOD);
    }

    protected static void addNativePutToJsObjectMethod(JDefinedClass jsUtils) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add native 'putToJsObject' method...");
        jsUtils.direct(PUT_TO_JS_OBJECT_METHOD);
    }

    protected static JMethod addJavaToAttributesMapMethod(JCodeModel jCodeModel, JDefinedClass jsUtils) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add java 'toAttributesMap' method...");
        JClass qName = jCodeModel.ref(QName.class);
        JClass narrowedMap = JsUtilsBuilder.getQNameStringNarrowedMapClass(jCodeModel);
        JClass rawHashMapClass = jCodeModel.ref(HashMap.class);
        JClass hashMapField = rawHashMapClass.narrow(new JClass[]{qName, jCodeModel.ref(String.class)});
        JMethod toReturn = JsUtilsBuilder.getJMethod(jsUtils, narrowedMap, "toAttributesMap");
        JVar originalParameter = toReturn.param(8, (JType)jCodeModel.ref(Object.class), "original");
        JBlock block = toReturn.body();
        JVar mapToReturn = block.decl(8, (JType)narrowedMap, "toReturn", (JExpression)JExpr._new((JClass)hashMapField));
        JConditional nonNull = block._if((JExpression)jCodeModel.ref(Objects.class).staticInvoke("nonNull").arg((JExpression)originalParameter));
        nonNull._then().invoke("toAttributesMap").arg((JExpression)mapToReturn).arg((JExpression)originalParameter);
        block._return((JExpression)mapToReturn);
        JDocComment javadoc = toReturn.javadoc();
        String commentString = "Extracts the <b>otherAttributes</b> property from a JavaScriptObject to a <i>regular</i> Java Map.";
        javadoc.append((Object)commentString);
        JCommentPart setterPart = javadoc.addParam("original");
        commentString = " <b>js object</b> to transform.";
        setterPart.add((Object)commentString);
        JCommentPart returnPart = javadoc.addReturn();
        commentString = "the populated <code>Map&lt;QName, String&gt;</code>";
        returnPart.add((Object)commentString);
        return toReturn;
    }

    protected static JMethod addPutToAttributesMap(JCodeModel jCodeModel, JDefinedClass jsUtils) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add 'putToAttributesMap' method...");
        JClass qName = jCodeModel.ref(QName.class);
        JClass narrowedMap = JsUtilsBuilder.getQNameStringNarrowedMapClass(jCodeModel);
        JMethod toReturn = jsUtils.method(20, Void.TYPE, "putToAttributesMap");
        JVar mapParameter = toReturn.param(8, (JType)narrowedMap, "destination");
        JVar qNameAsStringParameter = toReturn.param(8, (JType)jCodeModel.ref(String.class), "qNameAsString");
        JVar valueParameter = toReturn.param(8, (JType)jCodeModel.ref(String.class), "value");
        JBlock block = toReturn.body();
        block.add((JStatement)mapParameter.invoke("put").arg((JExpression)qName.staticInvoke("valueOf").arg((JExpression)qNameAsStringParameter)).arg((JExpression)valueParameter));
        JDocComment javadoc = toReturn.javadoc();
        String commentString = "Create a <code>QName</code> instance from the given <b>qNameAsString</b>, and the use it as key for a new entry on <b>destination</b> Map.";
        javadoc.append((Object)commentString);
        JCommentPart setterPart = javadoc.addParam("destination");
        commentString = " the <code>Map</code> to populate.";
        setterPart.add((Object)commentString);
        setterPart = javadoc.addParam("qNameAsString");
        commentString = " the <code>String</code> to transform to <code>QName</code> instance used as key.";
        setterPart.add((Object)commentString);
        setterPart = javadoc.addParam("value");
        commentString = " the <b>value</b> to be used in the new entry.";
        setterPart.add((Object)commentString);
        return toReturn;
    }

    protected static void addNativeToAttributesMapMethod(JDefinedClass jsUtils, String jsMainPackage) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add native 'toAttributesMap' method...");
        jsUtils.direct(String.format(TO_ATTRIBUTES_MAP_METHOD, jsMainPackage));
    }

    protected static JMethod addJavaFromAttributesMapMethod(JCodeModel jCodeModel, JDefinedClass jsUtils) {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Add java 'fromAttributesMapMethod' method...");
        JClass narrowedMap = JsUtilsBuilder.getQNameStringNarrowedMapClass(jCodeModel);
        JMethod toReturn = JsUtilsBuilder.getJMethod(jsUtils, jCodeModel.ref(Object.class), "fromAttributesMap");
        JTypeVar type = toReturn.generify(GENERIC_TYPE_NAME);
        toReturn.type((JType)type);
        JVar originalParam = toReturn.param(8, (JType)narrowedMap, "original");
        JBlock block = toReturn.body();
        JVar mapToReturn = block.decl(8, (JType)type, "toReturn", (JExpression)JExpr.invoke((String)"getJsObject"));
        JClass narrowedConsumer = JsUtilsBuilder.getQNameStringNarrowedMapEntryConsumerClass(jCodeModel);
        JDefinedClass anonymousNarrowedConsumerProducer = jCodeModel.anonymousClass(narrowedConsumer);
        JMethod acceptMethod = anonymousNarrowedConsumerProducer.method(1, (JType)jCodeModel.VOID, "accept");
        acceptMethod.annotate(Override.class);
        JVar entry = acceptMethod.param((JType)JsUtilsBuilder.getQNameStringNarrowedMapEntryClass(jCodeModel), "entry");
        JBlock methodBody = acceptMethod.body();
        methodBody.invoke("putToJavaScriptObject").arg((JExpression)mapToReturn).arg((JExpression)entry.invoke("getKey").invoke("toString")).arg((JExpression)entry.invoke("getValue"));
        block.add((JStatement)originalParam.invoke("entrySet").invoke("stream").invoke("forEach").arg((JExpression)JExpr._new((JClass)anonymousNarrowedConsumerProducer)));
        block._return((JExpression)mapToReturn);
        JDocComment javadoc = toReturn.javadoc();
        String commentString = "Extracts the <b>otherAttributes</b> property from a <i>regular<i> Java Map to a JavaScriptObject.";
        javadoc.append((Object)commentString);
        JCommentPart setterPart = javadoc.addParam("original");
        commentString = " the <code>Map&lt;QName, String&gt;</code> to transform.";
        setterPart.add((Object)commentString);
        JCommentPart returnPart = javadoc.addReturn();
        commentString = "the populated JavaScriptObject";
        returnPart.add((Object)commentString);
        return toReturn;
    }

    protected static JMethod getGenerifiedJMethod(JDefinedClass jsUtils, Class<?> returnType, String methodName) {
        JMethod toReturn = JsUtilsBuilder.getJMethod(jsUtils, returnType, methodName);
        toReturn.generify(GENERIC_TYPE_NAME);
        return toReturn;
    }

    protected static JMethod getGenerifiedJMethod(JDefinedClass jsUtils, JClass returnType, String methodName) {
        JMethod toReturn = JsUtilsBuilder.getJMethod(jsUtils, returnType, methodName);
        toReturn.generify(GENERIC_TYPE_NAME);
        return toReturn;
    }

    protected static JMethod getJMethod(JDefinedClass jsUtils, Class<?> returnType, String methodName) {
        return jsUtils.method(17, returnType, methodName);
    }

    protected static JMethod getJMethod(JDefinedClass jsUtils, JClass returnType, String methodName) {
        return jsUtils.method(17, (JType)returnType, methodName);
    }

    protected static JMethod getNativeJMethod(JDefinedClass jsUtils, Class<?> returnType, String methodName) {
        return jsUtils.method(81, returnType, methodName);
    }

    protected static JMethod getNativeJMethod(JDefinedClass jsUtils, JClass returnType, String methodName) {
        return jsUtils.method(81, (JType)returnType, methodName);
    }

    protected static JVar getJSArrayNarrowedJVar(JCodeModel jCodeModel, JMethod jmethod) {
        return jmethod.param(8, (JType)JsUtilsBuilder.getJsArrayNarrowedClass(jCodeModel), "jsArrayLike");
    }

    protected static JClass getGenericT(JCodeModel jCodeModel) {
        return jCodeModel.ref(GENERIC_TYPE_NAME);
    }

    protected static JClass getGenericTExtends(JCodeModel jCodeModel) {
        return jCodeModel.ref(GENERIC_EXTEND_TYPE_NAME);
    }

    protected static JClass getJsArrayNarrowedClass(JCodeModel jCodeModel) {
        JClass jsArrayLikeClass = jCodeModel.ref(JsArrayLike.class);
        return jsArrayLikeClass.narrow(JsUtilsBuilder.getGenericT(jCodeModel));
    }

    protected static JClass getQNameStringNarrowedMapClass(JCodeModel jCodeModel) {
        JClass rawMapClass = jCodeModel.ref(Map.class);
        JClass qName = jCodeModel.ref(QName.class);
        return rawMapClass.narrow(new JClass[]{qName, jCodeModel.ref(String.class)});
    }

    protected static JClass getQNameStringNarrowedMapEntryClass(JCodeModel jCodeModel) {
        JClass rawMapClass = jCodeModel.directClass(Map.Entry.class.getCanonicalName());
        return rawMapClass.narrow(new Class[]{QName.class, String.class});
    }

    protected static JClass getQNameStringNarrowedMapEntryConsumerClass(JCodeModel jCodeModel) {
        JClass narrowedQnameMapEntryClass = JsUtilsBuilder.getQNameStringNarrowedMapEntryClass(jCodeModel);
        JClass rawConsumer = jCodeModel.ref(Consumer.class);
        return rawConsumer.narrow(narrowedQnameMapEntryClass);
    }
}

