/*
 * Decompiled with CFR 0.152.
 */
package gwt.jsonix.marshallers.xjc.plugin.builders;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JArray;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import gwt.jsonix.marshallers.xjc.plugin.dtos.ConstructorMapper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.JsPropertyMap;
import org.apache.commons.lang3.StringUtils;

public class MainJsBuilder {
    private MainJsBuilder() {
    }

    public static void generateJSInteropMainJs(Map<String, Map<String, JDefinedClass>> callbacksMap, List<JDefinedClass> containersClasses, Map<String, List<ConstructorMapper>> constructorsMap, JCodeModel jCodeModel, String mainJsName) throws JClassAlreadyExistsException {
        if (containersClasses.isEmpty()) {
            return;
        }
        String basePackage = containersClasses.get(0)._package().name();
        if (basePackage.contains(".")) {
            basePackage = basePackage.substring(0, basePackage.lastIndexOf(46));
        }
        JDefinedClass mainJsClass = MainJsBuilder.getMainJsClass(jCodeModel, basePackage, mainJsName);
        JMethod getJSONObjectMethod = MainJsBuilder.addGetJSONObjectMethod(mainJsClass, jCodeModel);
        MainJsBuilder.addGetConstructorsMap(constructorsMap, mainJsClass, getJSONObjectMethod, jCodeModel);
        MainJsBuilder.addInitializeJsInteropConstructors(mainJsClass, jCodeModel);
        for (JDefinedClass mainObject : containersClasses) {
            MainJsBuilder.populateJCodeModel(jCodeModel, (JClass)mainObject, mainJsClass, callbacksMap.get(mainObject.name()));
        }
    }

    protected static void addInitializeJsInteropConstructors(JDefinedClass mainJsClass, JCodeModel jCodeModel) {
        int mod = 89;
        JMethod method = mainJsClass.method(89, Void.TYPE, "initializeJsInteropConstructors");
        method.param(JsPropertyMap.class, "constructorsMap");
        method.annotate(jCodeModel.ref(JsMethod.class));
    }

    protected static void addGetConstructorsMap(Map<String, List<ConstructorMapper>> constructorsMap, JDefinedClass mainJsClass, JMethod getJSONObjectMethod, JCodeModel jCodeModel) {
        int mod = 17;
        JMethod method = mainJsClass.method(17, JsPropertyMap.class, "getConstructorsMap");
        method.annotate(jCodeModel.ref(JsOverlay.class));
        JBlock body = method.body();
        JClass jsPropertyMapRef = jCodeModel.ref(JsPropertyMap.class);
        JClass jsonObjectRef = jCodeModel.ref(JSONObject.class);
        JVar toReturnVar = body.decl(8, (JType)jsPropertyMapRef, "toReturn", (JExpression)jsPropertyMapRef.staticInvoke("of"));
        AtomicInteger size = new AtomicInteger(0);
        constructorsMap.values().forEach(constructorMappers -> size.addAndGet(constructorMappers.size()));
        JArray jArray = JExpr.newArray((JType)jsonObjectRef);
        constructorsMap.forEach((baseType, constructorMappers) -> constructorMappers.forEach(constructorMapper -> {
            JExpression originalTypeNameExpression = constructorMapper.getOriginalTypeName() == null ? JExpr._null() : JExpr.lit((String)constructorMapper.getOriginalTypeName());
            JExpression nameSpaceExpression = constructorMapper.getNameSpace() == null ? JExpr._null() : JExpr.lit((String)constructorMapper.getNameSpace());
            jArray.add((JExpression)JExpr.invoke((JMethod)getJSONObjectMethod).arg(JExpr.lit((String)constructorMapper.getJsiTypeName())).arg(originalTypeNameExpression).arg(nameSpaceExpression));
        }));
        JVar jsonObjectArrayVar = body.decl(8, (JType)jsonObjectRef.array(), "toSet", (JExpression)jArray);
        body.add((JStatement)toReturnVar.invoke("set").arg("constructors").arg((JExpression)jsonObjectArrayVar));
        body._return((JExpression)toReturnVar);
    }

    protected static JMethod addGetJSONObjectMethod(JDefinedClass mainJsClass, JCodeModel jCodeModel) {
        int mod = 20;
        JMethod toReturn = mainJsClass.method(20, JSONObject.class, "getJSONObjectMethod");
        toReturn.annotate(jCodeModel.ref(JsOverlay.class));
        JVar nameParam = toReturn.param(String.class, "name");
        JVar typeNameParam = toReturn.param(String.class, "typeName");
        JVar nameSpaceParam = toReturn.param(String.class, "nameSpace");
        JBlock body = toReturn.body();
        JClass jsonObjectRef = jCodeModel.ref(JSONObject.class);
        JClass jsonStringRef = jCodeModel.ref(JSONString.class);
        JVar toReturnVar = body.decl(8, (JType)jsonObjectRef, "toReturn", (JExpression)JExpr._new((JClass)jsonObjectRef));
        body.add((JStatement)toReturnVar.invoke("put").arg("name").arg((JExpression)JExpr._new((JClass)jsonStringRef).arg((JExpression)nameParam)));
        body._if(typeNameParam.ne(JExpr._null()))._then().add((JStatement)toReturnVar.invoke("put").arg("typeName").arg((JExpression)JExpr._new((JClass)jsonStringRef).arg((JExpression)typeNameParam)));
        body._if(nameSpaceParam.ne(JExpr._null()))._then().add((JStatement)toReturnVar.invoke("put").arg("nameSpace").arg((JExpression)JExpr._new((JClass)jsonStringRef).arg((JExpression)nameSpaceParam)));
        body._return((JExpression)toReturnVar);
        return toReturn;
    }

    protected static void populateJCodeModel(JCodeModel toPopulate, JClass containerRef, JDefinedClass mainJsClass, Map<String, JDefinedClass> callbackMap) {
        MainJsBuilder.addUnmarshall(toPopulate, mainJsClass, (JClass)callbackMap.get("UnmarshallCallback"));
        MainJsBuilder.addMarshall(toPopulate, mainJsClass, containerRef, (JClass)callbackMap.get("MarshallCallback"));
    }

    protected static JDefinedClass getMainJsClass(JCodeModel toPopulate, String basePackage, String mainJsName) throws JClassAlreadyExistsException {
        String fullMainJsName = basePackage + "." + mainJsName;
        JDefinedClass jDefinedClass = toPopulate._getClass(fullMainJsName);
        if (jDefinedClass == null) {
            jDefinedClass = toPopulate._class(fullMainJsName);
            JDocComment comment = jDefinedClass.javadoc();
            String commentString = "JSInterop adapter to use for marshalling/unmarshalling.";
            comment.append((Object)commentString);
            JAnnotationUse classAnnotation = jDefinedClass.annotate(toPopulate.ref(JsType.class)).param("isNative", true).param("namespace", (JExpression)toPopulate.ref(JsPackage.class).staticRef("GLOBAL"));
            if (!"MainJs".equals(mainJsName)) {
                classAnnotation.param("name", mainJsName);
            }
        }
        return jDefinedClass;
    }

    protected static void addUnmarshall(JCodeModel toPopulate, JDefinedClass mainJsClass, JClass callbackRef) {
        String unmarshallMethodName = "unmarshall";
        JClass firstParameterRef = toPopulate.ref(String.class);
        String firstParameterName = "xmlString";
        String secondParameterName = "dynamicNamespace";
        JClass secondParameterRef = toPopulate.ref(String.class);
        MainJsBuilder.addCallbackMethod(toPopulate, mainJsClass, unmarshallMethodName, firstParameterRef, firstParameterName, secondParameterRef, secondParameterName, callbackRef);
    }

    protected static void addMarshall(JCodeModel toPopulate, JDefinedClass mainJsClass, JClass firstParameterRef, JClass callbackRef) {
        String marshallMethodName = "marshall";
        String firstParameterName = StringUtils.uncapitalize((String)firstParameterRef.name());
        String secondParameterName = "namespaces";
        JClass secondParameterRef = toPopulate.ref(JavaScriptObject.class);
        MainJsBuilder.addCallbackMethod(toPopulate, mainJsClass, marshallMethodName, firstParameterRef, firstParameterName, secondParameterRef, secondParameterName, callbackRef);
    }

    protected static void addCallbackMethod(JCodeModel toPopulate, JDefinedClass jDefinedClass, String methodName, JClass firstParameterRef, String firstParameterName, JClass callbackRef) {
        int mod = 89;
        String callbackPropertyName = StringUtils.uncapitalize((String)callbackRef.name());
        JMethod method = jDefinedClass.method(mod, Void.TYPE, methodName);
        method.param((JType)firstParameterRef, firstParameterName);
        method.param((JType)callbackRef, callbackPropertyName);
        method.annotate(toPopulate.ref(JsMethod.class));
    }

    protected static void addCallbackMethod(JCodeModel toPopulate, JDefinedClass jDefinedClass, String methodName, JClass firstParameterRef, String firstParameterName, JClass secondParameterRef, String secondParameterName, JClass callbackRef) {
        int mod = 89;
        String callbackPropertyName = StringUtils.uncapitalize((String)callbackRef.name());
        JMethod method = jDefinedClass.method(mod, Void.TYPE, methodName);
        method.param((JType)firstParameterRef, firstParameterName);
        method.param((JType)secondParameterRef, secondParameterName);
        method.param((JType)callbackRef, callbackPropertyName);
        method.annotate(toPopulate.ref(JsMethod.class));
    }
}

