/*
 * Decompiled with CFR 0.152.
 */
package gwt.jsonix.marshallers.xjc.plugin.builders;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import gwt.jsonix.marshallers.xjc.plugin.utils.BuilderUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jsinterop.annotations.JsFunction;
import org.apache.commons.lang3.StringUtils;
import org.hisrc.jsonix.settings.LogLevelSetting;

public class CallbacksBuilder {
    private CallbacksBuilder() {
    }

    public static Map<String, Map<String, JDefinedClass>> generateJSInteropCallbacks(List<JDefinedClass> containersClasses, JCodeModel jCodeModel) throws JClassAlreadyExistsException {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Generating  JSInterop callbacks ...");
        HashMap<String, Map<String, JDefinedClass>> toReturn = new HashMap<String, Map<String, JDefinedClass>>();
        for (JDefinedClass containerClass : containersClasses) {
            String basePackage = containerClass._package().name();
            if (basePackage.contains(".")) {
                basePackage = basePackage.substring(0, basePackage.lastIndexOf(46));
            }
            basePackage = basePackage + ".callbacks";
            JDefinedClass unMarshallCallback = CallbacksBuilder.createUnMarshallCallback(jCodeModel, containerClass, basePackage);
            JDefinedClass marshallCallback = CallbacksBuilder.createMarshallCallback(jCodeModel, containerClass.name(), basePackage);
            HashMap<String, JDefinedClass> innerMap = new HashMap<String, JDefinedClass>();
            innerMap.put("UnmarshallCallback", unMarshallCallback);
            innerMap.put("MarshallCallback", marshallCallback);
            toReturn.put(containerClass.name(), innerMap);
        }
        return toReturn;
    }

    protected static JDefinedClass createUnMarshallCallback(JCodeModel toPopulate, JDefinedClass jDefinedClass, String basePackage) throws JClassAlreadyExistsException {
        String callbackName = jDefinedClass.name() + "UnmarshallCallback";
        String comment = "Unmarshaller callback for <code>" + jDefinedClass.name() + "</code>";
        return CallbacksBuilder.createCallback(toPopulate, callbackName, comment, (JClass)jDefinedClass, StringUtils.uncapitalize((String)jDefinedClass.name()), basePackage);
    }

    protected static JDefinedClass createMarshallCallback(JCodeModel toPopulate, String containerName, String basePackage) throws JClassAlreadyExistsException {
        String callbackName = containerName + "MarshallCallback";
        String comment = "Marshaller callback for <code>" + containerName + "</code>";
        JClass parameterRef = toPopulate.ref(String.class);
        String parameterName = "xmlString";
        return CallbacksBuilder.createCallback(toPopulate, callbackName, comment, parameterRef, parameterName, basePackage);
    }

    protected static JDefinedClass createCallback(JCodeModel toPopulate, String callbackName, String commentString, JClass parameterRef, String parameterName, String basePackage) throws JClassAlreadyExistsException {
        JDefinedClass toReturn = toPopulate._class(basePackage + "." + callbackName, ClassType.INTERFACE);
        JDocComment javadoc = toReturn.javadoc();
        javadoc.append((Object)commentString);
        toReturn.annotate(toPopulate.ref(JsFunction.class));
        CallbacksBuilder.addCallEventMethod(toReturn, parameterRef, parameterName);
        return toReturn;
    }

    protected static void addCallEventMethod(JDefinedClass jDefinedClass, JClass parameterRef, String parameterName) {
        int mod = 0;
        JMethod method = jDefinedClass.method(mod, Void.TYPE, "callEvent");
        method.param((JType)parameterRef, parameterName);
    }
}

