/*
 * Decompiled with CFR 0.152.
 */
package gwt.jsonix.marshallers.xjc.plugin.builders;

import com.google.gwt.core.client.JavaScriptObject;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import gwt.jsonix.marshallers.xjc.plugin.dtos.ConstructorMapper;
import java.util.List;
import java.util.Map;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import org.apache.commons.lang3.StringUtils;

public class MainJsBuilder {
    private MainJsBuilder() {
    }

    public static void generateJSInteropMainJs(Map<String, Map<String, JDefinedClass>> callbacksMap, List<JDefinedClass> containersClasses, Map<String, List<ConstructorMapper>> constructorsMap, JCodeModel jCodeModel, String mainJsName) throws JClassAlreadyExistsException {
        if (containersClasses.isEmpty()) {
            return;
        }
        String basePackage = containersClasses.get(0)._package().name();
        if (basePackage.contains(".")) {
            basePackage = basePackage.substring(0, basePackage.lastIndexOf(46));
        }
        JDefinedClass mainJsClass = MainJsBuilder.getMainJsClass(jCodeModel, basePackage, mainJsName);
        for (JDefinedClass mainObject : containersClasses) {
            MainJsBuilder.populateJCodeModel(jCodeModel, (JClass)mainObject, mainJsClass, callbacksMap.get(mainObject.name()));
        }
    }

    protected static void populateJCodeModel(JCodeModel toPopulate, JClass containerRef, JDefinedClass mainJsClass, Map<String, JDefinedClass> callbackMap) {
        MainJsBuilder.addUnmarshall(toPopulate, mainJsClass, (JClass)callbackMap.get("UnmarshallCallback"));
        MainJsBuilder.addMarshall(toPopulate, mainJsClass, containerRef, (JClass)callbackMap.get("MarshallCallback"));
    }

    protected static JDefinedClass getMainJsClass(JCodeModel toPopulate, String basePackage, String mainJsName) throws JClassAlreadyExistsException {
        String fullMainJsName = basePackage + "." + mainJsName;
        JDefinedClass jDefinedClass = toPopulate._getClass(fullMainJsName);
        if (jDefinedClass == null) {
            jDefinedClass = toPopulate._class(fullMainJsName);
            JDocComment comment = jDefinedClass.javadoc();
            String commentString = "JSInterop adapter to use for marshalling/unmarshalling.";
            comment.append((Object)commentString);
            JAnnotationUse classAnnotation = jDefinedClass.annotate(toPopulate.ref(JsType.class)).param("isNative", true).param("namespace", (JExpression)toPopulate.ref(JsPackage.class).staticRef("GLOBAL"));
            if (!"MainJs".equals(mainJsName)) {
                classAnnotation.param("name", mainJsName);
            }
        }
        return jDefinedClass;
    }

    protected static void addUnmarshall(JCodeModel toPopulate, JDefinedClass mainJsClass, JClass callbackRef) {
        String unmarshallMethodName = "unmarshall";
        JClass firstParameterRef = toPopulate.ref(String.class);
        String firstParameterName = "xmlString";
        String secondParameterName = "dynamicNamespace";
        JClass secondParameterRef = toPopulate.ref(String.class);
        MainJsBuilder.addCallbackMethod(toPopulate, mainJsClass, unmarshallMethodName, firstParameterRef, firstParameterName, secondParameterRef, secondParameterName, callbackRef);
    }

    protected static void addMarshall(JCodeModel toPopulate, JDefinedClass mainJsClass, JClass firstParameterRef, JClass callbackRef) {
        String marshallMethodName = "marshall";
        String firstParameterName = StringUtils.uncapitalize((String)firstParameterRef.name());
        String secondParameterName = "namespaces";
        JClass secondParameterRef = toPopulate.ref(JavaScriptObject.class);
        MainJsBuilder.addCallbackMethod(toPopulate, mainJsClass, marshallMethodName, firstParameterRef, firstParameterName, secondParameterRef, secondParameterName, callbackRef);
    }

    protected static void addCallbackMethod(JCodeModel toPopulate, JDefinedClass jDefinedClass, String methodName, JClass firstParameterRef, String firstParameterName, JClass callbackRef) {
        int mod = 89;
        String callbackPropertyName = StringUtils.uncapitalize((String)callbackRef.name());
        JMethod method = jDefinedClass.method(mod, Void.TYPE, methodName);
        method.param((JType)firstParameterRef, firstParameterName);
        method.param((JType)callbackRef, callbackPropertyName);
        method.annotate(toPopulate.ref(JsMethod.class));
    }

    protected static void addCallbackMethod(JCodeModel toPopulate, JDefinedClass jDefinedClass, String methodName, JClass firstParameterRef, String firstParameterName, JClass secondParameterRef, String secondParameterName, JClass callbackRef) {
        int mod = 89;
        String callbackPropertyName = StringUtils.uncapitalize((String)callbackRef.name());
        JMethod method = jDefinedClass.method(mod, Void.TYPE, methodName);
        method.param((JType)firstParameterRef, firstParameterName);
        method.param((JType)secondParameterRef, secondParameterName);
        method.param((JType)callbackRef, callbackPropertyName);
        method.annotate(toPopulate.ref(JsMethod.class));
    }
}

