/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.java.After;
import cucumber.api.java.Before;
import cucumber.runtime.Backend;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.DuplicateStepDefinitionException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.Reflections;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.Utils;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.java.DefaultJavaObjectFactory;
import cucumber.runtime.java.JavaHookDefinition;
import cucumber.runtime.java.JavaSnippet;
import cucumber.runtime.java.JavaStepDefinition;
import cucumber.runtime.java.ObjectFactory;
import cucumber.runtime.java.StepDefAnnotation;
import cucumber.runtime.snippets.FunctionNameSanitizer;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.formatter.model.Step;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;
import org.jvnet.hudson.annotation_indexer.Index;
import org.kohsuke.cukes.StepDefFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BetterJavaBackend
implements Backend {
    private final ClassLoader classLoader;
    private final ObjectFactory objectFactory;
    private SnippetGenerator snippetGenerator = new SnippetGenerator((Snippet)new JavaSnippet());

    public BetterJavaBackend(ResourceLoader resourceLoader) {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder(resourceLoader, this.classLoader);
        this.objectFactory = BetterJavaBackend.loadObjectFactory((ClassFinder)classFinder);
    }

    public BetterJavaBackend(ObjectFactory objectFactory, ClassLoader classLoader) {
        this.objectFactory = objectFactory;
        this.classLoader = classLoader;
    }

    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    public void buildWorld() {
        this.objectFactory.start();
    }

    public void disposeWorld() {
        this.objectFactory.stop();
    }

    public String getSnippet(Step step, FunctionNameSanitizer functionNameSanitizer) {
        return this.snippetGenerator.getSnippet(step, functionNameSanitizer);
    }

    public void loadGlue(Glue glue, List<String> gluePaths) {
        try {
            for (Method method : StepDefFinder.list(this.classLoader)) {
                for (Annotation a2 : method.getAnnotations()) {
                    if (!a2.annotationType().isAnnotationPresent(StepDefAnnotation.class)) continue;
                    this.addStepDefinition(glue, a2, method);
                }
            }
            for (Method method : Index.list(Before.class, (ClassLoader)this.classLoader, Method.class)) {
                this.addHook(glue, method.getAnnotation(Before.class), method);
            }
            for (Method method : Index.list(After.class, (ClassLoader)this.classLoader, Method.class)) {
                this.addHook(glue, method.getAnnotation(After.class), method);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    void addStepDefinition(Glue glue, Annotation annotation, Method method) {
        try {
            this.objectFactory.addClass(method.getDeclaringClass());
            glue.addStepDefinition((StepDefinition)new JavaStepDefinition(method, this.pattern(annotation), this.timeoutMillis(annotation), this.objectFactory));
        }
        catch (DuplicateStepDefinitionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CucumberException(e);
        }
    }

    public static ObjectFactory loadObjectFactory(ClassFinder classFinder) {
        ObjectFactory objectFactory;
        try {
            Reflections reflections = new Reflections(classFinder);
            objectFactory = (ObjectFactory)reflections.instantiateExactlyOneSubclass(ObjectFactory.class, "cucumber.runtime", new Class[0], new Object[0]);
        }
        catch (CucumberException ce) {
            objectFactory = new DefaultJavaObjectFactory();
        }
        return objectFactory;
    }

    private Pattern pattern(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("value", new Class[0]);
        String regexpString = (String)Utils.invoke((Object)annotation, (Method)regexpMethod, (long)0L, (Object[])new Object[0]);
        return Pattern.compile(regexpString);
    }

    private long timeoutMillis(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("timeout", new Class[0]);
        return (Long)Utils.invoke((Object)annotation, (Method)regexpMethod, (long)0L, (Object[])new Object[0]);
    }

    void addHook(Glue glue, Annotation annotation, Method method) {
        this.objectFactory.addClass(method.getDeclaringClass());
        if (annotation.annotationType().equals(Before.class)) {
            String[] tagExpressions = ((Before)annotation).value();
            long timeout = ((Before)annotation).timeout();
            glue.addBeforeHook((HookDefinition)new JavaHookDefinition(method, tagExpressions, ((Before)annotation).order(), timeout, this.objectFactory));
        } else {
            String[] tagExpressions = ((After)annotation).value();
            long timeout = ((After)annotation).timeout();
            glue.addAfterHook((HookDefinition)new JavaHookDefinition(method, tagExpressions, ((After)annotation).order(), timeout, this.objectFactory));
        }
    }
}

