/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.markdown;

import com.petebevin.markdown.MarkdownProcessor;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.doxia.module.markdown.MarkdownParseException;
import org.apache.maven.doxia.parser.AbstractParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;

public class MarkdownParser
extends AbstractParser {
    public void parse(Reader reader, Sink sink) throws ParseException {
        String txt;
        this.getLog().info((CharSequence)"markdown.parse()");
        MarkdownProcessor processor = new MarkdownProcessor();
        try {
            txt = this.readText(reader);
            this.getLog().info((CharSequence)("Markdown content is " + txt));
        }
        catch (IOException e) {
            throw new MarkdownParseException("Cannot read input file", e);
        }
        String html = processor.markdown(txt);
        sink.rawText(html);
        sink.flush();
        sink.close();
    }

    private String readText(Reader reader) throws IOException {
        StringBuffer sb = new StringBuffer();
        char[] buffer = new char[256];
        int count = 0;
        while ((count = reader.read(buffer)) > 0) {
            String readData = String.valueOf(buffer, 0, count);
            sb.append(readData);
            buffer = new char[1024];
        }
        reader.close();
        return sb.toString();
    }
}

