/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.file_leak_detector;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.instrument.Instrumentation;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.zip.ZipFile;
import org.kohsuke.asm3.Label;
import org.kohsuke.asm3.MethodAdapter;
import org.kohsuke.asm3.MethodVisitor;
import org.kohsuke.asm3.Type;
import org.kohsuke.asm3.commons.LocalVariablesSorter;
import org.kohsuke.file_leak_detector.ActivityListener;
import org.kohsuke.file_leak_detector.Listener;
import org.kohsuke.file_leak_detector.transform.ClassTransformSpec;
import org.kohsuke.file_leak_detector.transform.CodeGenerator;
import org.kohsuke.file_leak_detector.transform.MethodAppender;
import org.kohsuke.file_leak_detector.transform.TransformerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentMain {
    public static void agentmain(String agentArguments, Instrumentation instrumentation) throws Exception {
        AgentMain.premain(agentArguments, instrumentation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void premain(String agentArguments, Instrumentation instrumentation) throws Exception {
        int serverPort = -1;
        if (agentArguments != null) {
            block3: for (String t : agentArguments.split(",")) {
                if (t.equals("help")) {
                    AgentMain.usageAndQuit();
                    continue;
                }
                if (t.startsWith("threshold=")) {
                    Listener.THRESHOLD = Integer.parseInt(t.substring(t.indexOf(61) + 1));
                    continue;
                }
                if (t.equals("trace")) {
                    Listener.TRACE = new PrintWriter(System.err);
                    continue;
                }
                if (t.equals("strong")) {
                    Listener.makeStrong();
                    continue;
                }
                if (t.startsWith("http=")) {
                    serverPort = Integer.parseInt(t.substring(t.indexOf(61) + 1));
                    continue;
                }
                if (t.startsWith("trace=")) {
                    Listener.TRACE = new PrintWriter(new FileOutputStream(t.substring(6)));
                    continue;
                }
                if (t.startsWith("error=")) {
                    Listener.ERROR = new PrintWriter(new FileOutputStream(t.substring(6)));
                    continue;
                }
                if (t.startsWith("listener=")) {
                    ActivityListener.LIST.add((ActivityListener)AgentMain.class.getClassLoader().loadClass(t.substring(9)).newInstance());
                    continue;
                }
                if (t.equals("dumpatshutdown")) {
                    Runtime.getRuntime().addShutdownHook(new Thread("File handles dumping shutdown hook"){

                        public void run() {
                            Listener.dump(System.err);
                        }
                    });
                    continue;
                }
                if (t.startsWith("excludes=")) {
                    BufferedReader reader = new BufferedReader(new FileReader(t.substring(9)));
                    try {
                        while (true) {
                            String line;
                            if ((line = reader.readLine()) == null) {
                                continue block3;
                            }
                            String str = line.trim();
                            if (str.isEmpty() || str.startsWith("#")) continue;
                            Listener.EXCLUDES.add(str);
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                System.err.println("Unknown option: " + t);
                AgentMain.usageAndQuit();
            }
        }
        System.err.println("File leak detector installed");
        Listener.AGENT_INSTALLED = true;
        instrumentation.addTransformer(new TransformerImpl(AgentMain.createSpec()), true);
        instrumentation.retransformClasses(FileInputStream.class, FileOutputStream.class, RandomAccessFile.class, Class.forName("java.net.PlainSocketImpl"), ZipFile.class);
        if (serverPort >= 0) {
            AgentMain.runHttpServer(serverPort);
        }
    }

    private static void runHttpServer(int port) throws IOException {
        final ServerSocket ss = new ServerSocket();
        ss.bind(new InetSocketAddress("localhost", port));
        System.err.println("Serving file leak stats on http://localhost:" + ss.getLocalPort() + "/ for stats");
        final ExecutorService es = Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        });
        es.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                while (true) {
                    final Socket s = ss.accept();
                    es.submit(new Callable<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Void call() throws Exception {
                            try {
                                BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
                                in.readLine();
                                PrintWriter w = new PrintWriter(new OutputStreamWriter(s.getOutputStream(), "UTF-8"));
                                w.print("HTTP/1.0 200 OK\r\nContent-Type: text/plain;charset=UTF-8\r\n\r\n");
                                Listener.dump(w);
                            }
                            finally {
                                s.close();
                            }
                            return null;
                        }
                    });
                }
            }
        });
    }

    private static void usageAndQuit() {
        System.err.println("File leak detector arguments (to specify multiple values, separate them by ',':");
        AgentMain.printOptions();
        System.exit(-1);
    }

    static void printOptions() {
        System.err.println("  help          - show the help screen.");
        System.err.println("  trace         - log every open/close operation to stderr.");
        System.err.println("  trace=FILE    - log every open/close operation to the given file.");
        System.err.println("  error=FILE    - if 'too many open files' error is detected, send the dump here.");
        System.err.println("                  by default it goes to stderr.");
        System.err.println("  threshold=N   - instead of waiting until 'too many open files', dump once");
        System.err.println("                  we have N descriptors open.");
        System.err.println("  http=PORT     - Run a mini HTTP server that you can access to get stats on demand");
        System.err.println("                  Specify 0 to choose random available port, -1 to disable, which is default.");
        System.err.println("  strong        - Don't let GC auto-close leaking file descriptors");
        System.err.println("  listener=S    - Specify the fully qualified name of ActivityListener class to activate from beginning");
        System.err.println("  dumpatshutdown- Dump open file handles at shutdown");
        System.err.println("  excludes=FILE - Ignore files opened directly/indirectly in specific methods.");
        System.err.println("                  File lists 'some.pkg.ClassName.methodName' patterns.");
    }

    static List<ClassTransformSpec> createSpec() {
        return Arrays.asList(AgentMain.newSpec(FileOutputStream.class, "(Ljava/io/File;Z)V"), AgentMain.newSpec(FileInputStream.class, "(Ljava/io/File;)V"), AgentMain.newSpec(RandomAccessFile.class, "(Ljava/io/File;Ljava/lang/String;)V"), AgentMain.newSpec(ZipFile.class, "(Ljava/io/File;I)V"), new ClassTransformSpec("java/net/PlainSocketImpl", new OpenSocketInterceptor("create", "(Z)V"), new AcceptInterceptor("accept", "(Ljava/net/SocketImpl;)V"), new CloseInterceptor("socketClose")), new ClassTransformSpec("sun/nio/ch/SocketChannelImpl", new OpenSocketInterceptor("<init>", "(Ljava/nio/channels/spi/SelectorProvider;)V"), new CloseInterceptor("kill")));
    }

    private static ClassTransformSpec newSpec(Class c, String constructorDesc) {
        String binName = c.getName().replace('.', '/');
        return new ClassTransformSpec(binName, new ConstructorOpenInterceptor(constructorDesc, binName), new CloseInterceptor());
    }

    private static class ConstructorOpenInterceptor
    extends MethodAppender {
        private final String binName;

        public ConstructorOpenInterceptor(String constructorDesc, String binName) {
            super("<init>", constructorDesc);
            this.binName = binName;
        }

        public MethodVisitor newAdapter(MethodVisitor base, int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor b = super.newAdapter(base, access, name, desc, signature, exceptions);
            return new OpenInterceptionAdapter(b, access, desc){

                @Override
                protected boolean toIntercept(String owner, String name) {
                    return owner.equals(ConstructorOpenInterceptor.this.binName) && name.startsWith("open");
                }

                @Override
                protected Class<? extends Exception> getExpectedException() {
                    return FileNotFoundException.class;
                }
            };
        }

        protected void append(CodeGenerator g) {
            g.invokeAppStatic(Listener.class, "open", new Class[]{Object.class, File.class}, new int[]{0, 1});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class OpenInterceptionAdapter
    extends MethodAdapter {
        private final LocalVariablesSorter lvs;
        private final MethodVisitor base;

        private OpenInterceptionAdapter(MethodVisitor base, int access, String desc) {
            super(null);
            this.lvs = new LocalVariablesSorter(access, desc, base);
            this.mv = this.lvs;
            this.base = base;
        }

        protected abstract boolean toIntercept(String var1, String var2);

        protected Class<? extends Exception> getExpectedException() {
            return IOException.class;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (this.toIntercept(owner, name)) {
                Type exceptionType = Type.getType(this.getExpectedException());
                CodeGenerator g = new CodeGenerator(this.mv);
                Label s = new Label();
                Label e = new Label();
                Label h = new Label();
                Label tail = new Label();
                g.visitTryCatchBlock(s, e, h, exceptionType.getInternalName());
                g.visitLabel(s);
                super.visitMethodInsn(opcode, owner, name, desc);
                g._goto(tail);
                g.visitLabel(e);
                g.visitLabel(h);
                int ex = this.lvs.newLocal(exceptionType);
                g.dup();
                this.base.visitVarInsn(58, ex);
                g.invokeVirtual(exceptionType.getInternalName(), "getMessage", "()Ljava/lang/String;");
                g.ldc("Too many open files");
                g.invokeVirtual("java/lang/String", "contains", "(Ljava/lang/CharSequence;)Z");
                Label rethrow = new Label();
                g.ifFalse(rethrow);
                g.invokeAppStatic(Listener.class, "outOfDescriptors", new Class[0], new int[0]);
                g.visitLabel(rethrow);
                this.base.visitVarInsn(25, ex);
                g.athrow();
                g.visitLabel(tail);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc);
            }
        }
    }

    private static class AcceptInterceptor
    extends MethodAppender {
        public AcceptInterceptor(String name, String desc) {
            super(name, desc);
        }

        public MethodVisitor newAdapter(MethodVisitor base, int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor b = super.newAdapter(base, access, name, desc, signature, exceptions);
            return new OpenInterceptionAdapter(b, access, desc){

                protected boolean toIntercept(String owner, String name) {
                    return name.equals("socketAccept");
                }
            };
        }

        protected void append(CodeGenerator g) {
            g.invokeAppStatic(Listener.class, "openSocket", new Class[]{Object.class}, new int[]{1});
        }
    }

    private static class OpenSocketInterceptor
    extends MethodAppender {
        public OpenSocketInterceptor(String name, String desc) {
            super(name, desc);
        }

        public MethodVisitor newAdapter(MethodVisitor base, int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor b = super.newAdapter(base, access, name, desc, signature, exceptions);
            return new OpenInterceptionAdapter(b, access, desc){

                protected boolean toIntercept(String owner, String name) {
                    return name.equals("socketCreate");
                }
            };
        }

        protected void append(CodeGenerator g) {
            g.invokeAppStatic(Listener.class, "openSocket", new Class[]{Object.class}, new int[]{0});
        }
    }

    private static class CloseInterceptor
    extends MethodAppender {
        public CloseInterceptor() {
            this("close");
        }

        public CloseInterceptor(String methodName) {
            super(methodName, "()V");
        }

        protected void append(CodeGenerator g) {
            g.invokeAppStatic(Listener.class, "close", new Class[]{Object.class}, new int[]{0});
        }
    }
}

