/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URL;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitUser;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
public class GHPullRequestCommitDetail {
    private GHPullRequest owner;
    String sha;
    Commit commit;
    String url;
    String html_url;
    String comments_url;
    CommitPointer[] parents;

    void wrapUp(GHPullRequest owner) {
        this.owner = owner;
    }

    public String getSha() {
        return this.sha;
    }

    public Commit getCommit() {
        return this.commit;
    }

    public URL getApiUrl() {
        return GitHubClient.parseURL(this.url);
    }

    public URL getUrl() {
        return GitHubClient.parseURL(this.html_url);
    }

    public URL getCommentsUrl() {
        return GitHubClient.parseURL(this.comments_url);
    }

    public CommitPointer[] getParents() {
        CommitPointer[] newValue = new CommitPointer[this.parents.length];
        System.arraycopy(this.parents, 0, newValue, 0, this.parents.length);
        return newValue;
    }

    public static class Commit {
        Authorship author;
        Authorship committer;
        String message;
        Tree tree;
        String url;
        int comment_count;

        @WithBridgeMethods(value={Authorship.class}, castRequired=true)
        public GitUser getAuthor() {
            return this.author;
        }

        @WithBridgeMethods(value={Authorship.class}, castRequired=true)
        public GitUser getCommitter() {
            return this.committer;
        }

        public String getMessage() {
            return this.message;
        }

        public URL getUrl() {
            return GitHubClient.parseURL(this.url);
        }

        public int getComment_count() {
            return this.comment_count;
        }

        public Tree getTree() {
            return this.tree;
        }
    }

    public static class CommitPointer {
        String sha;
        String url;
        String html_url;

        public URL getUrl() {
            return GitHubClient.parseURL(this.url);
        }

        public URL getHtml_url() {
            return GitHubClient.parseURL(this.html_url);
        }

        public String getSha() {
            return this.sha;
        }
    }

    public static class Tree {
        String sha;
        String url;

        public String getSha() {
            return this.sha;
        }

        public URL getUrl() {
            return GitHubClient.parseURL(this.url);
        }
    }

    public static class Authorship
    extends GitUser {
    }
}

