/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.kohsuke.github.GHAppInstallation;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;

public class GHApp
extends GHObject {
    private GitHub root;
    private GHUser owner;
    private String name;
    private String description;
    private String externalUrl;
    private Map<String, String> permissions;
    private List<GHEvent> events;
    private long installationsCount;
    private String htmlUrl;

    public GHUser getOwner() {
        return this.owner;
    }

    public void setOwner(GHUser owner) {
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    public List<GHEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<GHEvent> events) {
        this.events = events;
    }

    public long getInstallationsCount() {
        return this.installationsCount;
    }

    public void setInstallationsCount(long installationsCount) {
        this.installationsCount = installationsCount;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHub.parseURL(this.htmlUrl);
    }

    public Map<String, String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Map<String, String> permissions) {
        this.permissions = permissions;
    }

    GHApp wrapUp(GitHub root) {
        this.root = root;
        return this;
    }

    @Preview
    @Deprecated
    public PagedIterable<GHAppInstallation> listInstallations() {
        return this.root.retrieve().withPreview("application/vnd.github.machine-man-preview+json").asPagedIterable("/app/installations", GHAppInstallation[].class, item -> item.wrapUp(this.root));
    }

    @Preview
    @Deprecated
    public GHAppInstallation getInstallationById(long id) throws IOException {
        return ((GHAppInstallation)((Object)this.root.retrieve().withPreview("application/vnd.github.machine-man-preview+json").to(String.format("/app/installations/%d", id), GHAppInstallation.class))).wrapUp(this.root);
    }

    @Preview
    @Deprecated
    public GHAppInstallation getInstallationByOrganization(String name) throws IOException {
        return ((GHAppInstallation)((Object)this.root.retrieve().withPreview("application/vnd.github.machine-man-preview+json").to(String.format("/orgs/%s/installation", name), GHAppInstallation.class))).wrapUp(this.root);
    }

    @Preview
    @Deprecated
    public GHAppInstallation getInstallationByRepository(String ownerName, String repositoryName) throws IOException {
        return ((GHAppInstallation)((Object)this.root.retrieve().withPreview("application/vnd.github.machine-man-preview+json").to(String.format("/repos/%s/%s/installation", ownerName, repositoryName), GHAppInstallation.class))).wrapUp(this.root);
    }

    @Preview
    @Deprecated
    public GHAppInstallation getInstallationByUser(String name) throws IOException {
        return ((GHAppInstallation)((Object)this.root.retrieve().withPreview("application/vnd.github.machine-man-preview+json").to(String.format("/users/%s/installation", name), GHAppInstallation.class))).wrapUp(this.root);
    }
}

