/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collection;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Requester;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
public class GHBranchProtection {
    private static final String REQUIRE_SIGNATURES_URI = "/required_signatures";
    @JsonProperty
    private EnforceAdmins enforceAdmins;
    private GitHub root;
    @JsonProperty(value="required_pull_request_reviews")
    private RequiredReviews requiredReviews;
    @JsonProperty
    private RequiredStatusChecks requiredStatusChecks;
    @JsonProperty
    private Restrictions restrictions;
    @JsonProperty
    private String url;

    @Preview
    @Deprecated
    public void enabledSignedCommits() throws IOException {
        this.requester().method("POST").to(this.url + REQUIRE_SIGNATURES_URI, RequiredSignatures.class);
    }

    @Preview
    @Deprecated
    public void disableSignedCommits() throws IOException {
        this.requester().method("DELETE").to(this.url + REQUIRE_SIGNATURES_URI);
    }

    public EnforceAdmins getEnforceAdmins() {
        return this.enforceAdmins;
    }

    public RequiredReviews getRequiredReviews() {
        return this.requiredReviews;
    }

    @Preview
    @Deprecated
    public boolean getRequiredSignatures() throws IOException {
        return ((RequiredSignatures)((Object)this.requester().method("GET").to(this.url + REQUIRE_SIGNATURES_URI, RequiredSignatures.class))).enabled;
    }

    public RequiredStatusChecks getRequiredStatusChecks() {
        return this.requiredStatusChecks;
    }

    public Restrictions getRestrictions() {
        return this.restrictions;
    }

    public String getUrl() {
        return this.url;
    }

    GHBranchProtection wrap(GHBranch branch) {
        this.root = branch.getRoot();
        return this;
    }

    private Requester requester() {
        return new Requester(this.root).withPreview("application/vnd.github.zzzax-preview+json");
    }

    public static class Restrictions {
        @JsonProperty
        private Collection<GHTeam> teams;
        private String teamsUrl;
        @JsonProperty
        private String url;
        @JsonProperty
        private Collection<GHUser> users;
        private String usersUrl;

        public Collection<GHTeam> getTeams() {
            return this.teams;
        }

        public String getTeamsUrl() {
            return this.teamsUrl;
        }

        public String getUrl() {
            return this.url;
        }

        public Collection<GHUser> getUsers() {
            return this.users;
        }

        public String getUsersUrl() {
            return this.usersUrl;
        }
    }

    public static class RequiredStatusChecks {
        @JsonProperty
        private Collection<String> contexts;
        @JsonProperty
        private boolean strict;
        @JsonProperty
        private String url;

        public Collection<String> getContexts() {
            return this.contexts;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isRequiresBranchUpToDate() {
            return this.strict;
        }
    }

    private static class RequiredSignatures {
        @JsonProperty
        private boolean enabled;
        @JsonProperty
        private String url;

        private RequiredSignatures() {
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class RequiredReviews {
        @JsonProperty(value="dismissal_restrictions")
        private Restrictions dismissalRestriction;
        private boolean dismissStaleReviews;
        private boolean requireCodeOwnerReviews;
        @JsonProperty(value="required_approving_review_count")
        private int requiredReviewers;
        @JsonProperty
        private String url;

        public Restrictions getDismissalRestrictions() {
            return this.dismissalRestriction;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isDismissStaleReviews() {
            return this.dismissStaleReviews;
        }

        public boolean isRequireCodeOwnerReviews() {
            return this.requireCodeOwnerReviews;
        }

        public int getRequiredReviewers() {
            return this.requiredReviewers;
        }
    }

    public static class EnforceAdmins {
        @JsonProperty
        private boolean enabled;
        @JsonProperty
        private String url;

        public String getUrl() {
            return this.url;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

