/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Base64InputStream;
import org.kohsuke.github.GHContentUpdateResponse;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Refreshable;
import org.kohsuke.github.Requester;

public class GHContent
implements Refreshable {
    private GHRepository repository;
    private GitHub root;
    private String type;
    private String encoding;
    private long size;
    private String sha;
    private String name;
    private String path;
    private String content;
    private String url;
    private String git_url;
    private String html_url;
    private String download_url;

    public GHRepository getOwner() {
        return this.repository;
    }

    public String getType() {
        return this.type;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public long getSize() {
        return this.size;
    }

    public String getSha() {
        return this.sha;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public String getContent() throws IOException {
        return new String(Base64.decodeBase64((String)this.getEncodedContent()));
    }

    public String getEncodedContent() throws IOException {
        this.refresh(this.content);
        return this.content;
    }

    public String getUrl() {
        return this.url;
    }

    public String getGitUrl() {
        return this.git_url;
    }

    public String getHtmlUrl() {
        return this.html_url;
    }

    public InputStream read() throws IOException {
        this.refresh(this.content);
        if (this.encoding.equals("base64")) {
            try {
                return new Base64InputStream((InputStream)new ByteArrayInputStream(this.content.getBytes("US-ASCII")), false);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        throw new UnsupportedOperationException("Unrecognized encoding: " + this.encoding);
    }

    public String getDownloadUrl() throws IOException {
        this.refresh(this.download_url);
        return this.download_url;
    }

    public boolean isFile() {
        return "file".equals(this.type);
    }

    public boolean isDirectory() {
        return "dir".equals(this.type);
    }

    protected synchronized void populate() throws IOException {
        this.root.retrieve().to(this.url, this);
    }

    public PagedIterable<GHContent> listDirectoryContent() throws IOException {
        if (!this.isDirectory()) {
            throw new IllegalStateException(this.path + " is not a directory");
        }
        return this.root.retrieve().asPagedIterable(this.url, GHContent[].class, item -> item.wrap(this.repository));
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public GHContentUpdateResponse update(String newContent, String commitMessage) throws IOException {
        return this.update(newContent.getBytes(), commitMessage, null);
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public GHContentUpdateResponse update(String newContent, String commitMessage, String branch) throws IOException {
        return this.update(newContent.getBytes(), commitMessage, branch);
    }

    public GHContentUpdateResponse update(byte[] newContentBytes, String commitMessage) throws IOException {
        return this.update(newContentBytes, commitMessage, null);
    }

    public GHContentUpdateResponse update(byte[] newContentBytes, String commitMessage, String branch) throws IOException {
        String encodedContent = Base64.encodeBase64String((byte[])newContentBytes);
        Requester requester = new Requester(this.root).with("path", this.path).with("message", commitMessage).with("sha", this.sha).with("content", encodedContent).method("PUT");
        if (branch != null) {
            requester.with("branch", branch);
        }
        GHContentUpdateResponse response = (GHContentUpdateResponse)((Object)requester.to(GHContent.getApiRoute(this.repository, this.path), GHContentUpdateResponse.class));
        response.getContent().wrap(this.repository);
        response.getCommit().wrapUp(this.repository);
        this.content = encodedContent;
        return response;
    }

    public GHContentUpdateResponse delete(String message) throws IOException {
        return this.delete(message, null);
    }

    public GHContentUpdateResponse delete(String commitMessage, String branch) throws IOException {
        Requester requester = new Requester(this.root).with("path", this.path).with("message", commitMessage).with("sha", this.sha).method("DELETE");
        if (branch != null) {
            requester.with("branch", branch);
        }
        GHContentUpdateResponse response = (GHContentUpdateResponse)((Object)requester.to(GHContent.getApiRoute(this.repository, this.path), GHContentUpdateResponse.class));
        response.getCommit().wrapUp(this.repository);
        return response;
    }

    static String getApiRoute(GHRepository repository, String path) {
        return repository.getApiTailUrl("contents/" + path);
    }

    GHContent wrap(GHRepository owner) {
        this.repository = owner;
        this.root = owner.root;
        return this;
    }

    GHContent wrap(GitHub root) {
        this.root = root;
        if (this.repository != null) {
            this.repository.wrap(root);
        }
        return this;
    }

    public static GHContent[] wrap(GHContent[] contents, GHRepository repository) {
        for (GHContent unwrappedContent : contents) {
            unwrappedContent.wrap(repository);
        }
        return contents;
    }

    @Override
    public synchronized void refresh() throws IOException {
        this.root.retrieve().to(this.url, this);
    }
}

