/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestReview;
import org.kohsuke.github.GHPullRequestReviewEvent;
import org.kohsuke.github.Requester;

public class GHPullRequestReviewBuilder {
    private final GHPullRequest pr;
    private final Requester builder;
    private final List<DraftReviewComment> comments = new ArrayList<DraftReviewComment>();

    GHPullRequestReviewBuilder(GHPullRequest pr) {
        this.pr = pr;
        this.builder = new Requester(pr.root);
    }

    public GHPullRequestReviewBuilder commitId(String commitId) {
        this.builder.with("commit_id", commitId);
        return this;
    }

    public GHPullRequestReviewBuilder body(String body) {
        this.builder.with("body", body);
        return this;
    }

    public GHPullRequestReviewBuilder event(GHPullRequestReviewEvent event) {
        this.builder.with("event", event.action());
        return this;
    }

    public GHPullRequestReviewBuilder comment(String body, String path, int position) {
        this.comments.add(new DraftReviewComment(body, path, position));
        return this;
    }

    public GHPullRequestReview create() throws IOException {
        return ((GHPullRequestReview)((Object)this.builder.method("POST").with("comments", this.comments).to(this.pr.getApiRoute() + "/reviews", GHPullRequestReview.class))).wrapUp(this.pr);
    }

    private static class DraftReviewComment {
        private String body;
        private String path;
        private int position;

        DraftReviewComment(String body, String path, int position) {
            this.body = body;
            this.path = path;
            this.position = position;
        }

        public String getBody() {
            return this.body;
        }

        public String getPath() {
            return this.path;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

