/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHQueryBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.PagedSearchIterable;
import org.kohsuke.github.SearchResult;

public abstract class GHSearchBuilder<T>
extends GHQueryBuilder<T> {
    protected final List<String> terms = new ArrayList<String>();
    private final Class<? extends SearchResult<T>> receiverType;

    GHSearchBuilder(GitHub root, Class<? extends SearchResult<T>> receiverType) {
        super(root);
        this.receiverType = receiverType;
    }

    public GHQueryBuilder<T> q(String term) {
        this.terms.add(term);
        return this;
    }

    @Override
    public PagedSearchIterable<T> list() {
        return new PagedSearchIterable<T>(this.root){

            @Override
            public PagedIterator<T> _iterator(int pageSize) {
                GHSearchBuilder.this.req.set("q", StringUtils.join(GHSearchBuilder.this.terms, (String)" "));
                return new PagedIterator<T>(this.adapt(GHSearchBuilder.this.req.asIterator(GHSearchBuilder.this.getApiUrl(), GHSearchBuilder.this.receiverType, pageSize))){

                    @Override
                    protected void wrapUp(T[] page) {
                    }
                };
            }
        };
    }

    protected abstract String getApiUrl();
}

