/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.Requester;

public class GHIssueBuilder {
    private final GHRepository repo;
    private final Requester builder;
    private List<String> labels = new ArrayList<String>();
    private List<String> assignees = new ArrayList<String>();

    GHIssueBuilder(GHRepository repo, String title) {
        this.repo = repo;
        this.builder = repo.root.createRequest().method("POST");
        this.builder.with("title", title);
    }

    public GHIssueBuilder body(String str) {
        this.builder.with("body", str);
        return this;
    }

    public GHIssueBuilder assignee(GHUser user) {
        if (user != null) {
            this.assignees.add(user.getLogin());
        }
        return this;
    }

    public GHIssueBuilder assignee(String user) {
        if (user != null) {
            this.assignees.add(user);
        }
        return this;
    }

    public GHIssueBuilder milestone(GHMilestone milestone) {
        if (milestone != null) {
            this.builder.with("milestone", milestone.getNumber());
        }
        return this;
    }

    public GHIssueBuilder label(String label) {
        if (label != null) {
            this.labels.add(label);
        }
        return this;
    }

    public GHIssue create() throws IOException {
        return this.builder.with("labels", this.labels).with("assignees", this.assignees).withUrlPath(this.repo.getApiTailUrl("issues")).fetch(GHIssue.class).wrap(this.repo);
    }
}

