/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GHCommentAuthorAssociation;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHReaction;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Reactable;
import org.kohsuke.github.ReactionContent;

public class GHIssueComment
extends GHObject
implements Reactable {
    GHIssue owner;
    private String body;
    private String gravatar_id;
    private String html_url;
    private String author_association;
    private GHUser user;

    GHIssueComment wrapUp(GHIssue owner) {
        this.owner = owner;
        return this;
    }

    public GHIssue getParent() {
        return this.owner;
    }

    public String getBody() {
        return this.body;
    }

    @Deprecated
    public String getUserName() {
        return this.user.getLogin();
    }

    public GHUser getUser() throws IOException {
        return this.owner == null || this.owner.root.isOffline() ? this.user : this.owner.root.getUser(this.user.getLogin());
    }

    @Override
    public URL getHtmlUrl() {
        return GitHub.parseURL(this.html_url);
    }

    public GHCommentAuthorAssociation getAuthorAssociation() {
        return GHCommentAuthorAssociation.valueOf(this.author_association);
    }

    public void update(String body) throws IOException {
        this.owner.root.createRequest().method("PATCH").with("body", body).withUrlPath(this.getApiRoute()).fetch(GHIssueComment.class);
        this.body = body;
    }

    public void delete() throws IOException {
        this.owner.root.createRequest().method("DELETE").withUrlPath(this.getApiRoute()).send();
    }

    @Override
    @Preview
    @Deprecated
    public GHReaction createReaction(ReactionContent content) throws IOException {
        return this.owner.root.createRequest().method("POST").withPreview("application/vnd.github.squirrel-girl-preview+json").with("content", content.getContent()).withUrlPath(this.getApiRoute() + "/reactions").fetch(GHReaction.class).wrap(this.owner.root);
    }

    @Override
    @Preview
    @Deprecated
    public PagedIterable<GHReaction> listReactions() {
        return this.owner.root.createRequest().withPreview("application/vnd.github.squirrel-girl-preview+json").withUrlPath(this.getApiRoute() + "/reactions").toIterable(GHReaction[].class, item -> item.wrap(this.owner.root));
    }

    private String getApiRoute() {
        return "/repos/" + this.owner.getRepository().getOwnerName() + "/" + this.owner.getRepository().getName() + "/issues/comments/" + this.id;
    }
}

