/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GitHub;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
@BridgeMethodsAdded
public class GHLicense
extends GHObject {
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    GitHub root;
    protected String key;
    protected String name;
    protected Boolean featured;
    protected String html_url;
    protected String description;
    protected String category;
    protected String implementation;
    protected String body;
    protected List<String> required = new ArrayList<String>();
    protected List<String> permitted = new ArrayList<String>();
    protected List<String> forbidden = new ArrayList<String>();

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    @Override
    @WithBridgeMethods(value={String.class}, adapterMethod="urlToString")
    public URL getUrl() {
        return GitHub.parseURL(this.url);
    }

    public Boolean isFeatured() throws IOException {
        this.populate();
        return this.featured;
    }

    @Override
    public URL getHtmlUrl() throws IOException {
        this.populate();
        return GitHub.parseURL(this.html_url);
    }

    public String getDescription() throws IOException {
        this.populate();
        return this.description;
    }

    public String getCategory() throws IOException {
        this.populate();
        return this.category;
    }

    public String getImplementation() throws IOException {
        this.populate();
        return this.implementation;
    }

    public List<String> getRequired() throws IOException {
        this.populate();
        return this.required;
    }

    public List<String> getPermitted() throws IOException {
        this.populate();
        return this.permitted;
    }

    public List<String> getForbidden() throws IOException {
        this.populate();
        return this.forbidden;
    }

    public String getBody() throws IOException {
        this.populate();
        return this.body;
    }

    protected synchronized void populate() throws IOException {
        if (this.description != null) {
            return;
        }
        this.root.createRequest().withUrlPath(this.url).fetchInto(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GHLicense)) {
            return false;
        }
        GHLicense that = (GHLicense)o;
        return this.url.equals(that.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    GHLicense wrap(GitHub root) {
        this.root = root;
        return this;
    }
}

