/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import javax.annotation.CheckForNull;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHReaction;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Reactable;
import org.kohsuke.github.ReactionContent;

public class GHPullRequestReviewComment
extends GHObject
implements Reactable {
    GHPullRequest owner;
    private String body;
    private GHUser user;
    private String path;
    private int position = -1;
    private int original_position = -1;
    private long in_reply_to_id = -1L;

    public static GHPullRequestReviewComment draft(String body, String path, int position) {
        GHPullRequestReviewComment result = new GHPullRequestReviewComment();
        result.body = body;
        result.path = path;
        result.position = position;
        return result;
    }

    GHPullRequestReviewComment wrapUp(GHPullRequest owner) {
        this.owner = owner;
        return this;
    }

    public GHPullRequest getParent() {
        return this.owner;
    }

    public String getBody() {
        return this.body;
    }

    public GHUser getUser() throws IOException {
        return this.owner.root.getUser(this.user.getLogin());
    }

    public String getPath() {
        return this.path;
    }

    @CheckForNull
    public int getPosition() {
        return this.position;
    }

    public int getOriginalPosition() {
        return this.original_position;
    }

    @CheckForNull
    public long getInReplyToId() {
        return this.in_reply_to_id;
    }

    @Override
    public URL getHtmlUrl() {
        return null;
    }

    protected String getApiRoute() {
        return "/repos/" + this.owner.getRepository().getFullName() + "/pulls/comments/" + this.id;
    }

    public void update(String body) throws IOException {
        this.owner.root.createRequest().method("PATCH").with("body", body).withUrlPath(this.getApiRoute()).fetchInto(this);
        this.body = body;
    }

    public void delete() throws IOException {
        this.owner.root.createRequest().method("DELETE").withUrlPath(this.getApiRoute()).send();
    }

    public GHPullRequestReviewComment reply(String body) throws IOException {
        return this.owner.root.createRequest().method("POST").with("body", body).with("in_reply_to", this.getId()).withUrlPath(this.getApiRoute() + "/comments").fetch(GHPullRequestReviewComment.class).wrapUp(this.owner);
    }

    @Override
    @Preview
    @Deprecated
    public GHReaction createReaction(ReactionContent content) throws IOException {
        return this.owner.root.createRequest().method("POST").withPreview("application/vnd.github.squirrel-girl-preview+json").with("content", content.getContent()).withUrlPath(this.getApiRoute() + "/reactions").fetch(GHReaction.class).wrap(this.owner.root);
    }

    @Override
    @Preview
    @Deprecated
    public PagedIterable<GHReaction> listReactions() {
        return this.owner.root.createRequest().withPreview("application/vnd.github.squirrel-girl-preview+json").withUrlPath(this.getApiRoute() + "/reactions").toIterable(GHReaction[].class, item -> item.wrap(this.owner.root));
    }
}

