/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

public class GHTeamBuilder {
    private final GitHub root;
    protected final Requester builder;
    private final String orgName;

    public GHTeamBuilder(GitHub root, String orgName, String name) {
        this.root = root;
        this.orgName = orgName;
        this.builder = root.createRequest();
        this.builder.with("name", name);
    }

    public GHTeamBuilder description(String description) {
        this.builder.with("description", description);
        return this;
    }

    public GHTeamBuilder maintainers(String ... maintainers) {
        this.builder.with("maintainers", maintainers);
        return this;
    }

    public GHTeamBuilder repositories(String ... repoNames) {
        this.builder.with("repo_names", repoNames);
        return this;
    }

    public GHTeamBuilder privacy(GHTeam.Privacy privacy) {
        this.builder.with("privacy", privacy);
        return this;
    }

    public GHTeamBuilder parentTeamId(int parentTeamId) {
        this.builder.with("parent_team_id", parentTeamId);
        return this;
    }

    public GHTeam create() throws IOException {
        return this.builder.method("POST").withUrlPath("/orgs/" + this.orgName + "/teams").fetch(GHTeam.class).wrapUp(this.root);
    }
}

