/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHCheckRun;
import org.kohsuke.github.GHCommitComment;
import org.kohsuke.github.GHCommitStatus;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GHVerification;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitUser;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Requester;

@SuppressFBWarnings(value={"NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="JSON API")
public class GHCommit {
    private GHRepository owner;
    private ShortInfo commit;
    String url;
    String html_url;
    String sha;
    List<File> files;
    Stats stats;
    List<Parent> parents;
    User author;
    User committer;

    public ShortInfo getCommitShortInfo() throws IOException {
        if (this.commit == null) {
            this.populate();
        }
        return this.commit;
    }

    public GHRepository getOwner() {
        return this.owner;
    }

    public int getLinesChanged() throws IOException {
        this.populate();
        return this.stats.total;
    }

    public int getLinesAdded() throws IOException {
        this.populate();
        return this.stats.additions;
    }

    public int getLinesDeleted() throws IOException {
        this.populate();
        return this.stats.deletions;
    }

    public GHTree getTree() throws IOException {
        return this.owner.getTree(((ShortInfo)this.getCommitShortInfo()).tree.sha);
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.html_url);
    }

    public String getSHA1() {
        return this.sha;
    }

    public List<File> getFiles() throws IOException {
        this.populate();
        return this.files != null ? Collections.unmodifiableList(this.files) : Collections.emptyList();
    }

    public List<String> getParentSHA1s() {
        if (this.parents == null) {
            return Collections.emptyList();
        }
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return GHCommit.this.parents.get((int)index).sha;
            }

            @Override
            public int size() {
                return GHCommit.this.parents.size();
            }
        };
    }

    public List<GHCommit> getParents() throws IOException {
        ArrayList<GHCommit> r = new ArrayList<GHCommit>();
        for (String sha1 : this.getParentSHA1s()) {
            r.add(this.owner.getCommit(sha1));
        }
        return r;
    }

    public GHUser getAuthor() throws IOException {
        return this.resolveUser(this.author);
    }

    public Date getAuthoredDate() throws IOException {
        return this.getCommitShortInfo().getAuthoredDate();
    }

    public GHUser getCommitter() throws IOException {
        return this.resolveUser(this.committer);
    }

    public Date getCommitDate() throws IOException {
        return this.getCommitShortInfo().getCommitDate();
    }

    private GHUser resolveUser(User author) throws IOException {
        if (author == null || author.login == null) {
            return null;
        }
        return this.owner.root.getUser(author.login);
    }

    public PagedIterable<GHCommitComment> listComments() {
        return ((Requester)this.owner.root.createRequest().withUrlPath(String.format("/repos/%s/%s/commits/%s/comments", this.owner.getOwnerName(), this.owner.getName(), this.sha))).toIterable(GHCommitComment[].class, item -> item.wrap(this.owner));
    }

    public GHCommitComment createComment(String body, String path, Integer line, Integer position) throws IOException {
        GHCommitComment r = ((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)this.owner.root.createRequest().method("POST")).with("body", body)).with("path", path)).with("line", line)).with("position", position)).withUrlPath(String.format("/repos/%s/%s/commits/%s/comments", this.owner.getOwnerName(), this.owner.getName(), this.sha))).fetch(GHCommitComment.class);
        return r.wrap(this.owner);
    }

    public GHCommitComment createComment(String body) throws IOException {
        return this.createComment(body, null, null, null);
    }

    public PagedIterable<GHCommitStatus> listStatuses() throws IOException {
        return this.owner.listCommitStatuses(this.sha);
    }

    public GHCommitStatus getLastStatus() throws IOException {
        return this.owner.getLastCommitStatus(this.sha);
    }

    @Preview
    @Deprecated
    public PagedIterable<GHCheckRun> getCheckRuns() throws IOException {
        return this.owner.getCheckRuns(this.sha);
    }

    void populate() throws IOException {
        if (this.files == null && this.stats == null) {
            ((Requester)this.owner.root.createRequest().withUrlPath(this.owner.getApiTailUrl("commits/" + this.sha))).fetchInto(this);
        }
    }

    GHCommit wrapUp(GHRepository owner) {
        this.owner = owner;
        return this;
    }

    static class User {
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String url;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String avatar_url;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String gravatar_id;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        int id;
        String login;

        User() {
        }
    }

    public static class Parent {
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="We don't provide it in API now")
        String url;
        String sha;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="It's being initilized by JSON deserialization")
    public static class File {
        String status;
        int changes;
        int additions;
        int deletions;
        String raw_url;
        String blob_url;
        String sha;
        String patch;
        String filename;
        String previous_filename;

        public int getLinesChanged() {
            return this.changes;
        }

        public int getLinesAdded() {
            return this.additions;
        }

        public int getLinesDeleted() {
            return this.deletions;
        }

        public String getStatus() {
            return this.status;
        }

        @SuppressFBWarnings(value={"NM_CONFUSING"}, justification="It's a part of the library's API and cannot be renamed")
        public String getFileName() {
            return this.filename;
        }

        public String getPreviousFilename() {
            return this.previous_filename;
        }

        public String getPatch() {
            return this.patch;
        }

        public URL getRawUrl() {
            return GitHubClient.parseURL(this.raw_url);
        }

        public URL getBlobUrl() {
            return GitHubClient.parseURL(this.blob_url);
        }

        public String getSha() {
            return this.sha;
        }
    }

    public static class Stats {
        int total;
        int additions;
        int deletions;
    }

    public static class GHAuthor
    extends GitUser {
        private String date;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="JSON API")
    @BridgeMethodsAdded
    public static class ShortInfo {
        private GHAuthor author;
        private GHAuthor committer;
        private String message;
        private int comment_count;
        private GHVerification verification;
        private Tree tree;

        @WithBridgeMethods(value={GHAuthor.class}, castRequired=true)
        public GitUser getAuthor() {
            return this.author;
        }

        public Date getAuthoredDate() {
            return GitHubClient.parseDate(this.author.date);
        }

        @WithBridgeMethods(value={GHAuthor.class}, castRequired=true)
        public GitUser getCommitter() {
            return this.committer;
        }

        public Date getCommitDate() {
            return GitHubClient.parseDate(this.committer.date);
        }

        public String getMessage() {
            return this.message;
        }

        public int getCommentCount() {
            return this.comment_count;
        }

        public GHVerification getVerification() {
            return this.verification;
        }

        static class Tree {
            String sha;

            Tree() {
            }
        }
    }
}

