/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import org.kohsuke.github.GHDirection;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHQueryBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHPullRequestQueryBuilder
extends GHQueryBuilder<GHPullRequest> {
    private final GHRepository repo;

    GHPullRequestQueryBuilder(GHRepository repo) {
        super(repo.root);
        this.repo = repo;
    }

    public GHPullRequestQueryBuilder state(GHIssueState state) {
        this.req.with("state", state);
        return this;
    }

    public GHPullRequestQueryBuilder head(String head) {
        if (head != null && !head.contains(":")) {
            head = this.repo.getOwnerName() + ":" + head;
        }
        this.req.with("head", head);
        return this;
    }

    public GHPullRequestQueryBuilder base(String base) {
        this.req.with("base", base);
        return this;
    }

    public GHPullRequestQueryBuilder sort(Sort sort) {
        this.req.with("sort", sort);
        return this;
    }

    public GHPullRequestQueryBuilder direction(GHDirection d) {
        this.req.with("direction", d);
        return this;
    }

    @Override
    public PagedIterable<GHPullRequest> list() {
        return ((Requester)((Requester)this.req.withPreview("application/vnd.github.shadow-cat-preview+json")).withUrlPath(this.repo.getApiTailUrl("pulls"))).toIterable(GHPullRequest[].class, item -> item.wrapUp(this.repo));
    }

    public static enum Sort {
        CREATED,
        UPDATED,
        POPULARITY,
        LONG_RUNNING;

    }
}

