/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Requester;

public class GHRepositoryStatistics {
    private final GHRepository repo;
    private final GitHub root;
    private static final int MAX_WAIT_ITERATIONS = 3;
    private static final int WAIT_SLEEP_INTERVAL = 5000;

    public GHRepositoryStatistics(GHRepository repo) {
        this.repo = repo;
        this.root = repo.root;
    }

    public PagedIterable<ContributorStats> getContributorStats() throws IOException, InterruptedException {
        return this.getContributorStats(true);
    }

    @Preview
    @Deprecated
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="JSON API")
    public PagedIterable<ContributorStats> getContributorStats(boolean waitTillReady) throws IOException, InterruptedException {
        PagedIterable<ContributorStats> stats = this.getContributorStatsImpl();
        if (stats == null && waitTillReady) {
            for (int i = 0; i < 3; ++i) {
                Thread.sleep(5000L);
                stats = this.getContributorStatsImpl();
                if (stats != null) break;
            }
        }
        return stats;
    }

    private PagedIterable<ContributorStats> getContributorStatsImpl() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("contributors"))).toIterable(ContributorStats[].class, item -> item.wrapUp(this.root));
    }

    public PagedIterable<CommitActivity> getCommitActivity() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("commit_activity"))).toIterable(CommitActivity[].class, item -> item.wrapUp(this.root));
    }

    public List<CodeFrequency> getCodeFrequency() throws IOException {
        try {
            Integer[][] list = ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("code_frequency"))).fetch(Integer[][].class);
            ArrayList<CodeFrequency> returnList = new ArrayList<CodeFrequency>();
            for (Integer[] item : list) {
                CodeFrequency cf = new CodeFrequency(Arrays.asList(item));
                returnList.add(cf);
            }
            return returnList;
        }
        catch (MismatchedInputException e) {
            return null;
        }
    }

    public Participation getParticipation() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("participation"))).fetch(Participation.class);
    }

    public List<PunchCardItem> getPunchCard() throws IOException {
        Integer[][] list = ((Requester)this.root.createRequest().withUrlPath(this.getApiTailUrl("punch_card"))).fetch(Integer[][].class);
        ArrayList<PunchCardItem> returnList = new ArrayList<PunchCardItem>();
        for (Integer[] item : list) {
            PunchCardItem pci = new PunchCardItem(Arrays.asList(item));
            returnList.add(pci);
        }
        return returnList;
    }

    String getApiTailUrl(String tail) {
        return this.repo.getApiTailUrl("stats/" + tail);
    }

    public static class PunchCardItem {
        private int dayOfWeek;
        private int hourOfDay;
        private int numberOfCommits;

        private PunchCardItem(List<Integer> item) {
            this.dayOfWeek = item.get(0);
            this.hourOfDay = item.get(1);
            this.numberOfCommits = item.get(2);
        }

        public int getDayOfWeek() {
            return this.dayOfWeek;
        }

        public long getHourOfDay() {
            return this.hourOfDay;
        }

        public long getNumberOfCommits() {
            return this.numberOfCommits;
        }

        public String toString() {
            return "Day " + this.getDayOfWeek() + " Hour " + this.getHourOfDay() + ": " + this.getNumberOfCommits() + " commits";
        }
    }

    public static class Participation
    extends GHObject {
        private GitHub root;
        private List<Integer> all;
        private List<Integer> owner;

        @Override
        public URL getHtmlUrl() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public GitHub getRoot() {
            return this.root;
        }

        public List<Integer> getAllCommits() {
            return this.all;
        }

        public List<Integer> getOwnerCommits() {
            return this.owner;
        }

        Participation wrapUp(GitHub root) {
            this.root = root;
            return this;
        }
    }

    public static class CodeFrequency {
        private int week;
        private int additions;
        private int deletions;

        private CodeFrequency(List<Integer> item) {
            this.week = item.get(0);
            this.additions = item.get(1);
            this.deletions = item.get(2);
        }

        public int getWeekTimestamp() {
            return this.week;
        }

        public long getAdditions() {
            return this.additions;
        }

        public long getDeletions() {
            return this.deletions;
        }

        public String toString() {
            return "Week starting " + this.getWeekTimestamp() + " has " + this.getAdditions() + " additions and " + Math.abs(this.getDeletions()) + " deletions";
        }
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class CommitActivity
    extends GHObject {
        private GitHub root;
        private List<Integer> days;
        private int total;
        private long week;

        public List<Integer> getDays() {
            return this.days;
        }

        public int getTotal() {
            return this.total;
        }

        public long getWeek() {
            return this.week;
        }

        CommitActivity wrapUp(GitHub root) {
            this.root = root;
            return this;
        }

        public GitHub getRoot() {
            return this.root;
        }

        @Override
        public URL getHtmlUrl() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
    public static class ContributorStats
    extends GHObject {
        private GitHub root;
        private GHUser author;
        private int total;
        private List<Week> weeks;

        @Override
        public URL getHtmlUrl() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public GitHub getRoot() {
            return this.root;
        }

        public GHUser getAuthor() {
            return this.author;
        }

        public int getTotal() {
            return this.total;
        }

        public Week getWeek(long timestamp) throws NoSuchElementException {
            for (Week week : this.weeks) {
                if (week.getWeekTimestamp() != timestamp) continue;
                return week;
            }
            throw new NoSuchElementException();
        }

        public List<Week> getWeeks() {
            return this.weeks;
        }

        @Override
        public String toString() {
            return this.author.getLogin() + " made " + String.valueOf(this.total) + " contributions over " + String.valueOf(this.weeks.size()) + " weeks";
        }

        ContributorStats wrapUp(GitHub root) {
            this.root = root;
            return this;
        }

        @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
        public static class Week {
            private long w;
            private int a;
            private int d;
            private int c;

            public long getWeekTimestamp() {
                return this.w;
            }

            public int getNumberOfAdditions() {
                return this.a;
            }

            public int getNumberOfDeletions() {
                return this.d;
            }

            public int getNumberOfCommits() {
                return this.c;
            }

            public String toString() {
                return String.format("Week starting %d - Additions: %d, Deletions: %d, Commits: %d", this.w, this.a, this.d, this.c);
            }
        }
    }
}

