/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.kohsuke.github.GHDiscussion;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Refreshable;
import org.kohsuke.github.Requester;

public class GHTeam
extends GHObject
implements Refreshable {
    private String html_url;
    private String name;
    private String permission;
    private String slug;
    private String description;
    private Privacy privacy;
    private GHOrganization organization;
    protected GitHub root;

    GHTeam wrapUp(GHOrganization owner) {
        this.organization = owner;
        this.root = owner.root;
        return this;
    }

    GHTeam wrapUp(GitHub root) {
        this.organization.wrapUp(root);
        return this.wrapUp(this.organization);
    }

    static GHTeam[] wrapUp(GHTeam[] teams, GHPullRequest owner) {
        for (GHTeam t : teams) {
            t.root = owner.root;
        }
        return teams;
    }

    public String getName() {
        return this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getDescription() {
        return this.description;
    }

    public Privacy getPrivacy() {
        return this.privacy;
    }

    public void setDescription(String description) throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().method("PATCH")).with("description", description)).withUrlPath(this.api(""), new String[0])).send();
    }

    public void setPrivacy(Privacy privacy) throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().method("PATCH")).with("privacy", privacy)).withUrlPath(this.api(""), new String[0])).send();
    }

    @Nonnull
    public PagedIterable<GHDiscussion> listDiscussions() throws IOException {
        return GHDiscussion.readAll(this);
    }

    @Nonnull
    public GHDiscussion getDiscussion(long discussionNumber) throws IOException {
        return GHDiscussion.read(this, discussionNumber);
    }

    public PagedIterable<GHUser> listMembers() throws IOException {
        return ((Requester)this.root.createRequest().withUrlPath(this.api("/members"), new String[0])).toIterable(GHUser[].class, item -> item.wrapUp(this.root));
    }

    public Set<GHUser> getMembers() throws IOException {
        return this.listMembers().toSet();
    }

    public boolean hasMember(GHUser user) {
        try {
            ((Requester)this.root.createRequest().withUrlPath("/teams/" + this.getId() + "/members/" + user.getLogin(), new String[0])).send();
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public Map<String, GHRepository> getRepositories() throws IOException {
        TreeMap<String, GHRepository> m = new TreeMap<String, GHRepository>();
        for (GHRepository r : this.listRepositories()) {
            m.put(r.getName(), r);
        }
        return m;
    }

    public PagedIterable<GHRepository> listRepositories() {
        return ((Requester)this.root.createRequest().withUrlPath(this.api("/repos"), new String[0])).toIterable(GHRepository[].class, item -> item.wrap(this.root));
    }

    public void add(GHUser u) throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("PUT")).withUrlPath(this.api("/memberships/" + u.getLogin()), new String[0])).send();
    }

    public void add(GHUser user, Role role) throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().method("PUT")).with("role", role)).withUrlPath(this.api("/memberships/" + user.getLogin()), new String[0])).send();
    }

    public void remove(GHUser u) throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("DELETE")).withUrlPath(this.api("/members/" + u.getLogin()), new String[0])).send();
    }

    public void add(GHRepository r) throws IOException {
        this.add(r, null);
    }

    public void add(GHRepository r, GHOrganization.Permission permission) throws IOException {
        ((Requester)((Requester)((Requester)this.root.createRequest().method("PUT")).with("permission", permission)).withUrlPath(this.api("/repos/" + r.getOwnerName() + '/' + r.getName()), new String[0])).send();
    }

    public void remove(GHRepository r) throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("DELETE")).withUrlPath(this.api("/repos/" + r.getOwnerName() + '/' + r.getName()), new String[0])).send();
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("DELETE")).withUrlPath(this.api(""), new String[0])).send();
    }

    private String api(String tail) {
        return "/teams/" + this.getId() + tail;
    }

    public GHDiscussion.Creator createDiscussion(String title) throws IOException {
        return (GHDiscussion.Creator)GHDiscussion.create(this).title(title);
    }

    public GHOrganization getOrganization() throws IOException {
        this.refresh(this.organization);
        return this.organization;
    }

    @Override
    public void refresh() throws IOException {
        ((Requester)this.root.createRequest().withUrlPath(this.api(""), new String[0])).fetchInto(this).wrapUp(this.root);
    }

    @Override
    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.html_url);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GHTeam ghTeam = (GHTeam)o;
        return Objects.equals(this.name, ghTeam.name) && Objects.equals(this.getUrl(), ghTeam.getUrl()) && Objects.equals(this.permission, ghTeam.permission) && Objects.equals(this.slug, ghTeam.slug) && Objects.equals(this.description, ghTeam.description) && this.privacy == ghTeam.privacy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.getUrl(), this.permission, this.slug, this.description, this.privacy});
    }

    public static enum Role {
        MEMBER,
        MAINTAINER;

    }

    public static enum Privacy {
        SECRET,
        CLOSED;

    }
}

