/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLHandshakeException;
import org.kohsuke.github.AbuseLimitHandler;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHIOException;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOTPRequiredException;
import org.kohsuke.github.GHRateLimit;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubRateLimitChecker;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.GitHubResponse;
import org.kohsuke.github.HttpConnector;
import org.kohsuke.github.HttpException;
import org.kohsuke.github.JsonRateLimit;
import org.kohsuke.github.RateLimitHandler;
import org.kohsuke.github.RateLimitTarget;

abstract class GitHubClient {
    static final int CONNECTION_ERROR_RETRIES = 2;
    static final int retryTimeoutMillis = 100;
    final String login;
    final String encodedAuthorization;
    private final String apiUrl;
    protected final RateLimitHandler rateLimitHandler;
    protected final AbuseLimitHandler abuseLimitHandler;
    private final GitHubRateLimitChecker rateLimitChecker;
    private HttpConnector connector;
    private final Object rateLimitLock = new Object();
    @Nonnull
    private GHRateLimit rateLimit = GHRateLimit.DEFAULT;
    private static final Logger LOGGER = Logger.getLogger(GitHubClient.class.getName());
    private static final ObjectMapper MAPPER = new ObjectMapper();
    static final String GITHUB_URL = "https://api.github.com";
    private static final String[] TIME_FORMATS = new String[]{"yyyy/MM/dd HH:mm:ss ZZZZ", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss.S'Z'"};

    GitHubClient(String apiUrl, String login, String oauthAccessToken, String jwtToken, String password, HttpConnector connector, RateLimitHandler rateLimitHandler, AbuseLimitHandler abuseLimitHandler, GitHubRateLimitChecker rateLimitChecker, Consumer<GHMyself> myselfConsumer) throws IOException {
        if (apiUrl.endsWith("/")) {
            apiUrl = apiUrl.substring(0, apiUrl.length() - 1);
        }
        if (null == connector) {
            connector = HttpConnector.DEFAULT;
        }
        this.apiUrl = apiUrl;
        this.connector = connector;
        if (oauthAccessToken != null) {
            this.encodedAuthorization = "token " + oauthAccessToken;
        } else if (jwtToken != null) {
            this.encodedAuthorization = "Bearer " + jwtToken;
        } else if (password != null) {
            String authorization = login + ':' + password;
            String charsetName = StandardCharsets.UTF_8.name();
            this.encodedAuthorization = "Basic " + Base64.getEncoder().encodeToString(authorization.getBytes(charsetName));
        } else {
            this.encodedAuthorization = null;
        }
        this.rateLimitHandler = rateLimitHandler;
        this.abuseLimitHandler = abuseLimitHandler;
        this.rateLimitChecker = rateLimitChecker;
        if (login == null && this.encodedAuthorization != null && jwtToken == null) {
            GHMyself myself = this.fetch(GHMyself.class, "/user");
            login = myself.getLogin();
            if (myselfConsumer != null) {
                myselfConsumer.accept(myself);
            }
        }
        this.login = login;
    }

    private <T> T fetch(Class<T> type, String urlPath) throws IOException {
        GitHubRequest request = ((GitHubRequest.Builder)((GitHubRequest.Builder)GitHubRequest.newBuilder().withApiUrl(this.getApiUrl())).withUrlPath(urlPath, new String[0])).build();
        return (T)this.sendRequest(request, (GitHubResponse.ResponseInfo responseInfo) -> GitHubResponse.parseBody(responseInfo, type)).body();
    }

    public boolean isCredentialValid() {
        try {
            this.getRateLimit();
            return true;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Exception validating credentials on " + this.getApiUrl() + " with login '" + this.login + "' " + e, e);
            }
            return false;
        }
    }

    public boolean isOffline() {
        return this.getConnector() == HttpConnector.OFFLINE;
    }

    public HttpConnector getConnector() {
        return this.connector;
    }

    @Deprecated
    public void setConnector(HttpConnector connector) {
        LOGGER.warning("Connector should not be changed. Please file an issue describing your use case.");
        this.connector = connector;
    }

    public boolean isAnonymous() {
        return this.login == null && this.encodedAuthorization == null;
    }

    @Nonnull
    public GHRateLimit getRateLimit() throws IOException {
        return this.getRateLimit(RateLimitTarget.NONE);
    }

    @Nonnull
    GHRateLimit getRateLimit(@Nonnull RateLimitTarget rateLimitTarget) throws IOException {
        GHRateLimit result;
        try {
            GitHubRequest request = ((GitHubRequest.Builder)((GitHubRequest.Builder)((GitHubRequest.Builder)GitHubRequest.newBuilder().rateLimit(RateLimitTarget.NONE)).withApiUrl(this.getApiUrl())).withUrlPath("/rate_limit", new String[0])).build();
            result = this.sendRequest((GitHubRequest)request, (GitHubResponse.BodyHandler<JsonRateLimit>)LambdaMetafactory.metafactory(null, null, null, (Lorg/kohsuke/github/GitHubResponse$ResponseInfo;)Ljava/lang/Object;, lambda$getRateLimit$1(org.kohsuke.github.GitHubResponse$ResponseInfo ), (Lorg/kohsuke/github/GitHubResponse$ResponseInfo;)Lorg/kohsuke/github/JsonRateLimit;)()).body().resources;
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.FINE, "/rate_limit returned 404 Not Found.");
            result = GHRateLimit.fromRecord(GHRateLimit.UnknownLimitRecord.current(), rateLimitTarget);
        }
        return this.updateRateLimit(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @Deprecated
    GHRateLimit lastRateLimit() {
        Object object = this.rateLimitLock;
        synchronized (object) {
            return this.rateLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    GHRateLimit rateLimit(@Nonnull RateLimitTarget rateLimitTarget) throws IOException {
        Object object = this.rateLimitLock;
        synchronized (object) {
            if (this.rateLimit.getRecord(rateLimitTarget).isExpired()) {
                this.getRateLimit(rateLimitTarget);
            }
            return this.rateLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GHRateLimit updateRateLimit(@Nonnull GHRateLimit observed) {
        Object object = this.rateLimitLock;
        synchronized (object) {
            observed = this.rateLimit.getMergedRateLimit(observed);
            if (this.rateLimit != observed) {
                this.rateLimit = observed;
                LOGGER.log(Level.FINE, "Rate limit now: {0}", this.rateLimit);
            }
            return this.rateLimit;
        }
    }

    public void checkApiUrlValidity() throws IOException {
        try {
            this.fetch(GHApiInfo.class, "/").check(this.getApiUrl());
        }
        catch (IOException e) {
            if (this.isPrivateModeEnabled()) {
                throw (IOException)new IOException("GitHub Enterprise server (" + this.getApiUrl() + ") with private mode enabled").initCause(e);
            }
            throw e;
        }
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    @Nonnull
    public <T> GitHubResponse<T> sendRequest(@Nonnull GitHubRequest.Builder<?> builder, @CheckForNull GitHubResponse.BodyHandler<T> handler) throws IOException {
        return this.sendRequest(builder.build(), handler);
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public <T> GitHubResponse<T> sendRequest(GitHubRequest request, @CheckForNull GitHubResponse.BodyHandler<T> handler) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 4[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    protected abstract GitHubResponse.ResponseInfo getResponseInfo(GitHubRequest var1) throws IOException;

    protected abstract void handleLimitingErrors(@Nonnull GitHubResponse.ResponseInfo var1) throws IOException;

    @Nonnull
    private static <T> GitHubResponse<T> createResponse(@Nonnull GitHubResponse.ResponseInfo responseInfo, @CheckForNull GitHubResponse.BodyHandler<T> handler) throws IOException {
        Object body = null;
        if (responseInfo.statusCode() != 304) {
            if (responseInfo.statusCode() == 202) {
                if (responseInfo.url().toString().endsWith("/forks")) {
                    LOGGER.log(Level.INFO, "The fork is being created. Please try again in 5 seconds.");
                } else if (responseInfo.url().toString().endsWith("/statistics")) {
                    LOGGER.log(Level.INFO, "The statistics are being generated. Please try again in 5 seconds.");
                } else {
                    LOGGER.log(Level.INFO, "Received 202 from " + responseInfo.url().toString() + " . Please try again in 5 seconds.");
                }
            } else if (handler != null) {
                body = handler.apply(responseInfo);
            }
        }
        return new GitHubResponse<Object>(responseInfo, body);
    }

    private static IOException interpretApiError(IOException e, @Nonnull GitHubRequest request, @CheckForNull GitHubResponse.ResponseInfo responseInfo) throws IOException {
        if (e instanceof GHIOException) {
            return e;
        }
        int statusCode = -1;
        String message = null;
        HashMap<String, List<String>> headers = new HashMap();
        String errorMessage = null;
        if (responseInfo != null) {
            statusCode = responseInfo.statusCode();
            message = responseInfo.headerField("Status");
            headers = responseInfo.headers();
            errorMessage = responseInfo.errorMessage();
        }
        if (errorMessage != null) {
            e = e instanceof FileNotFoundException ? new GHFileNotFoundException(e.getMessage() + " " + errorMessage, e).withResponseHeaderFields(headers) : (statusCode >= 0 ? new HttpException(errorMessage, statusCode, message, request.url().toString(), e) : new GHIOException(errorMessage).withResponseHeaderFields(headers));
        } else if (!(e instanceof FileNotFoundException)) {
            e = new HttpException(statusCode, message, request.url().toString(), (Throwable)e);
        }
        return e;
    }

    protected static boolean isRateLimitResponse(@Nonnull GitHubResponse.ResponseInfo responseInfo) {
        return responseInfo.statusCode() == 403 && "0".equals(responseInfo.headerField("X-RateLimit-Remaining"));
    }

    protected static boolean isAbuseLimitResponse(@Nonnull GitHubResponse.ResponseInfo responseInfo) {
        return responseInfo.statusCode() == 403 && responseInfo.headerField("Retry-After") != null;
    }

    private static boolean retryConnectionError(IOException e, URL url, int retries) throws IOException {
        boolean connectionError;
        boolean bl = connectionError = e instanceof SocketException || e instanceof SocketTimeoutException || e instanceof SSLHandshakeException;
        if (connectionError && retries > 0) {
            LOGGER.log(Level.INFO, e.getMessage() + " while connecting to " + url + ". Sleeping " + 100 + " milliseconds before retrying... ; will try " + retries + " more time(s)");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
            return true;
        }
        return false;
    }

    private static boolean isInvalidCached404Response(GitHubResponse.ResponseInfo responseInfo) {
        if (responseInfo.statusCode() == 404 && Objects.equals(responseInfo.request().method(), "GET") && responseInfo.headerField("ETag") != null && !Objects.equals(responseInfo.request().headers().get("Cache-Control"), "no-cache")) {
            LOGGER.log(Level.FINE, "Encountered GitHub invalid cached 404 from " + responseInfo.url() + ". Retrying with \"Cache-Control\"=\"no-cache\"...");
            return true;
        }
        return false;
    }

    private void noteRateLimit(@Nonnull GitHubResponse.ResponseInfo responseInfo) {
        block2: {
            try {
                String limitString = Objects.requireNonNull(responseInfo.headerField("X-RateLimit-Limit"), "Missing X-RateLimit-Limit");
                String remainingString = Objects.requireNonNull(responseInfo.headerField("X-RateLimit-Remaining"), "Missing X-RateLimit-Remaining");
                String resetString = Objects.requireNonNull(responseInfo.headerField("X-RateLimit-Reset"), "Missing X-RateLimit-Reset");
                int limit = Integer.parseInt(limitString);
                int remaining = Integer.parseInt(remainingString);
                long reset = Long.parseLong(resetString);
                GHRateLimit.Record observed = new GHRateLimit.Record(limit, remaining, reset, responseInfo);
                this.updateRateLimit(GHRateLimit.fromRecord(observed, responseInfo.request().rateLimitTarget()));
            }
            catch (NullPointerException | NumberFormatException e) {
                if (!LOGGER.isLoggable(Level.FINEST)) break block2;
                LOGGER.log(Level.FINEST, "Missing or malformed X-RateLimit header: ", e);
            }
        }
    }

    private static void detectOTPRequired(@Nonnull GitHubResponse.ResponseInfo responseInfo) throws GHIOException {
        if (responseInfo.statusCode() == 401 && responseInfo.headerField("X-GitHub-OTP") != null) {
            throw new GHOTPRequiredException().withResponseHeaderFields(responseInfo.headers());
        }
    }

    void requireCredential() {
        if (this.isAnonymous()) {
            throw new IllegalStateException("This operation requires a credential but none is given to the GitHub constructor");
        }
    }

    private boolean isPrivateModeEnabled() {
        try {
            GitHubResponse response = this.sendRequest((GitHubRequest.Builder<?>)GitHubRequest.newBuilder().withApiUrl(this.getApiUrl()), null);
            return response.statusCode() == 401 && response.headerField("X-GitHub-Media-Type") != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    static URL parseURL(String s) {
        try {
            return s == null ? null : new URL(s);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + s);
        }
    }

    static Date parseDate(String timestamp) {
        if (timestamp == null) {
            return null;
        }
        for (String f : TIME_FORMATS) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(f);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df.parse(timestamp);
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalStateException("Unable to parse the timestamp: " + timestamp);
    }

    static String printDate(Date dt) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(dt);
    }

    @Nonnull
    static ObjectWriter getMappingObjectWriter() {
        return MAPPER.writer();
    }

    @Nonnull
    static ObjectReader getMappingObjectReader(@Nonnull GitHub root) {
        ObjectReader reader = GitHubClient.getMappingObjectReader((GitHubResponse.ResponseInfo)null);
        ((InjectableValues.Std)reader.getInjectableValues()).addValue(GitHub.class, (Object)root);
        return reader;
    }

    @Nonnull
    static ObjectReader getMappingObjectReader(@CheckForNull GitHubResponse.ResponseInfo responseInfo) {
        HashMap<String, Object> injected = new HashMap<String, Object>();
        injected.put(GitHubResponse.ResponseInfo.class.getName(), null);
        injected.put(GitHub.class.getName(), null);
        if (responseInfo != null) {
            injected.put(GitHubResponse.ResponseInfo.class.getName(), responseInfo);
            injected.putAll(responseInfo.request().injectedMappingValues());
        }
        return MAPPER.reader((InjectableValues)new InjectableValues.Std(injected));
    }

    private static /* synthetic */ JsonRateLimit lambda$getRateLimit$1(GitHubResponse.ResponseInfo responseInfo) throws IOException {
        return (JsonRateLimit)((Object)GitHubResponse.parseBody(responseInfo, JsonRateLimit.class));
    }

    static {
        MAPPER.setVisibility((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS, true);
        MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
    }

    private static class GHApiInfo {
        private String rate_limit_url;

        private GHApiInfo() {
        }

        void check(String apiUrl) throws IOException {
            if (this.rate_limit_url == null) {
                throw new IOException(apiUrl + " doesn't look like GitHub API URL");
            }
            new URL(this.rate_limit_url);
        }
    }
}

