/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Requester;

public class GHCreateRepositoryBuilder {
    private final GitHub root;
    protected final Requester builder;
    private String apiUrlTail;

    GHCreateRepositoryBuilder(GitHub root, String apiUrlTail, String name) {
        this.root = root;
        this.apiUrlTail = apiUrlTail;
        this.builder = root.createRequest();
        this.builder.with("name", name);
    }

    public GHCreateRepositoryBuilder description(String description) {
        this.builder.with("description", description);
        return this;
    }

    public GHCreateRepositoryBuilder homepage(URL homepage) {
        return this.homepage(homepage.toExternalForm());
    }

    public GHCreateRepositoryBuilder homepage(String homepage) {
        this.builder.with("homepage", homepage);
        return this;
    }

    public GHCreateRepositoryBuilder private_(boolean enabled) {
        this.builder.with("private", enabled);
        return this;
    }

    public GHCreateRepositoryBuilder issues(boolean enabled) {
        this.builder.with("has_issues", enabled);
        return this;
    }

    public GHCreateRepositoryBuilder projects(boolean enabled) {
        this.builder.with("has_projects", enabled);
        return this;
    }

    public GHCreateRepositoryBuilder wiki(boolean enabled) {
        this.builder.with("has_wiki", enabled);
        return this;
    }

    public GHCreateRepositoryBuilder downloads(boolean enabled) {
        this.builder.with("has_downloads", enabled);
        return this;
    }

    public GHCreateRepositoryBuilder autoInit(boolean enabled) {
        this.builder.with("auto_init", enabled);
        return this;
    }

    public GHCreateRepositoryBuilder allowSquashMerge(boolean enabled) {
        this.builder.with("allow_squash_merge", enabled);
        return this;
    }

    public GHCreateRepositoryBuilder allowMergeCommit(boolean enabled) {
        this.builder.with("allow_merge_commit", enabled);
        return this;
    }

    public GHCreateRepositoryBuilder allowRebaseMerge(boolean enabled) {
        this.builder.with("allow_rebase_merge", enabled);
        return this;
    }

    public GHCreateRepositoryBuilder gitignoreTemplate(String language) {
        this.builder.with("gitignore_template", language);
        return this;
    }

    public GHCreateRepositoryBuilder licenseTemplate(String license) {
        this.builder.with("license_template", license);
        return this;
    }

    public GHCreateRepositoryBuilder team(GHTeam team) {
        if (team != null) {
            this.builder.with("team_id", team.getId());
        }
        return this;
    }

    @Preview
    @Deprecated
    public GHCreateRepositoryBuilder templateRepository(boolean enabled) {
        this.builder.withPreview("application/vnd.github.baptiste-preview+json");
        this.builder.with("is_template", enabled);
        return this;
    }

    public GHCreateRepositoryBuilder owner(String owner) {
        this.builder.with("owner", owner);
        return this;
    }

    @Preview
    @Deprecated
    public GHCreateRepositoryBuilder fromTemplateRepository(String templateOwner, String templateRepo) {
        this.builder.withPreview("application/vnd.github.baptiste-preview+json");
        this.apiUrlTail = "/repos/" + templateOwner + "/" + templateRepo + "/generate";
        return this;
    }

    public GHRepository create() throws IOException {
        return ((Requester)((Requester)this.builder.method("POST")).withUrlPath(this.apiUrlTail, new String[0])).fetch(GHRepository.class).wrap(this.root);
    }
}

