/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitUser;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.EnumUtils;

public class GHWorkflowRun
extends GHObject {
    @JsonProperty(value="repository")
    private GHRepository owner;
    private String name;
    private long runNumber;
    private long workflowId;
    private String htmlUrl;
    private String jobsUrl;
    private String logsUrl;
    private String checkSuiteUrl;
    private String artifactsUrl;
    private String cancelUrl;
    private String rerunUrl;
    private String workflowUrl;
    private String headBranch;
    private String headSha;
    private GHRepository headRepository;
    private HeadCommit headCommit;
    private String event;
    private String status;
    private String conclusion;
    private GHPullRequest[] pullRequests;

    public String getName() {
        return this.name;
    }

    public long getRunNumber() {
        return this.runNumber;
    }

    public long getWorkflowId() {
        return this.workflowId;
    }

    @Override
    public URL getHtmlUrl() throws IOException {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public URL getJobsUrl() {
        return GitHubClient.parseURL(this.jobsUrl);
    }

    public URL getLogsUrl() {
        return GitHubClient.parseURL(this.logsUrl);
    }

    public URL getCheckSuiteUrl() {
        return GitHubClient.parseURL(this.checkSuiteUrl);
    }

    public URL getArtifactsUrl() {
        return GitHubClient.parseURL(this.artifactsUrl);
    }

    public URL getCancelUrl() {
        return GitHubClient.parseURL(this.cancelUrl);
    }

    public URL getRerunUrl() {
        return GitHubClient.parseURL(this.rerunUrl);
    }

    public URL getWorkflowUrl() {
        return GitHubClient.parseURL(this.workflowUrl);
    }

    public String getHeadBranch() {
        return this.headBranch;
    }

    public String getHeadSha() {
        return this.headSha;
    }

    public HeadCommit getHeadCommit() {
        return this.headCommit;
    }

    public GHRepository getHeadRepository() {
        return this.headRepository;
    }

    public GHEvent getEvent() {
        return Enum.valueOf(GHEvent.class, this.event.toUpperCase(Locale.ROOT));
    }

    public Status getStatus() {
        return Status.from(this.status);
    }

    public Conclusion getConclusion() {
        return Conclusion.from(this.conclusion);
    }

    public List<GHPullRequest> getPullRequests() throws IOException {
        if (this.pullRequests != null && this.pullRequests.length != 0) {
            for (GHPullRequest pullRequest : this.pullRequests) {
                pullRequest.refresh(pullRequest.getTitle());
            }
            return Collections.unmodifiableList(Arrays.asList(this.pullRequests));
        }
        return Collections.emptyList();
    }

    public void cancel() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("POST")).withUrlPath(this.getApiRoute(), "cancel")).fetchHttpStatusCode();
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).fetchHttpStatusCode();
    }

    public void rerun() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("POST")).withUrlPath(this.getApiRoute(), "rerun")).fetchHttpStatusCode();
    }

    private String getApiRoute() {
        if (this.owner == null) {
            URL url = Objects.requireNonNull(this.getUrl(), "Missing instance URL!");
            return StringUtils.prependIfMissing((String)url.toString().replace(this.root.getApiUrl(), ""), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/actions/runs/" + this.getId();
    }

    GHWorkflowRun wrapUp(GHRepository owner) {
        this.owner = owner;
        return this.wrapUp(owner.root);
    }

    GHWorkflowRun wrapUp(GitHub root) {
        this.root = root;
        if (this.owner != null) {
            this.owner.wrap(root);
            if (this.pullRequests != null) {
                for (GHPullRequest singlePull : this.pullRequests) {
                    singlePull.wrap(this.owner);
                }
            }
        } else if (this.pullRequests != null) {
            for (GHPullRequest singlePull : this.pullRequests) {
                singlePull.wrap(root);
            }
        }
        if (this.headRepository != null) {
            this.headRepository.wrap(root);
        }
        return this;
    }

    public static enum Conclusion {
        ACTION_REQUIRED,
        CANCELLED,
        FAILURE,
        NEUTRAL,
        SUCCESS,
        SKIPPED,
        STALE,
        TIMED_OUT,
        UNKNOWN;


        public static Conclusion from(String value) {
            return EnumUtils.getNullableEnumOrDefault(Conclusion.class, value, UNKNOWN);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Status {
        QUEUED,
        IN_PROGRESS,
        COMPLETED,
        UNKNOWN;


        public static Status from(String value) {
            return EnumUtils.getNullableEnumOrDefault(Status.class, value, UNKNOWN);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class HeadCommit {
        private String id;
        private String treeId;
        private String message;
        private String timestamp;
        private GitUser author;
        private GitUser committer;

        public String getId() {
            return this.id;
        }

        public String getTreeId() {
            return this.treeId;
        }

        public String getMessage() {
            return this.message;
        }

        public Date getTimestamp() {
            return GitHubClient.parseDate(this.timestamp);
        }

        public GitUser getAuthor() {
            return this.author;
        }

        public GitUser getCommitter() {
            return this.committer;
        }
    }
}

