/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kohsuke.github.GHAppInstallation;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.EnumUtils;
import org.kohsuke.github.internal.Previews;

public class GHApp
extends GHObject {
    private GHUser owner;
    private String name;
    private String description;
    private String externalUrl;
    private Map<String, String> permissions;
    private List<String> events;
    private long installationsCount;
    private String htmlUrl;

    public GHUser getOwner() {
        return this.owner;
    }

    @Deprecated
    public void setOwner(GHUser owner) {
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public void setDescription(String description) {
        this.description = description;
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    @Deprecated
    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    public List<GHEvent> getEvents() {
        return this.events.stream().map(e -> EnumUtils.getEnumOrDefault(GHEvent.class, e, GHEvent.UNKNOWN)).collect(Collectors.toList());
    }

    @Deprecated
    public void setEvents(List<GHEvent> events) {
        this.events = events.stream().map(GHEvent::symbol).collect(Collectors.toList());
    }

    public long getInstallationsCount() {
        return this.installationsCount;
    }

    @Deprecated
    public void setInstallationsCount(long installationsCount) {
        this.installationsCount = installationsCount;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public Map<String, String> getPermissions() {
        return this.permissions;
    }

    @Deprecated
    public void setPermissions(Map<String, String> permissions) {
        this.permissions = permissions;
    }

    GHApp wrapUp(GitHub root) {
        this.root = root;
        return this;
    }

    @Preview(value={Previews.MACHINE_MAN})
    @Deprecated
    public PagedIterable<GHAppInstallation> listInstallations() {
        return ((Requester)((Requester)this.root.createRequest().withPreview(Previews.MACHINE_MAN)).withUrlPath("/app/installations", new String[0])).toIterable(GHAppInstallation[].class, item -> item.wrapUp(this.root));
    }

    @Preview(value={Previews.MACHINE_MAN})
    @Deprecated
    public GHAppInstallation getInstallationById(long id) throws IOException {
        return ((Requester)((Requester)this.root.createRequest().withPreview(Previews.MACHINE_MAN)).withUrlPath(String.format("/app/installations/%d", id), new String[0])).fetch(GHAppInstallation.class).wrapUp(this.root);
    }

    @Preview(value={Previews.MACHINE_MAN})
    @Deprecated
    public GHAppInstallation getInstallationByOrganization(String name) throws IOException {
        return ((Requester)((Requester)this.root.createRequest().withPreview(Previews.MACHINE_MAN)).withUrlPath(String.format("/orgs/%s/installation", name), new String[0])).fetch(GHAppInstallation.class).wrapUp(this.root);
    }

    @Preview(value={Previews.MACHINE_MAN})
    @Deprecated
    public GHAppInstallation getInstallationByRepository(String ownerName, String repositoryName) throws IOException {
        return ((Requester)((Requester)this.root.createRequest().withPreview(Previews.MACHINE_MAN)).withUrlPath(String.format("/repos/%s/%s/installation", ownerName, repositoryName), new String[0])).fetch(GHAppInstallation.class).wrapUp(this.root);
    }

    @Preview(value={Previews.MACHINE_MAN})
    @Deprecated
    public GHAppInstallation getInstallationByUser(String name) throws IOException {
        return ((Requester)((Requester)this.root.createRequest().withPreview(Previews.MACHINE_MAN)).withUrlPath(String.format("/users/%s/installation", name), new String[0])).fetch(GHAppInstallation.class).wrapUp(this.root);
    }
}

