/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.net.MalformedURLException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.kohsuke.github.GHAppInstallation;
import org.kohsuke.github.GHAppInstallationsPage;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubPageIterator;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

class GHAppInstallationsIterable
extends PagedIterable<GHAppInstallation> {
    public static final String APP_INSTALLATIONS_URL = "/user/installations";
    private final transient GitHub root;
    private GHAppInstallationsPage result;

    public GHAppInstallationsIterable(GitHub root) {
        this.root = root;
    }

    @Override
    @Nonnull
    public PagedIterator<GHAppInstallation> _iterator(int pageSize) {
        try {
            GitHubRequest request = ((Requester)this.root.createRequest().withUrlPath(APP_INSTALLATIONS_URL, new String[0])).build();
            return new PagedIterator<GHAppInstallation>(this.adapt(GitHubPageIterator.create(this.root.getClient(), GHAppInstallationsPage.class, request, pageSize)), null);
        }
        catch (MalformedURLException e) {
            throw new GHException("Malformed URL", e);
        }
    }

    protected Iterator<GHAppInstallation[]> adapt(final Iterator<GHAppInstallationsPage> base) {
        return new Iterator<GHAppInstallation[]>(){

            @Override
            public boolean hasNext() {
                return base.hasNext();
            }

            @Override
            public GHAppInstallation[] next() {
                GHAppInstallationsPage v = (GHAppInstallationsPage)base.next();
                if (GHAppInstallationsIterable.this.result == null) {
                    GHAppInstallationsIterable.this.result = v;
                }
                return v.getInstallations();
            }
        };
    }
}

