/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.kohsuke.github.ApiVersion;
import org.kohsuke.github.DeleteToken;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHHook;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPersonSet;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.JsonCollaborators;
import org.kohsuke.github.JsonIssues;
import org.kohsuke.github.JsonTeams;
import org.kohsuke.github.Poster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class GHRepository {
    GitHub root;
    private String description;
    private String homepage;
    private String name;
    private String url;
    private String html_url;
    private GHUser owner;
    private boolean has_issues;
    private boolean has_wiki;
    private boolean fork;
    private boolean _private;
    private boolean has_downloads;
    private int watchers;
    private int forks;
    private int open_issues;
    private String created_at;
    private String pushed_at;
    private final Set<URL> postCommitHooks = new AbstractSet<URL>(){

        private List<URL> getPostCommitHooks() {
            try {
                ArrayList<URL> r = new ArrayList<URL>();
                for (GHHook h : GHRepository.this.getHooks()) {
                    if (!h.getName().equals("web")) continue;
                    r.add(new URL(h.getConfig().get("url")));
                }
                return r;
            }
            catch (IOException e) {
                throw new GHException("Failed to retrieve post-commit hooks", e);
            }
        }

        @Override
        public Iterator<URL> iterator() {
            return this.getPostCommitHooks().iterator();
        }

        @Override
        public int size() {
            return this.getPostCommitHooks().size();
        }

        @Override
        public boolean add(URL url) {
            try {
                GHRepository.this.createWebHook(url);
                return true;
            }
            catch (IOException e) {
                throw new GHException("Failed to update post-commit hooks", e);
            }
        }

        @Override
        public boolean remove(Object url) {
            try {
                String _url = ((URL)url).toExternalForm();
                for (GHHook h : GHRepository.this.getHooks()) {
                    if (!h.getName().equals("web") || !h.getConfig().get("url").equals(_url)) continue;
                    h.delete();
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new GHException("Failed to update post-commit hooks", e);
            }
        }
    };

    public String getDescription() {
        return this.description;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public String getUrl() {
        return this.html_url;
    }

    public String getGitTransportUrl() {
        return "git://github.com/" + this.getOwnerName() + "/" + this.name + ".git";
    }

    public String gitHttpTransportUrl() {
        return "https://github.com/" + this.getOwnerName() + "/" + this.name + ".git";
    }

    public String getName() {
        return this.name;
    }

    public GHUser getOwner() throws IOException {
        return this.root.getUser(this.owner.login);
    }

    public List<GHIssue> getIssues(GHIssueState state) throws IOException {
        return this.root.retrieve("/issues/list/" + this.owner.login + "/" + this.name + "/" + state.toString().toLowerCase(), JsonIssues.class).wrap(this);
    }

    protected String getOwnerName() {
        return this.owner.login;
    }

    public boolean hasIssues() {
        return this.has_issues;
    }

    public boolean hasWiki() {
        return this.has_wiki;
    }

    public boolean isFork() {
        return this.fork;
    }

    public int getForks() {
        return this.forks;
    }

    public boolean isPrivate() {
        return this._private;
    }

    public boolean hasDownloads() {
        return this.has_downloads;
    }

    public int getWatchers() {
        return this.watchers;
    }

    public int getOpenIssueCount() {
        return this.open_issues;
    }

    public Date getPushedAt() {
        return GitHub.parseDate(this.pushed_at);
    }

    public Date getCreatedAt() {
        return GitHub.parseDate(this.created_at);
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHUser> getCollaborators() throws IOException {
        GHPersonSet<GHUser> r = new GHPersonSet<GHUser>();
        for (String u : this.root.retrieve((String)new StringBuilder().append((String)"/repos/show/").append((String)this.owner.login).append((String)"/").append((String)this.name).append((String)"/collaborators").toString(), JsonCollaborators.class).collaborators) {
            r.add(this.root.getUser(u));
        }
        return r;
    }

    public Set<String> getCollaboratorNames() throws IOException {
        HashSet<String> r = new HashSet<String>(this.root.retrieve((String)new StringBuilder().append((String)"/repos/show/").append((String)this.owner.login).append((String)"/").append((String)this.name).append((String)"/collaborators").toString(), JsonCollaborators.class).collaborators);
        return Collections.unmodifiableSet(r);
    }

    public Set<GHTeam> getTeams() throws IOException {
        return Collections.unmodifiableSet(this.root.retrieveWithAuth("/repos/show/" + this.owner.login + "/" + this.name + "/teams", JsonTeams.class).toSet(this.root.getOrganization(this.owner.login)));
    }

    public void addCollaborators(GHUser ... users) throws IOException {
        this.addCollaborators(Arrays.asList(users));
    }

    public void addCollaborators(Collection<GHUser> users) throws IOException {
        this.modifyCollaborators(users, "/add/");
    }

    public void removeCollaborators(GHUser ... users) throws IOException {
        this.removeCollaborators(Arrays.asList(users));
    }

    public void removeCollaborators(Collection<GHUser> users) throws IOException {
        this.modifyCollaborators(users, "/remove/");
    }

    private void modifyCollaborators(Collection<GHUser> users, String op) throws IOException {
        this.verifyMine();
        for (GHUser user : users) {
            new Poster(this.root).withCredential().to("/repos/collaborators/" + this.name + op + user.getLogin());
        }
    }

    public void setEmailServiceHook(String address) throws IOException {
        WebClient wc = this.root.createWebClient();
        HtmlPage pg = (HtmlPage)wc.getPage(this.getUrl() + "/admin");
        HtmlInput email = (HtmlInput)pg.getElementById("email_address");
        email.setValueAttribute(address);
        HtmlCheckBoxInput active = (HtmlCheckBoxInput)pg.getElementById("email[active]");
        active.setChecked(true);
        HtmlForm f = email.getEnclosingFormOrDie();
        f.submit((SubmittableElement)((HtmlButton)f.getElementsByTagName("button").get(0)));
    }

    public void enableIssueTracker(boolean v) throws IOException {
        new Poster(this.root).withCredential().with("values[has_issues]", String.valueOf(v)).to("/repos/show/" + this.owner.login + "/" + this.name);
    }

    public void enableWiki(boolean v) throws IOException {
        new Poster(this.root).withCredential().with("values[has_wiki]", String.valueOf(v)).to("/repos/show/" + this.owner.login + "/" + this.name);
    }

    public void delete() throws IOException {
        Poster poster = new Poster(this.root).withCredential();
        String url = "/repos/delete/" + this.owner.login + "/" + this.name;
        DeleteToken token = poster.to(url, DeleteToken.class);
        poster.with("delete_token", token.delete_token).to(url);
    }

    public GHRepository fork() throws IOException {
        return new Poster(this.root, ApiVersion.V3).withCredential().to("/repos/" + this.owner.login + "/" + this.name + "/forks", GHRepository.class, "POST").wrap(this.root);
    }

    public GHRepository forkTo(GHOrganization org) throws IOException {
        new Poster(this.root, ApiVersion.V3).withCredential().to(String.format("/repos/%s/%s/forks?org=%s", this.owner.login, this.name, org.getLogin()));
        return org.getRepository(this.name);
    }

    public void renameTo(String newName) throws IOException {
        WebClient wc = this.root.createWebClient();
        HtmlPage pg = (HtmlPage)wc.getPage(this.getUrl() + "/admin");
        for (HtmlForm f : pg.getForms()) {
            if (!f.getActionAttribute().endsWith("/rename")) continue;
            try {
                f.getInputByName("name").setValueAttribute(newName);
                f.submit((SubmittableElement)((HtmlButton)f.getElementsByTagName("button").get(0)));
                GHRepository r = this.getOwner().getRepository(newName);
                for (Field fi : this.getClass().getDeclaredFields()) {
                    if (Modifier.isStatic(fi.getModifiers())) continue;
                    fi.setAccessible(true);
                    try {
                        fi.set(this, fi.get(r));
                    }
                    catch (IllegalAccessException e) {
                        throw (IllegalAccessError)new IllegalAccessError().initCause(e);
                    }
                }
                return;
            }
            catch (ElementNotFoundException e) {
            }
        }
        throw new IllegalArgumentException("Either you don't have the privilege to rename " + this.owner.login + '/' + this.name + " or there's a bug in HTML scraping");
    }

    public GHPullRequest getPullRequest(int i) throws IOException {
        return this.root.retrieveWithAuth3("/repos/" + this.owner.login + '/' + this.name + "/pulls/" + i, GHPullRequest.class).wrapUp(this);
    }

    public List<GHPullRequest> getPullRequests(GHIssueState state) throws IOException {
        GHPullRequest[] r;
        for (GHPullRequest p : r = this.root.retrieveWithAuth3("/repos/" + this.owner.login + '/' + this.name + "/pulls?state=" + state.name().toLowerCase(Locale.ENGLISH), GHPullRequest[].class)) {
            p.wrapUp(this);
        }
        return new ArrayList<GHPullRequest>(Arrays.asList(r));
    }

    public List<GHHook> getHooks() throws IOException {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList((Object[])this.root.retrieveWithAuth3(String.format("/repos/%s/%s/hooks", this.owner.login, this.name), GHHook[].class)));
        for (GHHook gHHook : list) {
            gHHook.wrap(this);
        }
        return list;
    }

    public GHHook getHook(int id) throws IOException {
        return this.root.retrieveWithAuth3(String.format("/repos/%s/%s/hooks/%d", this.owner.login, this.name, id), GHHook.class).wrap(this);
    }

    public GHHook createHook(String name, Map<String, String> config, Collection<GHEvent> events, boolean active) throws IOException {
        ArrayList<String> ea = null;
        if (events != null) {
            ea = new ArrayList<String>();
            for (GHEvent e : events) {
                ea.add(e.name().toLowerCase(Locale.ENGLISH));
            }
        }
        return new Poster(this.root, ApiVersion.V3).withCredential().with("name", name).with("active", active)._with("config", config)._with("events", ea).to(String.format("/repos/%s/%s/hooks", this.owner.login, this.name), GHHook.class).wrap(this);
    }

    public GHHook createWebHook(URL url, Collection<GHEvent> events) throws IOException {
        return this.createHook("web", Collections.singletonMap("url", url.toExternalForm()), events, true);
    }

    public GHHook createWebHook(URL url) throws IOException {
        return this.createWebHook(url, null);
    }

    private void verifyMine() throws IOException {
        if (!this.root.login.equals(this.owner.login)) {
            throw new IOException("Operation not applicable to a repository owned by someone else: " + this.owner.login);
        }
    }

    public Set<URL> getPostCommitHooks() {
        return this.postCommitHooks;
    }

    GHRepository wrap(GitHub root) {
        this.root = root;
        return this;
    }

    public String toString() {
        return "Repository:" + this.owner.login + ":" + this.name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GHRepository) {
            GHRepository that = (GHRepository)obj;
            return this.owner.login.equals(that.owner.login) && this.name.equals(that.name);
        }
        return false;
    }
}

