/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GHPerson {
    GitHub root;
    protected String login;
    protected String location;
    protected String blog;
    protected String email;
    protected String name;
    protected String created_at;
    protected String company;
    protected int id;
    protected String gravatar_id;
    protected int public_gist_count;
    protected int public_repo_count;
    protected int followers_count;
    protected int following_count;
    protected String avatar_url;
    protected String html_url;
    protected int followers;
    protected int following;
    protected int public_repos;
    protected int public_gists;

    public synchronized Map<String, GHRepository> getRepositories() throws IOException {
        TreeMap<String, GHRepository> repositories = new TreeMap<String, GHRepository>();
        int i = 1;
        while (true) {
            GHRepository[] array;
            for (GHRepository r : array = this.root.retrieve3("/users/" + this.login + "/repos?per_page=100&page=" + i, GHRepository[].class)) {
                r.root = this.root;
                repositories.put(r.getName(), r);
            }
            if (array.length == 0) break;
            ++i;
        }
        return Collections.unmodifiableMap(repositories);
    }

    public GHRepository getRepository(String name) throws IOException {
        try {
            return this.root.retrieve3("/repos/" + this.login + '/' + name, GHRepository.class).wrap(this.root);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public String getGravatarId() {
        return this.gravatar_id;
    }

    public String getLogin() {
        return this.login;
    }

    public String getName() {
        return this.name;
    }

    public String getCompany() {
        return this.company;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCreatedAt() {
        return this.created_at;
    }

    public String getBlog() {
        return this.blog;
    }

    public String getEmail() {
        return this.email;
    }

    public int getPublicGistCount() {
        return Math.max(this.public_gist_count, this.public_gists);
    }

    public int getPublicRepoCount() {
        return Math.max(this.public_repo_count, this.public_repos);
    }

    public int getFollowingCount() {
        return Math.max(this.following_count, this.following);
    }

    public int getId() {
        return this.id;
    }

    public int getFollowersCount() {
        return Math.max(this.followers_count, this.followers);
    }
}

