/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.kohsuke.github.ApiVersion;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHMyself;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.JsonOrganization;
import org.kohsuke.github.JsonOrganizations;
import org.kohsuke.github.Poster;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
public class GitHub {
    final String login;
    final String encodedAuthorization;
    final String password;
    final String apiToken;
    private final Map<String, GHUser> users = new HashMap<String, GHUser>();
    private final Map<String, GHOrganization> orgs = new HashMap<String, GHOrganization>();
    String oauthAccessToken;
    private final String githubServer;
    static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String[] TIME_FORMATS = new String[]{"yyyy/MM/dd HH:mm:ss ZZZZ", "yyyy-MM-dd'T'HH:mm:ss'Z'"};

    private GitHub(String login, String apiToken, String password) {
        this("github.com", login, apiToken, password);
    }

    private GitHub(String githubServer, String login, String apiToken, String password) {
        this.githubServer = githubServer;
        this.login = login;
        this.apiToken = apiToken;
        this.password = password;
        BASE64Encoder enc = new BASE64Encoder();
        if (apiToken != null || password != null) {
            String userpassword = password == null ? login + "/token" + ":" + apiToken : login + ':' + password;
            this.encodedAuthorization = enc.encode(userpassword.getBytes());
        } else {
            this.encodedAuthorization = null;
        }
    }

    private GitHub(String githubServer, String oauthAccessToken) throws IOException {
        this.githubServer = githubServer;
        this.password = null;
        this.encodedAuthorization = null;
        this.oauthAccessToken = oauthAccessToken;
        this.apiToken = oauthAccessToken;
        this.login = this.getMyself().getLogin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GitHub connect() throws IOException {
        Properties props = new Properties();
        File homeDir = new File(System.getProperty("user.home"));
        FileInputStream in = new FileInputStream(new File(homeDir, ".github"));
        try {
            props.load(in);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return new GitHub(props.getProperty("login"), props.getProperty("token"), props.getProperty("password"));
    }

    public static GitHub connect(String login, String apiToken) throws IOException {
        return new GitHub(login, apiToken, null);
    }

    public static GitHub connect(String login, String apiToken, String password) throws IOException {
        return new GitHub(login, apiToken, password);
    }

    public static GitHub connectUsingOAuth(String accessToken) throws IOException {
        return GitHub.connectUsingOAuth("github.com", accessToken);
    }

    public static GitHub connectUsingOAuth(String githubServer, String accessToken) throws IOException {
        return new GitHub(githubServer, accessToken);
    }

    public static GitHub connectAnonymously() {
        return new GitHub(null, null, null);
    }

    void requireCredential() {
        if ((this.login == null || this.encodedAuthorization == null) && this.oauthAccessToken == null) {
            throw new IllegalStateException("This operation requires a credential but none is given to the GitHub constructor");
        }
    }

    URL getApiURL(ApiVersion v, String tailApiUrl) throws IOException {
        if (this.oauthAccessToken != null) {
            tailApiUrl = tailApiUrl + (tailApiUrl.indexOf(63) >= 0 ? (char)'&' : '?') + "access_token=" + this.oauthAccessToken;
        }
        return new URL(v.getApiVersionBaseUrl(this.githubServer) + tailApiUrl);
    }

    <T> T retrieve(String tailApiUrl, Class<T> type) throws IOException {
        return this._retrieve(tailApiUrl, type, "GET", false, ApiVersion.V2);
    }

    <T> T retrieve3(String tailApiUrl, Class<T> type) throws IOException {
        return this._retrieve(tailApiUrl, type, "GET", false, ApiVersion.V3);
    }

    <T> T retrieveWithAuth(String tailApiUrl, Class<T> type) throws IOException {
        return this.retrieveWithAuth(tailApiUrl, type, "GET");
    }

    <T> T retrieveWithAuth3(String tailApiUrl, Class<T> type) throws IOException {
        return this._retrieve(tailApiUrl, type, "GET", true, ApiVersion.V3);
    }

    <T> T retrieveWithAuth(String tailApiUrl, Class<T> type, String method) throws IOException {
        return this._retrieve(tailApiUrl, type, method, true, ApiVersion.V2);
    }

    <T> T retrieveWithAuth3(String tailApiUrl, Class<T> type, String method) throws IOException {
        return this._retrieve(tailApiUrl, type, method, true, ApiVersion.V3);
    }

    private <T> T _retrieve(String tailApiUrl, Class<T> type, String method, boolean withAuth, ApiVersion v) throws IOException {
        while (true) {
            HttpURLConnection uc = this.setupConnection(method, withAuth, this.getApiURL(v, tailApiUrl));
            try {
                return this.parse(uc, type);
            }
            catch (IOException e) {
                this.handleApiError(e, uc);
                continue;
            }
            break;
        }
    }

    <T> Iterator<T> retrievePaged(final String tailApiUrl, final Class<T> type, final boolean withAuth, final ApiVersion v) {
        return new Iterator<T>(){
            T next;
            URL url;
            {
                try {
                    this.url = GitHub.this.getApiURL(v, tailApiUrl);
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }

            @Override
            public boolean hasNext() {
                this.fetch();
                return this.next != null;
            }

            @Override
            public T next() {
                this.fetch();
                Object r = this.next;
                if (r == null) {
                    throw new NoSuchElementException();
                }
                this.next = null;
                return r;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void fetch() {
                if (this.next != null) {
                    return;
                }
                if (this.url == null) {
                    return;
                }
                try {
                    while (true) {
                        HttpURLConnection uc = GitHub.this.setupConnection("GET", withAuth, this.url);
                        try {
                            this.next = GitHub.this.parse(uc, type);
                            assert (this.next != null);
                            this.findNextURL(uc);
                            return;
                        }
                        catch (IOException e) {
                            GitHub.this.handleApiError(e, uc);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }

            private void findNextURL(HttpURLConnection uc) throws MalformedURLException {
                this.url = null;
                String link = uc.getHeaderField("Link");
                if (link == null) {
                    return;
                }
                for (String token : link.split(", ")) {
                    if (!token.endsWith("rel=\"next\"")) continue;
                    int idx = token.indexOf(62);
                    this.url = new URL(token.substring(1, idx));
                    return;
                }
            }
        };
    }

    private HttpURLConnection setupConnection(String method, boolean withAuth, URL url) throws IOException {
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        if (withAuth && this.oauthAccessToken == null) {
            uc.setRequestProperty("Authorization", "Basic " + this.encodedAuthorization);
        }
        uc.setRequestMethod(method);
        if (method.equals("PUT")) {
            uc.setDoOutput(true);
            uc.setRequestProperty("Content-Length", "0");
            uc.getOutputStream().close();
        }
        uc.setRequestProperty("Accept-Encoding", "gzip");
        return uc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T parse(HttpURLConnection uc, Class<T> type) throws IOException {
        InputStreamReader r;
        block3: {
            T t;
            r = null;
            try {
                r = new InputStreamReader(this.wrapStream(uc, uc.getInputStream()), "UTF-8");
                if (type != null) break block3;
                String data = IOUtils.toString((Reader)r);
                t = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(r);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)r);
            return t;
        }
        Object object = MAPPER.readValue((Reader)r, type);
        IOUtils.closeQuietly((Reader)r);
        return (T)object;
    }

    private InputStream wrapStream(HttpURLConnection uc, InputStream in) throws IOException {
        String encoding = uc.getContentEncoding();
        if (encoding == null) {
            return in;
        }
        if (encoding.equals("gzip")) {
            return new GZIPInputStream(in);
        }
        throw new UnsupportedOperationException("Unexpected Content-Encoding: " + encoding);
    }

    void handleApiError(IOException e, HttpURLConnection uc) throws IOException {
        if ("0".equals(uc.getHeaderField("X-RateLimit-Remaining"))) {
            try {
                Thread.sleep(10000L);
                return;
            }
            catch (InterruptedException _) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
        }
        if (e instanceof FileNotFoundException) {
            throw e;
        }
        InputStream es = this.wrapStream(uc, uc.getErrorStream());
        try {
            if (es != null) {
                throw (IOException)new IOException(IOUtils.toString((InputStream)es, (String)"UTF-8")).initCause(e);
            }
            throw e;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)es);
            throw throwable;
        }
    }

    @WithBridgeMethods(value={GHUser.class})
    public GHMyself getMyself() throws IOException {
        this.requireCredential();
        GHMyself u = this.retrieveWithAuth3("/user", GHMyself.class);
        u.root = this;
        this.users.put(u.getLogin(), u);
        return u;
    }

    public GHUser getUser(String login) throws IOException {
        GHUser u = this.users.get(login);
        if (u == null) {
            u = this.retrieve3("/users/" + login, GHUser.class);
            u.root = this;
            this.users.put(u.getLogin(), u);
        }
        return u;
    }

    protected GHUser getUser(GHUser orig) throws IOException {
        GHUser u = this.users.get(orig.getLogin());
        if (u == null) {
            orig.root = this;
            this.users.put(this.login, orig);
            return orig;
        }
        return u;
    }

    public GHOrganization getOrganization(String name) throws IOException {
        GHOrganization o = this.orgs.get(name);
        if (o == null) {
            o = this.retrieve((String)new StringBuilder().append((String)"/organizations/").append((String)name).toString(), JsonOrganization.class).organization;
            o.root = this;
            this.orgs.put(name, o);
        }
        return o;
    }

    public GHRepository getRepository(String name) throws IOException {
        String[] tokens = name.split("/");
        return this.getUser(tokens[0]).getRepository(tokens[1]);
    }

    public Map<String, GHOrganization> getMyOrganizations() throws IOException {
        return this.retrieveWithAuth("/organizations", JsonOrganizations.class).wrap(this);
    }

    public List<GHEventInfo> getEvents() throws IOException {
        GHEventInfo[] events;
        for (GHEventInfo e : events = this.retrieve3("/events", GHEventInfo[].class)) {
            e.wrapUp(this);
        }
        return Arrays.asList(events);
    }

    public <T extends GHEventPayload> T parseEventPayload(Reader r, Class<T> type) throws IOException {
        GHEventPayload t = (GHEventPayload)MAPPER.readValue(r, type);
        t.wrapUp(this);
        return (T)t;
    }

    public GHRepository createRepository(String name, String description, String homepage, boolean isPublic) throws IOException {
        return new Poster(this, ApiVersion.V3).withCredential().with("name", name).with("description", description).with("homepage", homepage).with("public", isPublic ? 1 : 0).to("/user/repos", GHRepository.class, "POST").wrap(this);
    }

    public boolean isCredentialValid() throws IOException {
        try {
            this.retrieveWithAuth3("/user", GHUser.class);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    WebClient createWebClient() throws IOException {
        WebClient wc = new WebClient();
        wc.setJavaScriptEnabled(false);
        wc.setCssEnabled(false);
        HtmlPage pg = (HtmlPage)wc.getPage("https://github.com/login");
        HtmlForm f = (HtmlForm)pg.getForms().get(0);
        f.getInputByName("login").setValueAttribute(this.login);
        f.getInputByName("password").setValueAttribute(this.password);
        f.submit();
        return wc;
    }

    static URL parseURL(String s) {
        try {
            return s == null ? null : new URL(s);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + s);
        }
    }

    static Date parseDate(String timestamp) {
        for (String f : TIME_FORMATS) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(f);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df.parse(timestamp);
            }
            catch (ParseException e) {
            }
        }
        throw new IllegalStateException("Unable to parse the timestamp: " + timestamp);
    }

    static {
        MAPPER.setVisibilityChecker((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        MAPPER.getDeserializationConfig().set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

