/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.JsonRepositories;
import org.kohsuke.github.JsonUsersWithDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHTeam {
    private String name;
    private String permission;
    private int id;
    protected GHOrganization org;

    public String getName() {
        return this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getId() {
        return this.id;
    }

    public Set<GHUser> getMembers() throws IOException {
        return this.org.root.retrieveWithAuth(this.api("/members"), JsonUsersWithDetails.class).toSet(this.org.root);
    }

    public Map<String, GHRepository> getRepositories() throws IOException {
        return this.org.root.retrieveWithAuth3(this.api("/repos"), JsonRepositories.class).wrap(this.org.root);
    }

    public void add(GHUser u) throws IOException {
        this.org.root.retrieveWithAuth(this.api("/members?name=" + u.getLogin()), null, "POST");
    }

    public void remove(GHUser u) throws IOException {
        this.org.root.retrieveWithAuth(this.api("/members?name=" + u.getLogin()), null, "DELETE");
    }

    public void add(GHRepository r) throws IOException {
        this.org.root.retrieveWithAuth(this.api("/repositories?name=" + r.getOwnerName() + '/' + r.getName()), null, "POST");
    }

    public void remove(GHRepository r) throws IOException {
        this.org.root.retrieveWithAuth(this.api("/repositories?name=" + r.getOwnerName() + '/' + r.getName()), null, "DELETE");
    }

    private String api(String tail) {
        return "/teams/" + this.id + tail;
    }
}

