/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GitHub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Poster {
    private final GitHub root;
    private final Map<String, String> args = new HashMap<String, String>();

    Poster(GitHub root) {
        this.root = root;
    }

    public Poster withCredential() {
        this.root.requireCredential();
        return this.with("login", this.root.login).with("token", this.root.token);
    }

    public Poster with(String key, int value) {
        return this.with(key, String.valueOf(value));
    }

    public Poster with(String key, String value) {
        if (value != null) {
            this.args.put(key, value);
        }
        return this;
    }

    public void to(URL url) throws IOException {
        this.to(url, null);
    }

    public <T> T to(URL url, Class<T> type) throws IOException {
        return this.to(url, type, "POST");
    }

    public <T> T to(URL url, Class<T> type, String method) throws IOException {
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        uc.setDoOutput(true);
        uc.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        uc.setRequestMethod(method);
        StringBuilder body = new StringBuilder();
        for (Map.Entry<String, String> e : this.args.entrySet()) {
            if (body.length() > 0) {
                body.append('&');
            }
            body.append(URLEncoder.encode(e.getKey(), "UTF-8"));
            body.append('=');
            body.append(URLEncoder.encode(e.getValue(), "UTF-8"));
        }
        OutputStreamWriter o = new OutputStreamWriter(uc.getOutputStream(), "UTF-8");
        o.write(body.toString());
        o.close();
        try {
            InputStreamReader r = new InputStreamReader(uc.getInputStream(), "UTF-8");
            if (type == null) {
                String data = IOUtils.toString((Reader)r);
                return null;
            }
            return (T)GitHub.MAPPER.readValue((Reader)r, type);
        }
        catch (IOException e) {
            throw (IOException)new IOException(IOUtils.toString((InputStream)uc.getErrorStream(), (String)"UTF-8")).initCause(e);
        }
    }
}

