/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.Iterator;
import javax.annotation.Nonnull;
import org.kohsuke.github.GHArtifact;
import org.kohsuke.github.GHArtifactsPage;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubPageIterator;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;

class GHArtifactsIterable
extends PagedIterable<GHArtifact> {
    private final transient GHRepository owner;
    private final GitHubRequest request;
    private GHArtifactsPage result;

    public GHArtifactsIterable(GHRepository owner, GitHubRequest.Builder<?> requestBuilder) {
        this.owner = owner;
        this.request = requestBuilder.build();
    }

    @Override
    @Nonnull
    public PagedIterator<GHArtifact> _iterator(int pageSize) {
        return new PagedIterator<GHArtifact>(this.adapt(GitHubPageIterator.create(this.owner.root().getClient(), GHArtifactsPage.class, this.request, pageSize)), null);
    }

    protected Iterator<GHArtifact[]> adapt(final Iterator<GHArtifactsPage> base) {
        return new Iterator<GHArtifact[]>(){

            @Override
            public boolean hasNext() {
                return base.hasNext();
            }

            @Override
            public GHArtifact[] next() {
                GHArtifactsPage v = (GHArtifactsPage)base.next();
                if (GHArtifactsIterable.this.result == null) {
                    GHArtifactsIterable.this.result = v;
                }
                return v.getArtifacts(GHArtifactsIterable.this.owner);
            }
        };
    }
}

