/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GHCommentAuthorAssociation;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHReaction;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Reactable;
import org.kohsuke.github.ReactionContent;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.Previews;

public class GHIssueComment
extends GHObject
implements Reactable {
    GHIssue owner;
    private String body;
    private String gravatar_id;
    private String html_url;
    private String author_association;
    private GHUser user;

    GHIssueComment wrapUp(GHIssue owner) {
        this.owner = owner;
        return this;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHIssue getParent() {
        return this.owner;
    }

    public String getBody() {
        return this.body;
    }

    @Deprecated
    public String getUserName() {
        return this.user.getLogin();
    }

    public GHUser getUser() throws IOException {
        return this.owner == null || this.owner.isOffline() ? this.user : this.owner.root().getUser(this.user.getLogin());
    }

    @Override
    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.html_url);
    }

    public GHCommentAuthorAssociation getAuthorAssociation() {
        return GHCommentAuthorAssociation.valueOf(this.author_association);
    }

    public void update(String body) throws IOException {
        ((Requester)((Requester)((Requester)this.owner.root().createRequest().method("PATCH")).with("body", body)).withUrlPath(this.getApiRoute(), new String[0])).fetch(GHIssueComment.class);
        this.body = body;
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.owner.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    @Override
    @Preview(value={Previews.SQUIRREL_GIRL})
    public GHReaction createReaction(ReactionContent content) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)this.owner.root().createRequest().method("POST")).withPreview(Previews.SQUIRREL_GIRL)).with("content", content.getContent())).withUrlPath(this.getApiRoute() + "/reactions", new String[0])).fetch(GHReaction.class);
    }

    @Override
    @Preview(value={Previews.SQUIRREL_GIRL})
    public PagedIterable<GHReaction> listReactions() {
        return ((Requester)((Requester)this.owner.root().createRequest().withPreview(Previews.SQUIRREL_GIRL)).withUrlPath(this.getApiRoute() + "/reactions", new String[0])).toIterable(GHReaction[].class, item -> this.owner.root());
    }

    private String getApiRoute() {
        return "/repos/" + this.owner.getRepository().getOwnerName() + "/" + this.owner.getRepository().getName() + "/issues/comments/" + this.getId();
    }
}

