/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.kohsuke.github.GHApp;
import org.kohsuke.github.GHCheckRunBuilder;
import org.kohsuke.github.GHCheckSuite;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.Preview;
import org.kohsuke.github.internal.EnumUtils;
import org.kohsuke.github.internal.Previews;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
@BridgeMethodsAdded
public class GHCheckRun
extends GHObject {
    @JsonProperty(value="repository")
    GHRepository owner;
    private String status;
    private String conclusion;
    private String name;
    private String headSha;
    private String nodeId;
    private String externalId;
    private String startedAt;
    private String completedAt;
    private String htmlUrl;
    private String detailsUrl;
    private Output output;
    private GHApp app;
    private GHPullRequest[] pullRequests = new GHPullRequest[0];
    private GHCheckSuite checkSuite;

    GHCheckRun wrap(GHRepository owner) {
        this.owner = owner;
        this.wrap(owner.root());
        return this;
    }

    GHCheckRun wrap(GitHub root) {
        if (this.owner != null) {
            for (GHPullRequest singlePull : this.pullRequests) {
                singlePull.wrap(this.owner);
            }
        }
        if (this.checkSuite != null) {
            if (this.owner != null) {
                this.checkSuite.wrap(this.owner);
            } else {
                this.checkSuite.wrap(root);
            }
        }
        return this;
    }

    @WithBridgeMethods(value={String.class}, adapterMethod="statusAsStr")
    public Status getStatus() {
        return Status.from(this.status);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Bridge method of getStatus")
    private Object statusAsStr(Status status, Class type) {
        return status;
    }

    @WithBridgeMethods(value={String.class}, adapterMethod="conclusionAsStr")
    public Conclusion getConclusion() {
        return Conclusion.from(this.conclusion);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Bridge method of getConclusion")
    private Object conclusionAsStr(Conclusion conclusion, Class type) {
        return conclusion;
    }

    public String getName() {
        return this.name;
    }

    public String getHeadSha() {
        return this.headSha;
    }

    public List<GHPullRequest> getPullRequests() throws IOException {
        for (GHPullRequest singlePull : this.pullRequests) {
            singlePull.refresh(singlePull.getTitle());
        }
        return Collections.unmodifiableList(Arrays.asList(this.pullRequests));
    }

    @Override
    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public URL getDetailsUrl() {
        return GitHubClient.parseURL(this.detailsUrl);
    }

    public Date getStartedAt() {
        return GitHubClient.parseDate(this.startedAt);
    }

    public Date getCompletedAt() {
        return GitHubClient.parseDate(this.completedAt);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public GHApp getApp() {
        return this.app;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public GHCheckSuite getCheckSuite() {
        return this.checkSuite;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public Output getOutput() {
        return this.output;
    }

    @Preview(value={Previews.ANTIOPE})
    @NonNull
    public GHCheckRunBuilder update() {
        return new GHCheckRunBuilder(this.owner, this.getId());
    }

    public static enum AnnotationLevel {
        NOTICE,
        WARNING,
        FAILURE;

    }

    public static class Output {
        private String title;
        private String summary;
        private String text;
        private int annotationsCount;
        private String annotationsUrl;

        public String getTitle() {
            return this.title;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getText() {
            return this.text;
        }

        public int getAnnotationsCount() {
            return this.annotationsCount;
        }

        public URL getAnnotationsUrl() {
            return GitHubClient.parseURL(this.annotationsUrl);
        }
    }

    public static enum Conclusion {
        ACTION_REQUIRED,
        CANCELLED,
        FAILURE,
        NEUTRAL,
        SUCCESS,
        SKIPPED,
        STALE,
        TIMED_OUT,
        UNKNOWN;


        public static Conclusion from(String value) {
            return EnumUtils.getNullableEnumOrDefault(Conclusion.class, value, UNKNOWN);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Status {
        QUEUED,
        IN_PROGRESS,
        COMPLETED,
        UNKNOWN;


        public static Status from(String value) {
            return EnumUtils.getNullableEnumOrDefault(Status.class, value, UNKNOWN);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

