/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubPageIterator;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.GitUser;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

public class GHCompare {
    private String url;
    private String html_url;
    private String permalink_url;
    private String diff_url;
    private String patch_url;
    private Status status;
    private int ahead_by;
    private int behind_by;
    private int total_commits;
    private Commit base_commit;
    private Commit merge_base_commit;
    private Commit[] commits;
    private GHCommit.File[] files;
    private GHRepository owner;
    @JacksonInject(value="GHCompare_usePaginatedCommits")
    private boolean usePaginatedCommits;

    public URL getUrl() {
        return GitHubClient.parseURL(this.url);
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.html_url);
    }

    public URL getPermalinkUrl() {
        return GitHubClient.parseURL(this.permalink_url);
    }

    public URL getDiffUrl() {
        return GitHubClient.parseURL(this.diff_url);
    }

    public URL getPatchUrl() {
        return GitHubClient.parseURL(this.patch_url);
    }

    public Status getStatus() {
        return this.status;
    }

    public int getAheadBy() {
        return this.ahead_by;
    }

    public int getBehindBy() {
        return this.behind_by;
    }

    public int getTotalCommits() {
        return this.total_commits;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public Commit getBaseCommit() {
        return this.base_commit;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public Commit getMergeBaseCommit() {
        return this.merge_base_commit;
    }

    public Commit[] getCommits() {
        try {
            return this.listCommits().withPageSize(100).toArray();
        }
        catch (IOException e) {
            throw new GHException(e.getMessage(), e);
        }
    }

    public PagedIterable<Commit> listCommits() {
        if (this.usePaginatedCommits) {
            return new GHCompareCommitsIterable();
        }
        return new PagedIterable<Commit>(){

            @Override
            @Nonnull
            public PagedIterator<Commit> _iterator(int pageSize) {
                return new PagedIterator<Commit>(Collections.singleton(GHCompare.this.commits).iterator(), null);
            }
        };
    }

    public GHCommit.File[] getFiles() {
        GHCommit.File[] newValue = new GHCommit.File[this.files.length];
        System.arraycopy(this.files, 0, newValue, 0, this.files.length);
        return newValue;
    }

    @Deprecated
    public GHCompare wrap(GHRepository owner) {
        throw new RuntimeException("Do not use this method.");
    }

    GHCompare lateBind(GHRepository owner) {
        this.owner = owner;
        for (Commit commit : this.commits) {
            commit.wrapUp(owner);
        }
        this.merge_base_commit.wrapUp(owner);
        this.base_commit.wrapUp(owner);
        return this;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class Commit
    extends GHCommit {
        private InnerCommit commit;

        public InnerCommit getCommit() {
            return this.commit;
        }
    }

    public static enum Status {
        behind,
        ahead,
        identical,
        diverged;

    }

    class GHCompareCommitsIterable
    extends PagedIterable<Commit> {
        private GHCompare result;

        @Override
        @Nonnull
        public PagedIterator<Commit> _iterator(int pageSize) {
            GitHubRequest request = ((Requester)((Requester)GHCompare.this.owner.root().createRequest().injectMappingValue("GHCompare_usePaginatedCommits", GHCompare.this.usePaginatedCommits)).withUrlPath(GHCompare.this.owner.getApiTailUrl(GHCompare.this.url.substring(GHCompare.this.url.lastIndexOf("/compare/"))), new String[0])).build();
            if (pageSize == 0) {
                pageSize = 10;
            }
            return new PagedIterator<Commit>(this.adapt(GitHubPageIterator.create(GHCompare.this.owner.root().getClient(), GHCompare.class, request, pageSize)), item -> item.wrapUp(GHCompare.this.owner));
        }

        protected Iterator<Commit[]> adapt(final Iterator<GHCompare> base) {
            return new Iterator<Commit[]>(){

                @Override
                public boolean hasNext() {
                    return base.hasNext();
                }

                @Override
                public Commit[] next() {
                    GHCompare v = (GHCompare)base.next();
                    if (GHCompareCommitsIterable.this.result == null) {
                        GHCompareCommitsIterable.this.result = v;
                    }
                    return v.commits;
                }
            };
        }
    }

    public static class User
    extends GitUser {
    }

    public static class Tree {
        private String url;
        private String sha;

        public String getUrl() {
            return this.url;
        }

        public String getSha() {
            return this.sha;
        }
    }

    public static class InnerCommit {
        private String url;
        private String sha;
        private String message;
        private User author;
        private User committer;
        private Tree tree;

        public String getUrl() {
            return this.url;
        }

        public String getSha() {
            return this.sha;
        }

        public String getMessage() {
            return this.message;
        }

        @WithBridgeMethods(value={User.class}, castRequired=true)
        public GitUser getAuthor() {
            return this.author;
        }

        @WithBridgeMethods(value={User.class}, castRequired=true)
        public GitUser getCommitter() {
            return this.committer;
        }

        public Tree getTree() {
            return this.tree;
        }
    }
}

