/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubInteractiveObject;
import org.kohsuke.github.Requester;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
public class GHBranchProtection
extends GitHubInteractiveObject {
    private static final String REQUIRE_SIGNATURES_URI = "/required_signatures";
    @JsonProperty
    private AllowDeletions allowDeletions;
    @JsonProperty
    private AllowForcePushes allowForcePushes;
    @JsonProperty
    private AllowForkSyncing allowForkSyncing;
    @JsonProperty
    private BlockCreations blockCreations;
    @JsonProperty
    private EnforceAdmins enforceAdmins;
    @JsonProperty
    private LockBranch lockBranch;
    @JsonProperty
    private RequiredConversationResolution requiredConversationResolution;
    @JsonProperty
    private RequiredLinearHistory requiredLinearHistory;
    @JsonProperty(value="required_pull_request_reviews")
    private RequiredReviews requiredReviews;
    @JsonProperty
    private RequiredStatusChecks requiredStatusChecks;
    @JsonProperty
    private Restrictions restrictions;
    @JsonProperty
    private String url;

    public void enabledSignedCommits() throws IOException {
        ((Requester)((Requester)this.requester().method("POST")).withUrlPath(this.url + REQUIRE_SIGNATURES_URI, new String[0])).fetch(RequiredSignatures.class);
    }

    public void disableSignedCommits() throws IOException {
        ((Requester)((Requester)this.requester().method("DELETE")).withUrlPath(this.url + REQUIRE_SIGNATURES_URI, new String[0])).send();
    }

    public AllowDeletions getAllowDeletions() {
        return this.allowDeletions;
    }

    public AllowForcePushes getAllowForcePushes() {
        return this.allowForcePushes;
    }

    public AllowForkSyncing getAllowForkSyncing() {
        return this.allowForkSyncing;
    }

    public BlockCreations getBlockCreations() {
        return this.blockCreations;
    }

    public EnforceAdmins getEnforceAdmins() {
        return this.enforceAdmins;
    }

    public LockBranch getLockBranch() {
        return this.lockBranch;
    }

    public RequiredConversationResolution getRequiredConversationResolution() {
        return this.requiredConversationResolution;
    }

    public RequiredLinearHistory getRequiredLinearHistory() {
        return this.requiredLinearHistory;
    }

    public RequiredReviews getRequiredReviews() {
        return this.requiredReviews;
    }

    public boolean getRequiredSignatures() throws IOException {
        return ((Requester)this.requester().withUrlPath(this.url + REQUIRE_SIGNATURES_URI, new String[0])).fetch(RequiredSignatures.class).enabled;
    }

    public RequiredStatusChecks getRequiredStatusChecks() {
        return this.requiredStatusChecks;
    }

    public Restrictions getRestrictions() {
        return this.restrictions;
    }

    public String getUrl() {
        return this.url;
    }

    private Requester requester() {
        return this.root().createRequest();
    }

    private static class RequiredSignatures {
        @JsonProperty
        private boolean enabled;
        @JsonProperty
        private String url;

        private RequiredSignatures() {
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class AllowDeletions {
        @JsonProperty
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class AllowForcePushes {
        @JsonProperty
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class AllowForkSyncing {
        @JsonProperty
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class BlockCreations {
        @JsonProperty
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class EnforceAdmins {
        @JsonProperty
        private boolean enabled;
        @JsonProperty
        private String url;

        public String getUrl() {
            return this.url;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class LockBranch {
        @JsonProperty
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class RequiredConversationResolution {
        @JsonProperty
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class RequiredLinearHistory {
        @JsonProperty
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class RequiredReviews {
        @JsonProperty(value="dismissal_restrictions")
        private Restrictions dismissalRestriction;
        @JsonProperty
        private boolean dismissStaleReviews;
        @JsonProperty
        private boolean requireCodeOwnerReviews;
        @JsonProperty
        private boolean requireLastPushApproval;
        @JsonProperty(value="required_approving_review_count")
        private int requiredReviewers;
        @JsonProperty
        private String url;

        public Restrictions getDismissalRestrictions() {
            return this.dismissalRestriction;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isDismissStaleReviews() {
            return this.dismissStaleReviews;
        }

        public boolean isRequireCodeOwnerReviews() {
            return this.requireCodeOwnerReviews;
        }

        public boolean isRequireLastPushApproval() {
            return this.requireLastPushApproval;
        }

        public int getRequiredReviewers() {
            return this.requiredReviewers;
        }
    }

    public static class RequiredStatusChecks {
        @JsonProperty
        private Collection<String> contexts;
        @JsonProperty
        private Collection<Check> checks;
        @JsonProperty
        private boolean strict;
        @JsonProperty
        private String url;

        public Collection<String> getContexts() {
            return Collections.unmodifiableCollection(this.contexts);
        }

        public Collection<Check> getChecks() {
            return Collections.unmodifiableCollection(this.checks);
        }

        public String getUrl() {
            return this.url;
        }

        public boolean isRequiresBranchUpToDate() {
            return this.strict;
        }
    }

    public static class Restrictions {
        @JsonProperty
        private Collection<GHTeam> teams;
        private String teamsUrl;
        @JsonProperty
        private String url;
        @JsonProperty
        private Collection<GHUser> users;
        private String usersUrl;

        public Collection<GHTeam> getTeams() {
            return Collections.unmodifiableCollection(this.teams);
        }

        public String getTeamsUrl() {
            return this.teamsUrl;
        }

        public String getUrl() {
            return this.url;
        }

        public Collection<GHUser> getUsers() {
            return Collections.unmodifiableCollection(this.users);
        }

        public String getUsersUrl() {
            return this.usersUrl;
        }
    }

    public static class Check {
        private String context;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Integer appId;

        public Check() {
        }

        public Check(String context, Integer appId) {
            this.context = context;
            this.appId = appId;
        }

        public String getContext() {
            return this.context;
        }

        public Integer getAppId() {
            return this.appId;
        }
    }
}

