/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.JsonRepositories;
import org.kohsuke.github.JsonRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GHPerson {
    GitHub root;
    protected String gravatar_id;
    protected String login;
    protected int public_gist_count;
    protected int public_repo_count;
    protected int following_count;
    protected int id;
    private transient Map<String, GHRepository> repositories;

    public synchronized Map<String, GHRepository> getRepositories() throws IOException {
        if (this.repositories == null) {
            this.repositories = Collections.synchronizedMap(new TreeMap());
            this.repositories.putAll(this.root.retrieve("/repos/show/" + this.login, JsonRepositories.class).wrap(this.root));
        }
        return Collections.unmodifiableMap(this.repositories);
    }

    protected GHRepository refreshRepository(String name) throws IOException {
        if (this.repositories == null) {
            this.getRepositories();
        }
        GHRepository r = this.root.retrieve("/repos/show/" + this.login + '/' + name, JsonRepository.class).wrap(this.root);
        this.repositories.put(name, r);
        return r;
    }

    public GHRepository getRepository(String name) throws IOException {
        return this.getRepositories().get(name);
    }

    public String getGravatarId() {
        return this.gravatar_id;
    }

    public String getLogin() {
        return this.login;
    }
}

