/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.kohsuke.github.DeleteToken;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.JsonCollaborators;
import org.kohsuke.github.JsonRepository;
import org.kohsuke.github.Poster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHRepository {
    GitHub root;
    private String description;
    private String homepage;
    private String url;
    private String name;
    private String owner;
    private boolean has_issues;
    private boolean has_wiki;
    private boolean fork;
    private boolean _private;
    private boolean has_downloads;
    private int watchers;
    private int forks;
    private final Set<URL> postCommitHooks = new AbstractSet<URL>(){

        private List<URL> getPostCommitHooks() {
            try {
                GHRepository.this.verifyMine();
                HtmlForm f = this.getForm();
                ArrayList<URL> r = new ArrayList<URL>();
                for (HtmlInput i : f.getInputsByName("urls[]")) {
                    String v = i.getValueAttribute();
                    if (v.length() == 0) continue;
                    r.add(new URL(v));
                }
                return r;
            }
            catch (IOException e) {
                throw new GHException("Failed to retrieve post-commit hooks", e);
            }
        }

        @Override
        public Iterator<URL> iterator() {
            return this.getPostCommitHooks().iterator();
        }

        @Override
        public int size() {
            return this.getPostCommitHooks().size();
        }

        @Override
        public boolean add(URL url) {
            try {
                String u = url.toExternalForm();
                GHRepository.this.verifyMine();
                HtmlForm f = this.getForm();
                List controls = f.getInputsByName("urls[]");
                for (HtmlInput i : controls) {
                    String v = i.getValueAttribute();
                    if (v.length() == 0 || !v.equals(u)) continue;
                    return false;
                }
                ((HtmlInput)controls.get(controls.size() - 1)).setValueAttribute(u);
                f.submit(null);
                return true;
            }
            catch (IOException e) {
                throw new GHException("Failed to update post-commit hooks", e);
            }
        }

        @Override
        public boolean remove(Object o) {
            try {
                String u = ((URL)o).toExternalForm();
                GHRepository.this.verifyMine();
                HtmlForm f = this.getForm();
                List controls = f.getInputsByName("urls[]");
                for (HtmlInput i : controls) {
                    String v = i.getValueAttribute();
                    if (v.length() == 0 || !v.equals(u)) continue;
                    i.setValueAttribute("");
                    f.submit(null);
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new GHException("Failed to update post-commit hooks", e);
            }
        }

        private HtmlForm getForm() throws IOException {
            WebClient wc = GHRepository.this.root.createWebClient();
            HtmlPage pg = (HtmlPage)wc.getPage(GHRepository.this.getUrl() + "/admin");
            HtmlForm f = (HtmlForm)pg.getElementById("new_service");
            return f;
        }
    };

    public String getDescription() {
        return this.description;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public GHUser getOwner() throws IOException {
        return this.root.getUser(this.owner);
    }

    protected String getOwnerName() {
        return this.owner;
    }

    public boolean hasIssues() {
        return this.has_issues;
    }

    public boolean hasWiki() {
        return this.has_wiki;
    }

    public boolean isFork() {
        return this.fork;
    }

    public int getForks() {
        return this.forks;
    }

    public boolean isPrivate() {
        return this._private;
    }

    public boolean hasDownloads() {
        return this.has_downloads;
    }

    public int getWatchers() {
        return this.watchers;
    }

    public Set<GHUser> getCollaborators() throws IOException {
        HashSet<GHUser> r = new HashSet<GHUser>();
        for (String u : this.root.retrieve((String)new StringBuilder().append((String)"/repos/show/").append((String)this.owner).append((String)"/").append((String)this.name).append((String)"/collaborators").toString(), JsonCollaborators.class).collaborators) {
            r.add(this.root.getUser(u));
        }
        return Collections.unmodifiableSet(r);
    }

    public void addCollaborators(GHUser ... users) throws IOException {
        this.addCollaborators(Arrays.asList(users));
    }

    public void addCollaborators(Collection<GHUser> users) throws IOException {
        this.modifyCollaborators(users, "/add/");
    }

    public void removeCollaborators(GHUser ... users) throws IOException {
        this.removeCollaborators(Arrays.asList(users));
    }

    public void removeCollaborators(Collection<GHUser> users) throws IOException {
        this.modifyCollaborators(users, "/remove/");
    }

    private void modifyCollaborators(Collection<GHUser> users, String op) throws IOException {
        this.verifyMine();
        for (GHUser user : users) {
            new Poster(this.root).withCredential().to("/repos/collaborators/" + this.name + op + user.getLogin());
        }
    }

    public void delete() throws IOException {
        Poster poster = new Poster(this.root).withCredential();
        String url = "/repos/delete/" + this.owner + "/" + this.name;
        DeleteToken token = poster.to(url, DeleteToken.class);
        poster.with("delete_token", token.delete_token).to(url);
    }

    public GHRepository fork() throws IOException {
        return new Poster(this.root).withCredential().to("/repos/fork/" + this.owner + "/" + this.name, JsonRepository.class).wrap(this.root);
    }

    private void verifyMine() throws IOException {
        if (!this.root.login.equals(this.owner)) {
            throw new IOException("Operation not applicable to a repository owned by someone else: " + this.owner);
        }
    }

    public Set<URL> getPostCommitHooks() {
        return this.postCommitHooks;
    }

    public String toString() {
        return "Repository:" + this.owner + ":" + this.name;
    }
}

