/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.JsonOrganization;
import org.kohsuke.github.JsonRepository;
import org.kohsuke.github.JsonUser;
import org.kohsuke.github.Poster;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitHub {
    final String login;
    final String encodedAuthorization;
    final String password;
    private final Map<String, GHUser> users = new HashMap<String, GHUser>();
    private final Map<String, GHOrganization> orgs = new HashMap<String, GHOrganization>();
    static final ObjectMapper MAPPER = new ObjectMapper();

    private GitHub(String login, String apiToken, String password) {
        this.login = login;
        this.password = password;
        BASE64Encoder enc = new BASE64Encoder();
        if (apiToken != null || password != null) {
            String userpassword = apiToken != null ? login + "/token" + ":" + apiToken : login + ':' + password;
            this.encodedAuthorization = enc.encode(userpassword.getBytes());
        } else {
            this.encodedAuthorization = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GitHub connect() throws IOException {
        Properties props = new Properties();
        File homeDir = new File(System.getProperty("user.home"));
        FileInputStream in = new FileInputStream(new File(homeDir, ".github"));
        try {
            props.load(in);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return new GitHub(props.getProperty("login"), props.getProperty("token"), props.getProperty("password"));
    }

    public static GitHub connect(String login, String apiToken) throws IOException {
        return new GitHub(login, apiToken, null);
    }

    public static GitHub connect(String login, String apiToken, String password) throws IOException {
        return new GitHub(login, apiToken, password);
    }

    public static GitHub connectAnonymously() {
        return new GitHub(null, null, null);
    }

    void requireCredential() {
        if (this.login == null || this.encodedAuthorization == null) {
            throw new IllegalStateException("This operation requires a credential but none is given to the GitHub constructor");
        }
    }

    URL getApiURL(String tailApiUrl) throws IOException {
        return new URL("http://github.com/api/v2/json" + tailApiUrl);
    }

    <T> T retrieve(String tailApiUrl, Class<T> type) throws IOException {
        return this._retrieve(tailApiUrl, type, "GET", false);
    }

    <T> T retrieveWithAuth(String tailApiUrl, Class<T> type) throws IOException {
        return this.retrieveWithAuth(tailApiUrl, type, "GET");
    }

    <T> T retrieveWithAuth(String tailApiUrl, Class<T> type, String method) throws IOException {
        return this._retrieve(tailApiUrl, type, method, true);
    }

    private <T> T _retrieve(String tailApiUrl, Class<T> type, String method, boolean withAuth) throws IOException {
        while (true) {
            HttpURLConnection uc = (HttpURLConnection)this.getApiURL(tailApiUrl).openConnection();
            if (withAuth) {
                uc.setRequestProperty("Authorization", "Basic " + this.encodedAuthorization);
            }
            uc.setRequestMethod(method);
            try {
                InputStreamReader r = new InputStreamReader(uc.getInputStream(), "UTF-8");
                if (type == null) {
                    String data = IOUtils.toString((Reader)r);
                    return null;
                }
                return (T)MAPPER.readValue((Reader)r, type);
            }
            catch (IOException e) {
                this.handleApiError(e, uc);
                continue;
            }
            break;
        }
    }

    void handleApiError(IOException e, HttpURLConnection uc) throws IOException {
        if ("0".equals(uc.getHeaderField("X-RateLimit-Remaining"))) {
            try {
                Thread.sleep(10000L);
                return;
            }
            catch (InterruptedException _) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
        }
        throw (IOException)new IOException(IOUtils.toString((InputStream)uc.getErrorStream(), (String)"UTF-8")).initCause(e);
    }

    public GHUser getUser(String login) throws IOException {
        GHUser u = this.users.get(login);
        if (u == null) {
            u = this.retrieve((String)new StringBuilder().append((String)"/user/show/").append((String)login).toString(), JsonUser.class).user;
            u.root = this;
            this.users.put(login, u);
        }
        return u;
    }

    protected GHUser getUser(GHUser orig) throws IOException {
        GHUser u = this.users.get(orig.getLogin());
        if (u == null) {
            orig.root = this;
            this.users.put(this.login, orig);
            return orig;
        }
        return u;
    }

    public GHOrganization getOrganization(String name) throws IOException {
        GHOrganization o = this.orgs.get(name);
        if (o == null) {
            o = this.retrieve((String)new StringBuilder().append((String)"/organizations/").append((String)name).toString(), JsonOrganization.class).organization;
            o.root = this;
            this.orgs.put(name, o);
        }
        return o;
    }

    public GHUser getMyself() throws IOException {
        this.requireCredential();
        return this.getUser(this.login);
    }

    public GHRepository createRepository(String name, String description, String homepage, boolean isPublic) throws IOException {
        return new Poster(this).withCredential().with("name", name).with("description", description).with("homepage", homepage).with("public", isPublic ? 1 : 0).to("/repos/create", JsonRepository.class).wrap(this);
    }

    public boolean isCredentialValid() throws IOException {
        try {
            this.retrieveWithAuth("/user/show", JsonUser.class);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    WebClient createWebClient() throws IOException {
        WebClient wc = new WebClient();
        wc.setJavaScriptEnabled(false);
        wc.setCssEnabled(false);
        HtmlPage pg = (HtmlPage)wc.getPage("https://github.com/login");
        HtmlForm f = (HtmlForm)pg.getForms().get(0);
        f.getInputByName("login").setValueAttribute(this.login);
        f.getInputByName("password").setValueAttribute(this.password);
        f.submit();
        return wc;
    }

    static {
        MAPPER.setVisibilityChecker((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        MAPPER.getDeserializationConfig().set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

