/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GitHub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Requester {
    private final GitHub root;
    private final List<Entry> args = new ArrayList<Entry>();
    private String method = "POST";
    private String contentType = "application/x-www-form-urlencoded";
    private InputStream body;

    Requester(GitHub root) {
        this.root = root;
    }

    @Deprecated
    public Requester withCredential() {
        return this;
    }

    public Requester with(String key, int value) {
        return this._with(key, value);
    }

    public Requester with(String key, Integer value) {
        if (value != null) {
            this._with(key, (int)value);
        }
        return this;
    }

    public Requester with(String key, boolean value) {
        return this._with(key, value);
    }

    public Requester with(String key, String value) {
        return this._with(key, value);
    }

    public Requester with(String key, Collection<String> value) {
        return this._with(key, value);
    }

    public Requester with(String key, Map<String, String> value) {
        return this._with(key, value);
    }

    public Requester with(InputStream body) {
        this.body = body;
        return this;
    }

    public Requester _with(String key, Object value) {
        if (value != null) {
            this.args.add(new Entry(key, value));
        }
        return this;
    }

    public Requester method(String method) {
        this.method = method;
        return this;
    }

    public Requester contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public void to(String tailApiUrl) throws IOException {
        this.to(tailApiUrl, (Object)null);
    }

    public <T> T to(String tailApiUrl, Class<T> type) throws IOException {
        return this._to(tailApiUrl, type, null);
    }

    public <T> T to(String tailApiUrl, T existingInstance) throws IOException {
        return this._to(tailApiUrl, null, existingInstance);
    }

    @Deprecated
    public <T> T to(String tailApiUrl, Class<T> type, String method) throws IOException {
        return (T)this.method(method).to(tailApiUrl, (T)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T _to(String tailApiUrl, Class<T> type, T instance) throws IOException {
        while (true) {
            HttpURLConnection uc = this.setupConnection(this.root.getApiURL(tailApiUrl));
            if (!this.method.equals("GET")) {
                uc.setDoOutput(true);
                uc.setRequestProperty("Content-type", this.contentType);
                if (this.body == null) {
                    HashMap<String, Object> json = new HashMap<String, Object>();
                    for (Entry e : this.args) {
                        json.put(e.key, e.value);
                    }
                    GitHub.MAPPER.writeValue(uc.getOutputStream(), json);
                } else {
                    try {
                        byte[] bytes = new byte[32768];
                        int read = 0;
                        while ((read = this.body.read(bytes)) != -1) {
                            uc.getOutputStream().write(bytes, 0, read);
                        }
                    }
                    finally {
                        this.body.close();
                    }
                }
            }
            try {
                return this.parse(uc, type, instance);
            }
            catch (IOException e) {
                this.handleApiError(e, uc);
                continue;
            }
            break;
        }
    }

    <T> Iterator<T> asIterator(final String tailApiUrl, final Class<T> type) {
        this.method("GET");
        if (!this.args.isEmpty()) {
            throw new IllegalStateException();
        }
        return new Iterator<T>(){
            T next;
            URL url;
            {
                try {
                    this.url = Requester.this.root.getApiURL(tailApiUrl);
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }

            @Override
            public boolean hasNext() {
                this.fetch();
                return this.next != null;
            }

            @Override
            public T next() {
                this.fetch();
                Object r = this.next;
                if (r == null) {
                    throw new NoSuchElementException();
                }
                this.next = null;
                return r;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void fetch() {
                if (this.next != null) {
                    return;
                }
                if (this.url == null) {
                    return;
                }
                try {
                    while (true) {
                        HttpURLConnection uc = Requester.this.setupConnection(this.url);
                        try {
                            this.next = Requester.this.parse(uc, type, null);
                            assert (this.next != null);
                            this.findNextURL(uc);
                            return;
                        }
                        catch (IOException e) {
                            Requester.this.handleApiError(e, uc);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }

            private void findNextURL(HttpURLConnection uc) throws MalformedURLException {
                this.url = null;
                String link = uc.getHeaderField("Link");
                if (link == null) {
                    return;
                }
                for (String token : link.split(", ")) {
                    if (!token.endsWith("rel=\"next\"")) continue;
                    int idx = token.indexOf(62);
                    this.url = new URL(token.substring(1, idx));
                    return;
                }
            }
        };
    }

    private HttpURLConnection setupConnection(URL url) throws IOException {
        HttpURLConnection uc = this.root.getConnector().connect(url);
        if (this.root.encodedAuthorization != null) {
            uc.setRequestProperty("Authorization", this.root.encodedAuthorization);
        }
        try {
            uc.setRequestMethod(this.method);
        }
        catch (ProtocolException e) {
            try {
                Field $method = HttpURLConnection.class.getDeclaredField("method");
                $method.setAccessible(true);
                $method.set(uc, this.method);
            }
            catch (Exception x) {
                throw (IOException)new IOException("Failed to set the custom verb").initCause(x);
            }
        }
        uc.setRequestProperty("Accept-Encoding", "gzip");
        return uc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T parse(HttpURLConnection uc, Class<T> type, T instance) throws IOException {
        InputStreamReader r;
        block5: {
            String data;
            block4: {
                Object object;
                r = null;
                try {
                    r = new InputStreamReader(this.wrapStream(uc, uc.getInputStream()), "UTF-8");
                    data = IOUtils.toString((Reader)r);
                    if (type == null) break block4;
                    object = GitHub.MAPPER.readValue(data, type);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(r);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)r);
                return (T)object;
            }
            if (instance == null) break block5;
            Object object = GitHub.MAPPER.readerForUpdating(instance).readValue(data);
            IOUtils.closeQuietly((Reader)r);
            return (T)object;
        }
        T t = null;
        IOUtils.closeQuietly((Reader)r);
        return t;
    }

    private InputStream wrapStream(HttpURLConnection uc, InputStream in) throws IOException {
        String encoding = uc.getContentEncoding();
        if (encoding == null || in == null) {
            return in;
        }
        if (encoding.equals("gzip")) {
            return new GZIPInputStream(in);
        }
        throw new UnsupportedOperationException("Unexpected Content-Encoding: " + encoding);
    }

    void handleApiError(IOException e, HttpURLConnection uc) throws IOException {
        if ("0".equals(uc.getHeaderField("X-RateLimit-Remaining"))) {
            try {
                Thread.sleep(10000L);
                return;
            }
            catch (InterruptedException _) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
        }
        if (e instanceof FileNotFoundException) {
            throw e;
        }
        InputStream es = this.wrapStream(uc, uc.getErrorStream());
        try {
            if (es != null) {
                throw (IOException)new IOException(IOUtils.toString((InputStream)es, (String)"UTF-8")).initCause(e);
            }
            throw e;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)es);
            throw throwable;
        }
    }

    private Set<String> toSet(String s) {
        HashSet<String> r = new HashSet<String>();
        for (String t : s.split(",")) {
            r.add(t.trim());
        }
        return r;
    }

    private static class Entry {
        String key;
        Object value;

        private Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

