/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import org.kohsuke.github.GHMilestoneState;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

public class GHMilestone {
    GitHub root;
    GHRepository owner;
    GHUser creator;
    private String state;
    private String due_on;
    private String title;
    private String url;
    private String created_at;
    private String description;
    private int closed_issues;
    private int open_issues;
    private int number;

    public GitHub getRoot() {
        return this.root;
    }

    public GHRepository getOwner() {
        return this.owner;
    }

    public GHUser getCreator() {
        return this.creator;
    }

    public Date getDueOn() {
        if (this.due_on == null) {
            return null;
        }
        return GitHub.parseDate(this.due_on);
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public Date getCreatedAt() {
        return GitHub.parseDate(this.created_at);
    }

    public String getDescription() {
        return this.description;
    }

    public int getClosedIssues() {
        return this.closed_issues;
    }

    public int getOpenIssues() {
        return this.open_issues;
    }

    public int getNumber() {
        return this.number;
    }

    public GHMilestoneState getState() {
        return Enum.valueOf(GHMilestoneState.class, this.state.toUpperCase(Locale.ENGLISH));
    }

    public void close() throws IOException {
        this.edit("state", "closed");
    }

    private void edit(String key, Object value) throws IOException {
        new Requester(this.root)._with(key, value).method("PATCH").to(this.getApiRoute());
    }

    protected String getApiRoute() {
        return "/repos/" + this.owner.getOwnerName() + "/" + this.owner.getName() + "/milestones/" + this.number;
    }

    public GHMilestone wrap(GHRepository repo) {
        this.owner = repo;
        this.root = repo.root;
        return this;
    }
}

