/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.List;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitUser;

public abstract class GHEventPayload {
    protected GitHub root;

    GHEventPayload() {
    }

    void wrapUp(GitHub root) {
        this.root = root;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Push
    extends GHEventPayload {
        private String head;
        private String before;
        private String ref;
        private int size;
        private List<PushCommit> commits;
        private GHRepository repository;

        public String getHead() {
            return this.head;
        }

        public String getBefore() {
            return this.before;
        }

        public String getRef() {
            return this.ref;
        }

        public int getSize() {
            return this.size;
        }

        public List<PushCommit> getCommits() {
            return this.commits;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        @Override
        void wrapUp(GitHub root) {
            if (this.repository != null) {
                this.repository.wrap(root);
            }
        }

        public static class PushCommit {
            private GitUser author;
            private String url;
            private String sha;
            private String message;
            private boolean distinct;

            public GitUser getAuthor() {
                return this.author;
            }

            public String getUrl() {
                return this.url;
            }

            public String getSha() {
                return this.sha;
            }

            public String getMessage() {
                return this.message;
            }

            public boolean isDistinct() {
                return this.distinct;
            }
        }
    }

    public static class IssueComment
    extends GHEventPayload {
        private String action;
        private GHIssueComment comment;
        private GHIssue issue;
        private GHRepository repository;

        public String getAction() {
            return this.action;
        }

        public GHIssueComment getComment() {
            return this.comment;
        }

        public void setComment(GHIssueComment comment) {
            this.comment = comment;
        }

        public GHIssue getIssue() {
            return this.issue;
        }

        public void setIssue(GHIssue issue) {
            this.issue = issue;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        public void setRepository(GHRepository repository) {
            this.repository = repository;
        }

        void wrapUp(GitHub root) {
            super.wrapUp(root);
            this.repository.wrap(root);
            this.issue.wrap(this.repository);
            this.comment.wrapUp(this.issue);
        }
    }

    public static class PullRequest
    extends GHEventPayload {
        private String action;
        private int number;
        private GHPullRequest pull_request;
        private GHRepository repository;

        public String getAction() {
            return this.action;
        }

        public int getNumber() {
            return this.number;
        }

        public GHPullRequest getPullRequest() {
            this.pull_request.root = this.root;
            return this.pull_request;
        }

        public GHRepository getRepository() {
            return this.repository;
        }

        void wrapUp(GitHub root) {
            super.wrapUp(root);
            if (this.pull_request == null) {
                throw new IllegalStateException("Expected pull_request payload, but got something else. Maybe we've got another type of event?");
            }
            if (this.repository != null) {
                this.repository.wrap(root);
                this.pull_request.wrap(this.repository);
            } else {
                this.pull_request.wrapUp(root);
            }
        }
    }
}

