/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GHContentUpdateResponse;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHContent {
    private GHRepository repository;
    private GitHub root;
    private String type;
    private String encoding;
    private long size;
    private String sha;
    private String name;
    private String path;
    private String content;
    private String url;
    private String git_url;
    private String html_url;
    private String download_url;

    public GHRepository getOwner() {
        return this.repository;
    }

    public String getType() {
        return this.type;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public long getSize() {
        return this.size;
    }

    public String getSha() {
        return this.sha;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getContent() throws IOException {
        return new String(DatatypeConverter.parseBase64Binary((String)this.getEncodedContent()));
    }

    public String getEncodedContent() throws IOException {
        if (this.content != null) {
            return this.content;
        }
        return Base64.encodeBase64String((byte[])IOUtils.toByteArray((InputStream)this.read()));
    }

    public String getUrl() {
        return this.url;
    }

    public String getGitUrl() {
        return this.git_url;
    }

    public String getHtmlUrl() {
        return this.html_url;
    }

    public InputStream read() throws IOException {
        return new Requester(this.root).asStream(this.getDownloadUrl());
    }

    public String getDownloadUrl() throws IOException {
        this.populate();
        return this.download_url;
    }

    public boolean isFile() {
        return "file".equals(this.type);
    }

    public boolean isDirectory() {
        return "dir".equals(this.type);
    }

    protected synchronized void populate() throws IOException {
        if (this.download_url != null) {
            return;
        }
        this.root.retrieve().to(this.url, this);
    }

    public PagedIterable<GHContent> listDirectoryContent() throws IOException {
        if (!this.isDirectory()) {
            throw new IllegalStateException(this.path + " is not a directory");
        }
        return new PagedIterable<GHContent>(){

            @Override
            public PagedIterator<GHContent> iterator() {
                return new PagedIterator<GHContent>(GHContent.this.root.retrieve().asIterator(GHContent.this.url, GHContent[].class)){

                    protected void wrapUp(GHContent[] page) {
                        GHContent.wrap(page, GHContent.this.repository);
                    }
                };
            }
        };
    }

    public GHContentUpdateResponse update(String newContent, String commitMessage) throws IOException {
        return this.update(newContent.getBytes(), commitMessage, null);
    }

    public GHContentUpdateResponse update(String newContent, String commitMessage, String branch) throws IOException {
        return this.update(newContent.getBytes(), commitMessage, branch);
    }

    public GHContentUpdateResponse update(byte[] newContentBytes, String commitMessage) throws IOException {
        return this.update(newContentBytes, commitMessage, null);
    }

    public GHContentUpdateResponse update(byte[] newContentBytes, String commitMessage, String branch) throws IOException {
        String encodedContent = DatatypeConverter.printBase64Binary((byte[])newContentBytes);
        Requester requester = new Requester(this.root).with("path", this.path).with("message", commitMessage).with("sha", this.sha).with("content", encodedContent).method("PUT");
        if (branch != null) {
            requester.with("branch", branch);
        }
        GHContentUpdateResponse response = (GHContentUpdateResponse)((Object)requester.to(this.getApiRoute(), GHContentUpdateResponse.class));
        response.getContent().wrap(this.repository);
        response.getCommit().wrapUp(this.repository);
        this.content = encodedContent;
        return response;
    }

    public GHContentUpdateResponse delete(String message) throws IOException {
        return this.delete(message, null);
    }

    public GHContentUpdateResponse delete(String commitMessage, String branch) throws IOException {
        Requester requester = new Requester(this.root).with("path", this.path).with("message", commitMessage).with("sha", this.sha).method("DELETE");
        if (branch != null) {
            requester.with("branch", branch);
        }
        GHContentUpdateResponse response = (GHContentUpdateResponse)((Object)requester.to(this.getApiRoute(), GHContentUpdateResponse.class));
        response.getCommit().wrapUp(this.repository);
        return response;
    }

    private String getApiRoute() {
        return "/repos/" + this.repository.getOwnerName() + "/" + this.repository.getName() + "/contents/" + this.path;
    }

    GHContent wrap(GHRepository owner) {
        this.repository = owner;
        this.root = owner.root;
        return this;
    }

    GHContent wrap(GitHub root) {
        this.root = root;
        if (this.repository != null) {
            this.repository.wrap(root);
        }
        return this;
    }

    public static GHContent[] wrap(GHContent[] contents, GHRepository repository) {
        for (GHContent unwrappedContent : contents) {
            unwrappedContent.wrap(repository);
        }
        return contents;
    }
}

