/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHSubscription;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.Requester;

public class GHThread
extends GHObject {
    private GitHub root;
    private GHRepository repository;
    private Subject subject;
    private String reason;
    private boolean unread;
    private String last_read_at;
    private String url;
    private String subscription_url;

    private GHThread() {
    }

    public Date getLastReadAt() {
        return GitHub.parseDate(this.last_read_at);
    }

    public URL getHtmlUrl() {
        return null;
    }

    public String getReason() {
        return this.reason;
    }

    public GHRepository getRepository() {
        return this.repository;
    }

    public boolean isRead() {
        return !this.unread;
    }

    public String getTitle() {
        return this.subject.title;
    }

    public String getType() {
        return this.subject.type;
    }

    public GHIssue getBoundIssue() throws IOException {
        if (!"Issue".equals(this.subject.type) && "PullRequest".equals(this.subject.type)) {
            return null;
        }
        return this.repository.getIssue(Integer.parseInt(this.subject.url.substring(this.subject.url.lastIndexOf(47) + 1)));
    }

    public GHPullRequest getBoundPullRequest() throws IOException {
        if (!"PullRequest".equals(this.subject.type)) {
            return null;
        }
        return this.repository.getPullRequest(Integer.parseInt(this.subject.url.substring(this.subject.url.lastIndexOf(47) + 1)));
    }

    public GHCommit getBoundCommit() throws IOException {
        if (!"Commit".equals(this.subject.type)) {
            return null;
        }
        return this.repository.getCommit(this.subject.url.substring(this.subject.url.lastIndexOf(47) + 1));
    }

    GHThread wrap(GitHub root) {
        this.root = root;
        if (this.repository != null) {
            this.repository.wrap(root);
        }
        return this;
    }

    public void markAsRead() throws IOException {
        new Requester(this.root).method("PATCH").to(this.url);
    }

    public GHSubscription subscribe(boolean subscribed, boolean ignored) throws IOException {
        return ((GHSubscription)((Object)new Requester(this.root).with("subscribed", subscribed).with("ignored", ignored).method("PUT").to(this.subscription_url, GHSubscription.class))).wrapUp(this.root);
    }

    public GHSubscription getSubscription() throws IOException {
        try {
            return ((GHSubscription)((Object)new Requester(this.root).to(this.subscription_url, GHSubscription.class))).wrapUp(this.root);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    static class Subject {
        String title;
        String url;
        String latest_comment_url;
        String type;

        Subject() {
        }
    }
}

