/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.util.Locale;
import org.kohsuke.github.GHSearchBuilder;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHUserSearchBuilder
extends GHSearchBuilder<GHUser> {
    GHUserSearchBuilder(GitHub root) {
        super(root, UserSearchResult.class);
    }

    @Override
    public GHUserSearchBuilder q(String term) {
        super.q(term);
        return this;
    }

    public GHUserSearchBuilder type(String v) {
        return this.q("type:" + v);
    }

    public GHUserSearchBuilder in(String v) {
        return this.q("in:" + v);
    }

    public GHUserSearchBuilder repos(String v) {
        return this.q("repos:" + v);
    }

    public GHUserSearchBuilder location(String v) {
        return this.q("location:" + v);
    }

    public GHUserSearchBuilder language(String v) {
        return this.q("language:" + v);
    }

    public GHUserSearchBuilder created(String v) {
        return this.q("created:" + v);
    }

    public GHUserSearchBuilder followers(String v) {
        return this.q("followers:" + v);
    }

    public GHUserSearchBuilder sort(Sort sort) {
        this.req.with("sort", sort.toString().toLowerCase(Locale.ENGLISH));
        return this;
    }

    @Override
    protected String getApiUrl() {
        return "/search/users";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UserSearchResult
    extends SearchResult<GHUser> {
        private GHUser[] items;

        private UserSearchResult() {
        }

        GHUser[] getItems(GitHub root) {
            return GHUser.wrap(this.items, root);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sort {
        FOLLOWERS,
        REPOSITORIES,
        JOINED;

    }
}

