/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHCommitComment;
import org.kohsuke.github.GHCommitQueryBuilder;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHCommitStatus;
import org.kohsuke.github.GHCompare;
import org.kohsuke.github.GHContent;
import org.kohsuke.github.GHContentUpdateResponse;
import org.kohsuke.github.GHDeployKey;
import org.kohsuke.github.GHDeployment;
import org.kohsuke.github.GHDeploymentBuilder;
import org.kohsuke.github.GHDeploymentState;
import org.kohsuke.github.GHDeploymentStatus;
import org.kohsuke.github.GHDeploymentStatusBuilder;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHHook;
import org.kohsuke.github.GHHooks;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueBuilder;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHNotificationStream;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPersonSet;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestQueryBuilder;
import org.kohsuke.github.GHRef;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHReleaseBuilder;
import org.kohsuke.github.GHSubscription;
import org.kohsuke.github.GHTag;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.MarkdownMode;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
@BridgeMethodsAdded
public class GHRepository
extends GHObject {
    GitHub root;
    private String description;
    private String homepage;
    private String name;
    private String full_name;
    private String html_url;
    private String git_url;
    private String ssh_url;
    private String clone_url;
    private String svn_url;
    private String mirror_url;
    private GHUser owner;
    private boolean has_issues;
    private boolean has_wiki;
    private boolean fork;
    private boolean has_downloads;
    @JsonProperty(value="private")
    private boolean _private;
    private int watchers;
    private int forks;
    private int open_issues;
    private int size;
    private int network_count;
    private int subscribers_count;
    private String pushed_at;
    private Map<Integer, GHMilestone> milestones = new HashMap<Integer, GHMilestone>();
    private String default_branch;
    private String language;
    private Map<String, GHCommit> commits = new HashMap<String, GHCommit>();
    private GHRepoPermission permissions;
    private GHRepository source;
    private GHRepository parent;
    @SuppressFBWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="It causes a performance degradation, but we have already exposed it to the API")
    private final Set<URL> postCommitHooks = new AbstractSet<URL>(){

        private List<URL> getPostCommitHooks() {
            try {
                ArrayList<URL> r = new ArrayList<URL>();
                for (GHHook h : GHRepository.this.getHooks()) {
                    if (!h.getName().equals("web")) continue;
                    r.add(new URL(h.getConfig().get("url")));
                }
                return r;
            }
            catch (IOException e) {
                throw new GHException("Failed to retrieve post-commit hooks", e);
            }
        }

        @Override
        public Iterator<URL> iterator() {
            return this.getPostCommitHooks().iterator();
        }

        @Override
        public int size() {
            return this.getPostCommitHooks().size();
        }

        @Override
        public boolean add(URL url) {
            try {
                GHRepository.this.createWebHook(url);
                return true;
            }
            catch (IOException e) {
                throw new GHException("Failed to update post-commit hooks", e);
            }
        }

        @Override
        public boolean remove(Object url) {
            try {
                String _url = ((URL)url).toExternalForm();
                for (GHHook h : GHRepository.this.getHooks()) {
                    if (!h.getName().equals("web") || !h.getConfig().get("url").equals(_url)) continue;
                    h.delete();
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                throw new GHException("Failed to update post-commit hooks", e);
            }
        }
    };

    public GHDeploymentBuilder createDeployment(String ref) {
        return new GHDeploymentBuilder(this, ref);
    }

    public PagedIterable<GHDeploymentStatus> getDeploymentStatuses(final int id) {
        return new PagedIterable<GHDeploymentStatus>(){

            @Override
            public PagedIterator<GHDeploymentStatus> _iterator(int pageSize) {
                return new PagedIterator<GHDeploymentStatus>(GHRepository.this.root.retrieve().asIterator(GHRepository.this.getApiTailUrl("deployments") + "/" + id + "/statuses", GHDeploymentStatus[].class, pageSize)){

                    protected void wrapUp(GHDeploymentStatus[] page) {
                        for (GHDeploymentStatus c : page) {
                            c.wrap(GHRepository.this);
                        }
                    }
                };
            }
        };
    }

    public PagedIterable<GHDeployment> listDeployments(String sha, String ref, String task, String environment) {
        List<String> params = Arrays.asList(this.getParam("sha", sha), this.getParam("ref", ref), this.getParam("task", task), this.getParam("environment", environment));
        final String deploymentsUrl = this.getApiTailUrl("deployments") + "?" + this.join(params, "&");
        return new PagedIterable<GHDeployment>(){

            @Override
            public PagedIterator<GHDeployment> _iterator(int pageSize) {
                return new PagedIterator<GHDeployment>(GHRepository.this.root.retrieve().asIterator(deploymentsUrl, GHDeployment[].class, pageSize)){

                    protected void wrapUp(GHDeployment[] page) {
                        for (GHDeployment c : page) {
                            c.wrap(GHRepository.this);
                        }
                    }
                };
            }
        };
    }

    private String join(List<String> params, String joinStr) {
        StringBuilder output = new StringBuilder();
        for (String param : params) {
            if (param == null) continue;
            output.append(param + joinStr);
        }
        return output.toString();
    }

    private String getParam(String name, String value) {
        return StringUtils.trimToNull((String)value) == null ? null : name + "=" + value;
    }

    public GHDeploymentStatusBuilder createDeployStatus(int deploymentId, GHDeploymentState ghDeploymentState) {
        return new GHDeploymentStatusBuilder(this, deploymentId, ghDeploymentState);
    }

    public String getDescription() {
        return this.description;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public String getGitTransportUrl() {
        return this.git_url;
    }

    public String gitHttpTransportUrl() {
        return this.clone_url;
    }

    public String getSvnUrl() {
        return this.svn_url;
    }

    public String getMirrorUrl() {
        return this.mirror_url;
    }

    public String getSshUrl() {
        return this.ssh_url;
    }

    @Override
    public URL getHtmlUrl() {
        return GitHub.parseURL(this.html_url);
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.full_name;
    }

    public boolean hasPullAccess() {
        return this.permissions != null && this.permissions.pull;
    }

    public boolean hasPushAccess() {
        return this.permissions != null && this.permissions.push;
    }

    public boolean hasAdminAccess() {
        return this.permissions != null && this.permissions.admin;
    }

    public String getLanguage() {
        return this.language;
    }

    public GHUser getOwner() throws IOException {
        return this.root.getUser(this.owner.login);
    }

    public GHIssue getIssue(int id) throws IOException {
        return ((GHIssue)((Object)this.root.retrieve().to(this.getApiTailUrl("issues/" + id), GHIssue.class))).wrap(this);
    }

    public GHIssueBuilder createIssue(String title) {
        return new GHIssueBuilder(this, title);
    }

    public List<GHIssue> getIssues(GHIssueState state) throws IOException {
        return this.listIssues(state).asList();
    }

    public List<GHIssue> getIssues(GHIssueState state, GHMilestone milestone) throws IOException {
        return Arrays.asList(GHIssue.wrap((GHIssue[])this.root.retrieve().with("state", state).with("milestone", milestone == null ? "none" : "" + milestone.getNumber()).to(this.getApiTailUrl("issues"), GHIssue[].class), this));
    }

    public PagedIterable<GHIssue> listIssues(final GHIssueState state) {
        return new PagedIterable<GHIssue>(){

            @Override
            public PagedIterator<GHIssue> _iterator(int pageSize) {
                return new PagedIterator<GHIssue>(GHRepository.this.root.retrieve().with("state", state).asIterator(GHRepository.this.getApiTailUrl("issues"), GHIssue[].class, pageSize)){

                    protected void wrapUp(GHIssue[] page) {
                        for (GHIssue c : page) {
                            c.wrap(GHRepository.this);
                        }
                    }
                };
            }
        };
    }

    public GHReleaseBuilder createRelease(String tag) {
        return new GHReleaseBuilder(this, tag);
    }

    public GHRef createRef(String name, String sha) throws IOException {
        return ((GHRef)((Object)new Requester(this.root).with("ref", name).with("sha", sha).method("POST").to(this.getApiTailUrl("git/refs"), GHRef.class))).wrap(this.root);
    }

    public List<GHRelease> getReleases() throws IOException {
        return this.listReleases().asList();
    }

    public PagedIterable<GHRelease> listReleases() throws IOException {
        return new PagedIterable<GHRelease>(){

            @Override
            public PagedIterator<GHRelease> _iterator(int pageSize) {
                return new PagedIterator<GHRelease>(GHRepository.this.root.retrieve().asIterator(GHRepository.this.getApiTailUrl("releases"), GHRelease[].class, pageSize)){

                    protected void wrapUp(GHRelease[] page) {
                        for (GHRelease c : page) {
                            c.wrap(GHRepository.this);
                        }
                    }
                };
            }
        };
    }

    public PagedIterable<GHTag> listTags() throws IOException {
        return new PagedIterable<GHTag>(){

            @Override
            public PagedIterator<GHTag> _iterator(int pageSize) {
                return new PagedIterator<GHTag>(GHRepository.this.root.retrieve().asIterator(GHRepository.this.getApiTailUrl("tags"), GHTag[].class, pageSize)){

                    protected void wrapUp(GHTag[] page) {
                        for (GHTag c : page) {
                            c.wrap(GHRepository.this);
                        }
                    }
                };
            }
        };
    }

    public Map<String, Long> listLanguages() throws IOException {
        return (Map)((Object)this.root.retrieve().to(this.getApiTailUrl("languages"), HashMap.class));
    }

    public String getOwnerName() {
        return this.owner.login;
    }

    public boolean hasIssues() {
        return this.has_issues;
    }

    public boolean hasWiki() {
        return this.has_wiki;
    }

    public boolean isFork() {
        return this.fork;
    }

    public int getForks() {
        return this.forks;
    }

    public boolean isPrivate() {
        return this._private;
    }

    public boolean hasDownloads() {
        return this.has_downloads;
    }

    public int getWatchers() {
        return this.watchers;
    }

    public int getOpenIssueCount() {
        return this.open_issues;
    }

    public int getNetworkCount() {
        return this.network_count;
    }

    public int getSubscribersCount() {
        return this.subscribers_count;
    }

    public Date getPushedAt() {
        return GitHub.parseDate(this.pushed_at);
    }

    public String getDefaultBranch() {
        return this.default_branch;
    }

    public String getMasterBranch() {
        return this.default_branch;
    }

    public int getSize() {
        return this.size;
    }

    @WithBridgeMethods(value={Set.class})
    public GHPersonSet<GHUser> getCollaborators() throws IOException {
        return new GHPersonSet<GHUser>((Collection<GHUser>)this.listCollaborators().asList());
    }

    public PagedIterable<GHUser> listCollaborators() throws IOException {
        return new PagedIterable<GHUser>(){

            @Override
            public PagedIterator<GHUser> _iterator(int pageSize) {
                return new PagedIterator<GHUser>(GHRepository.this.root.retrieve().asIterator(GHRepository.this.getApiTailUrl("collaborators"), GHUser[].class, pageSize)){

                    protected void wrapUp(GHUser[] users) {
                        for (GHUser user : users) {
                            user.wrapUp(GHRepository.this.root);
                        }
                    }
                };
            }
        };
    }

    public Set<String> getCollaboratorNames() throws IOException {
        HashSet<String> r = new HashSet<String>();
        for (GHUser u : GHUser.wrap((GHUser[])this.root.retrieve().to(this.getApiTailUrl("collaborators"), GHUser[].class), this.root)) {
            r.add(u.login);
        }
        return r;
    }

    public Set<GHTeam> getTeams() throws IOException {
        return Collections.unmodifiableSet(new HashSet<GHTeam>(Arrays.asList(GHTeam.wrapUp((GHTeam[])this.root.retrieve().to(this.getApiTailUrl("teams"), GHTeam[].class), this.root.getOrganization(this.owner.login)))));
    }

    public void addCollaborators(GHUser ... users) throws IOException {
        this.addCollaborators(Arrays.asList(users));
    }

    public void addCollaborators(Collection<GHUser> users) throws IOException {
        this.modifyCollaborators(users, "PUT");
    }

    public void removeCollaborators(GHUser ... users) throws IOException {
        this.removeCollaborators(Arrays.asList(users));
    }

    public void removeCollaborators(Collection<GHUser> users) throws IOException {
        this.modifyCollaborators(users, "DELETE");
    }

    private void modifyCollaborators(Collection<GHUser> users, String method) throws IOException {
        this.verifyMine();
        for (GHUser user : users) {
            new Requester(this.root).method(method).to(this.getApiTailUrl("collaborators/" + user.getLogin()));
        }
    }

    public void setEmailServiceHook(String address) throws IOException {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("address", address);
        new Requester(this.root).method("POST").with("name", "email").with("config", config).with("active", true).to(this.getApiTailUrl("hooks"));
    }

    private void edit(String key, String value) throws IOException {
        Requester requester = new Requester(this.root);
        if (!key.equals("name")) {
            requester.with("name", this.name);
        }
        requester.with(key, value).method("PATCH").to(this.getApiTailUrl(""));
    }

    public void enableIssueTracker(boolean v) throws IOException {
        this.edit("has_issues", String.valueOf(v));
    }

    public void enableWiki(boolean v) throws IOException {
        this.edit("has_wiki", String.valueOf(v));
    }

    public void enableDownloads(boolean v) throws IOException {
        this.edit("has_downloads", String.valueOf(v));
    }

    public void renameTo(String name) throws IOException {
        this.edit("name", name);
    }

    public void setDescription(String value) throws IOException {
        this.edit("description", value);
    }

    public void setHomepage(String value) throws IOException {
        this.edit("homepage", value);
    }

    public void setDefaultBranch(String value) throws IOException {
        this.edit("default_branch", value);
    }

    public void delete() throws IOException {
        try {
            new Requester(this.root).method("DELETE").to(this.getApiTailUrl(""));
        }
        catch (FileNotFoundException x) {
            throw (FileNotFoundException)new FileNotFoundException("Failed to delete " + this.owner.login + "/" + this.name + "; might not exist, or you might need the delete_repo scope in your token: http://stackoverflow.com/a/19327004/12916").initCause(x);
        }
    }

    public PagedIterable<GHRepository> listForks() {
        return this.listForks(null);
    }

    public PagedIterable<GHRepository> listForks(final ForkSort sort) {
        return new PagedIterable<GHRepository>(){

            @Override
            public PagedIterator<GHRepository> _iterator(int pageSize) {
                return new PagedIterator<GHRepository>(GHRepository.this.root.retrieve().with("sort", sort).asIterator(GHRepository.this.getApiTailUrl("forks"), GHRepository[].class, pageSize)){

                    protected void wrapUp(GHRepository[] page) {
                        for (GHRepository c : page) {
                            c.wrap(GHRepository.this.root);
                        }
                    }
                };
            }
        };
    }

    public GHRepository fork() throws IOException {
        return ((GHRepository)((Object)new Requester(this.root).method("POST").to(this.getApiTailUrl("forks"), GHRepository.class))).wrap(this.root);
    }

    public GHRepository forkTo(GHOrganization org) throws IOException {
        new Requester(this.root).to(this.getApiTailUrl("forks?org=" + org.getLogin()));
        for (int i = 0; i < 10; ++i) {
            GHRepository r = org.getRepository(this.name);
            if (r != null) {
                return r;
            }
            try {
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException e) {
                throw (IOException)new InterruptedIOException().initCause(e);
            }
        }
        throw new IOException(this + " was forked into " + org.getLogin() + " but can't find the new repository");
    }

    public GHPullRequest getPullRequest(int i) throws IOException {
        return ((GHPullRequest)((Object)this.root.retrieve().to(this.getApiTailUrl("pulls/" + i), GHPullRequest.class))).wrapUp(this);
    }

    public List<GHPullRequest> getPullRequests(GHIssueState state) throws IOException {
        return this.queryPullRequests().state(state).list().asList();
    }

    public PagedIterable<GHPullRequest> listPullRequests(GHIssueState state) {
        return this.queryPullRequests().state(state).list();
    }

    public GHPullRequestQueryBuilder queryPullRequests() {
        return new GHPullRequestQueryBuilder(this);
    }

    public GHPullRequest createPullRequest(String title, String head, String base, String body) throws IOException {
        return ((GHPullRequest)((Object)new Requester(this.root).with("title", title).with("head", head).with("base", base).with("body", body).to(this.getApiTailUrl("pulls"), GHPullRequest.class))).wrapUp(this);
    }

    public List<GHHook> getHooks() throws IOException {
        return GHHooks.repoContext(this, this.owner).getHooks();
    }

    public GHHook getHook(int id) throws IOException {
        return GHHooks.repoContext(this, this.owner).getHook(id);
    }

    public GHCompare getCompare(String id1, String id2) throws IOException {
        GHCompare compare = (GHCompare)((Object)this.root.retrieve().to(this.getApiTailUrl(String.format("compare/%s...%s", id1, id2)), GHCompare.class));
        return compare.wrap(this);
    }

    public GHCompare getCompare(GHCommit id1, GHCommit id2) throws IOException {
        return this.getCompare(id1.getSHA1(), id2.getSHA1());
    }

    public GHCompare getCompare(GHBranch id1, GHBranch id2) throws IOException {
        String ownerName2;
        String ownerName1;
        GHRepository owner1 = id1.getOwner();
        GHRepository owner2 = id2.getOwner();
        if (owner1 != null && owner2 != null && !StringUtils.equals((String)(ownerName1 = owner1.getOwnerName()), (String)(ownerName2 = owner2.getOwnerName()))) {
            String qualifiedName1 = String.format("%s:%s", ownerName1, id1.getName());
            String qualifiedName2 = String.format("%s:%s", ownerName2, id2.getName());
            return this.getCompare(qualifiedName1, qualifiedName2);
        }
        return this.getCompare(id1.getName(), id2.getName());
    }

    public GHRef[] getRefs() throws IOException {
        return GHRef.wrap((GHRef[])this.root.retrieve().to(String.format("/repos/%s/%s/git/refs", this.owner.login, this.name), GHRef[].class), this.root);
    }

    public GHRef[] getRefs(String refType) throws IOException {
        return GHRef.wrap((GHRef[])this.root.retrieve().to(String.format("/repos/%s/%s/git/refs/%s", this.owner.login, this.name, refType), GHRef[].class), this.root);
    }

    public GHRef getRef(String refName) throws IOException {
        return ((GHRef)((Object)this.root.retrieve().to(String.format("/repos/%s/%s/git/refs/%s", this.owner.login, this.name, refName), GHRef.class))).wrap(this.root);
    }

    public GHTree getTree(String sha) throws IOException {
        String url = String.format("/repos/%s/%s/git/trees/%s", this.owner.login, this.name, sha);
        return ((GHTree)((Object)this.root.retrieve().to(url, GHTree.class))).wrap(this.root);
    }

    public GHTree getTreeRecursive(String sha, int recursive) throws IOException {
        String url = String.format("/repos/%s/%s/git/trees/%s?recursive=%d", this.owner.login, this.name, sha, recursive);
        return ((GHTree)((Object)this.root.retrieve().to(url, GHTree.class))).wrap(this.root);
    }

    public GHCommit getCommit(String sha1) throws IOException {
        GHCommit c = this.commits.get(sha1);
        if (c == null) {
            c = ((GHCommit)((Object)this.root.retrieve().to(String.format("/repos/%s/%s/commits/%s", this.owner.login, this.name, sha1), GHCommit.class))).wrapUp(this);
            this.commits.put(sha1, c);
        }
        return c;
    }

    public PagedIterable<GHCommit> listCommits() {
        return new PagedIterable<GHCommit>(){

            @Override
            public PagedIterator<GHCommit> _iterator(int pageSize) {
                return new PagedIterator<GHCommit>(GHRepository.this.root.retrieve().asIterator(String.format("/repos/%s/%s/commits", ((GHRepository)GHRepository.this).owner.login, GHRepository.this.name), GHCommit[].class, pageSize)){

                    protected void wrapUp(GHCommit[] page) {
                        for (GHCommit c : page) {
                            c.wrapUp(GHRepository.this);
                        }
                    }
                };
            }
        };
    }

    public GHCommitQueryBuilder queryCommits() {
        return new GHCommitQueryBuilder(this);
    }

    public PagedIterable<GHCommitComment> listCommitComments() {
        return new PagedIterable<GHCommitComment>(){

            @Override
            public PagedIterator<GHCommitComment> _iterator(int pageSize) {
                return new PagedIterator<GHCommitComment>(GHRepository.this.root.retrieve().asIterator(String.format("/repos/%s/%s/comments", ((GHRepository)GHRepository.this).owner.login, GHRepository.this.name), GHCommitComment[].class, pageSize)){

                    protected void wrapUp(GHCommitComment[] page) {
                        for (GHCommitComment c : page) {
                            c.wrap(GHRepository.this);
                        }
                    }
                };
            }
        };
    }

    public PagedIterable<GHCommitStatus> listCommitStatuses(final String sha1) throws IOException {
        return new PagedIterable<GHCommitStatus>(){

            @Override
            public PagedIterator<GHCommitStatus> _iterator(int pageSize) {
                return new PagedIterator<GHCommitStatus>(GHRepository.this.root.retrieve().asIterator(String.format("/repos/%s/%s/statuses/%s", ((GHRepository)GHRepository.this).owner.login, GHRepository.this.name, sha1), GHCommitStatus[].class, pageSize)){

                    protected void wrapUp(GHCommitStatus[] page) {
                        for (GHCommitStatus c : page) {
                            c.wrapUp(GHRepository.this.root);
                        }
                    }
                };
            }
        };
    }

    public GHCommitStatus getLastCommitStatus(String sha1) throws IOException {
        List<GHCommitStatus> v = this.listCommitStatuses(sha1).asList();
        return v.isEmpty() ? null : v.get(0);
    }

    public GHCommitStatus createCommitStatus(String sha1, GHCommitState state, String targetUrl, String description, String context) throws IOException {
        return ((GHCommitStatus)((Object)new Requester(this.root).with("state", state).with("target_url", targetUrl).with("description", description).with("context", context).to(String.format("/repos/%s/%s/statuses/%s", this.owner.login, this.name, sha1), GHCommitStatus.class))).wrapUp(this.root);
    }

    public GHCommitStatus createCommitStatus(String sha1, GHCommitState state, String targetUrl, String description) throws IOException {
        return this.createCommitStatus(sha1, state, targetUrl, description, null);
    }

    public PagedIterable<GHEventInfo> listEvents() throws IOException {
        return new PagedIterable<GHEventInfo>(){

            @Override
            public PagedIterator<GHEventInfo> _iterator(int pageSize) {
                return new PagedIterator<GHEventInfo>(GHRepository.this.root.retrieve().asIterator(String.format("/repos/%s/%s/events", ((GHRepository)GHRepository.this).owner.login, GHRepository.this.name), GHEventInfo[].class, pageSize)){

                    protected void wrapUp(GHEventInfo[] page) {
                        for (GHEventInfo c : page) {
                            c.wrapUp(GHRepository.this.root);
                        }
                    }
                };
            }
        };
    }

    public PagedIterable<GHLabel> listLabels() throws IOException {
        return new PagedIterable<GHLabel>(){

            @Override
            public PagedIterator<GHLabel> _iterator(int pageSize) {
                return new PagedIterator<GHLabel>(GHRepository.this.root.retrieve().asIterator(GHRepository.this.getApiTailUrl("labels"), GHLabel[].class, pageSize)){

                    protected void wrapUp(GHLabel[] page) {
                        for (GHLabel c : page) {
                            c.wrapUp(GHRepository.this);
                        }
                    }
                };
            }
        };
    }

    public GHLabel getLabel(String name) throws IOException {
        return ((GHLabel)((Object)this.root.retrieve().to(this.getApiTailUrl("labels/" + name), GHLabel.class))).wrapUp(this);
    }

    public GHLabel createLabel(String name, String color) throws IOException {
        return ((GHLabel)((Object)this.root.retrieve().method("POST").with("name", name).with("color", color).to(this.getApiTailUrl("labels"), GHLabel.class))).wrapUp(this);
    }

    public PagedIterable<GHUser> listSubscribers() {
        return this.listUsers("subscribers");
    }

    public PagedIterable<GHUser> listStargazers() {
        return this.listUsers("stargazers");
    }

    private PagedIterable<GHUser> listUsers(final String suffix) {
        return new PagedIterable<GHUser>(){

            @Override
            public PagedIterator<GHUser> _iterator(int pageSize) {
                return new PagedIterator<GHUser>(GHRepository.this.root.retrieve().asIterator(GHRepository.this.getApiTailUrl(suffix), GHUser[].class, pageSize)){

                    protected void wrapUp(GHUser[] page) {
                        for (GHUser c : page) {
                            c.wrapUp(GHRepository.this.root);
                        }
                    }
                };
            }
        };
    }

    public GHHook createHook(String name, Map<String, String> config, Collection<GHEvent> events, boolean active) throws IOException {
        return GHHooks.repoContext(this, this.owner).createHook(name, config, events, active);
    }

    public GHHook createWebHook(URL url, Collection<GHEvent> events) throws IOException {
        return this.createHook("web", Collections.singletonMap("url", url.toExternalForm()), events, true);
    }

    public GHHook createWebHook(URL url) throws IOException {
        return this.createWebHook(url, null);
    }

    private void verifyMine() throws IOException {
        if (!this.root.login.equals(this.owner.login)) {
            throw new IOException("Operation not applicable to a repository owned by someone else: " + this.owner.login);
        }
    }

    @SuppressFBWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="It causes a performance degradation, but we have already exposed it to the API")
    public Set<URL> getPostCommitHooks() {
        return this.postCommitHooks;
    }

    GHRepository wrap(GitHub root) {
        this.root = root;
        return this;
    }

    public Map<String, GHBranch> getBranches() throws IOException {
        TreeMap<String, GHBranch> r = new TreeMap<String, GHBranch>();
        for (GHBranch p : (GHBranch[])this.root.retrieve().to(this.getApiTailUrl("branches"), GHBranch[].class)) {
            p.wrap(this);
            r.put(p.getName(), p);
        }
        return r;
    }

    public Map<Integer, GHMilestone> getMilestones() throws IOException {
        TreeMap<Integer, GHMilestone> milestones = new TreeMap<Integer, GHMilestone>();
        for (GHMilestone m : this.listMilestones(GHIssueState.OPEN)) {
            milestones.put(m.getNumber(), m);
        }
        return milestones;
    }

    public PagedIterable<GHMilestone> listMilestones(final GHIssueState state) {
        return new PagedIterable<GHMilestone>(){

            @Override
            public PagedIterator<GHMilestone> _iterator(int pageSize) {
                return new PagedIterator<GHMilestone>(GHRepository.this.root.retrieve().with("state", state).asIterator(GHRepository.this.getApiTailUrl("milestones"), GHMilestone[].class, pageSize)){

                    protected void wrapUp(GHMilestone[] page) {
                        for (GHMilestone c : page) {
                            c.wrap(GHRepository.this);
                        }
                    }
                };
            }
        };
    }

    public GHMilestone getMilestone(int number) throws IOException {
        GHMilestone m = this.milestones.get(number);
        if (m == null) {
            m = (GHMilestone)((Object)this.root.retrieve().to(this.getApiTailUrl("milestones/" + number), GHMilestone.class));
            m.owner = this;
            m.root = this.root;
            this.milestones.put(m.getNumber(), m);
        }
        return m;
    }

    public GHContent getFileContent(String path) throws IOException {
        return this.getFileContent(path, null);
    }

    public GHContent getFileContent(String path, String ref) throws IOException {
        Requester requester = this.root.retrieve();
        String target = this.getApiTailUrl("contents/" + path);
        return ((GHContent)((Object)requester.with("ref", ref).to(target, GHContent.class))).wrap(this);
    }

    public List<GHContent> getDirectoryContent(String path) throws IOException {
        return this.getDirectoryContent(path, null);
    }

    public List<GHContent> getDirectoryContent(String path, String ref) throws IOException {
        Requester requester = this.root.retrieve();
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String target = this.getApiTailUrl("contents/" + path);
        GHContent[] files = (GHContent[])requester.with("ref", ref).to(target, GHContent[].class);
        GHContent.wrap(files, this);
        return Arrays.asList(files);
    }

    public GHContent getReadme() throws IOException {
        Requester requester = this.root.retrieve();
        return ((GHContent)((Object)requester.to(this.getApiTailUrl("readme"), GHContent.class))).wrap(this);
    }

    public GHContentUpdateResponse createContent(String content, String commitMessage, String path) throws IOException {
        return this.createContent(content, commitMessage, path, null);
    }

    public GHContentUpdateResponse createContent(String content, String commitMessage, String path, String branch) throws IOException {
        byte[] payload;
        try {
            payload = content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException("UTF-8 encoding is not supported", ex);
        }
        return this.createContent(payload, commitMessage, path, branch);
    }

    public GHContentUpdateResponse createContent(byte[] contentBytes, String commitMessage, String path) throws IOException {
        return this.createContent(contentBytes, commitMessage, path, null);
    }

    public GHContentUpdateResponse createContent(byte[] contentBytes, String commitMessage, String path, String branch) throws IOException {
        Requester requester = new Requester(this.root).with("path", path).with("message", commitMessage).with("content", DatatypeConverter.printBase64Binary((byte[])contentBytes)).method("PUT");
        if (branch != null) {
            requester.with("branch", branch);
        }
        GHContentUpdateResponse response = (GHContentUpdateResponse)((Object)requester.to(this.getApiTailUrl("contents/" + path), GHContentUpdateResponse.class));
        response.getContent().wrap(this);
        response.getCommit().wrapUp(this);
        return response;
    }

    public GHMilestone createMilestone(String title, String description) throws IOException {
        return ((GHMilestone)((Object)new Requester(this.root).with("title", title).with("description", description).method("POST").to(this.getApiTailUrl("milestones"), GHMilestone.class))).wrap(this);
    }

    public GHDeployKey addDeployKey(String title, String key) throws IOException {
        return ((GHDeployKey)((Object)new Requester(this.root).with("title", title).with("key", key).method("POST").to(this.getApiTailUrl("keys"), GHDeployKey.class))).wrap(this);
    }

    public List<GHDeployKey> getDeployKeys() throws IOException {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList((Object[])this.root.retrieve().to(this.getApiTailUrl("keys"), GHDeployKey[].class)));
        for (GHDeployKey gHDeployKey : list) {
            gHDeployKey.wrap(this);
        }
        return list;
    }

    public GHRepository getSource() throws IOException {
        if (this.source == null) {
            return null;
        }
        if (this.source.root == null) {
            this.source = this.root.getRepository(this.source.getFullName());
        }
        return this.source;
    }

    public GHRepository getParent() throws IOException {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.root == null) {
            this.parent = this.root.getRepository(this.parent.getFullName());
        }
        return this.parent;
    }

    public GHSubscription subscribe(boolean subscribed, boolean ignored) throws IOException {
        return ((GHSubscription)((Object)new Requester(this.root).with("subscribed", subscribed).with("ignored", ignored).method("PUT").to(this.getApiTailUrl("subscription"), GHSubscription.class))).wrapUp(this);
    }

    public GHSubscription getSubscription() throws IOException {
        try {
            return ((GHSubscription)((Object)this.root.retrieve().to(this.getApiTailUrl("subscription"), GHSubscription.class))).wrapUp(this);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public PagedIterable<Contributor> listContributors() throws IOException {
        return new PagedIterable<Contributor>(){

            @Override
            public PagedIterator<Contributor> _iterator(int pageSize) {
                return new PagedIterator<Contributor>(GHRepository.this.root.retrieve().asIterator(GHRepository.this.getApiTailUrl("contributors"), Contributor[].class, pageSize)){

                    protected void wrapUp(Contributor[] page) {
                        for (Contributor c : page) {
                            c.wrapUp(GHRepository.this.root);
                        }
                    }
                };
            }
        };
    }

    public Reader renderMarkdown(String text, MarkdownMode mode) throws IOException {
        return new InputStreamReader(new Requester(this.root).with("text", text).with("mode", mode == null ? null : mode.toString()).with("context", this.getFullName()).asStream("/markdown"), "UTF-8");
    }

    public GHNotificationStream listNotifications() {
        return new GHNotificationStream(this.root, this.getApiTailUrl("/notifications"));
    }

    public String toString() {
        return "Repository:" + this.owner.login + ":" + this.name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GHRepository) {
            GHRepository that = (GHRepository)obj;
            return this.owner.login.equals(that.owner.login) && this.name.equals(that.name);
        }
        return false;
    }

    String getApiTailUrl(String tail) {
        if (tail.length() > 0 && !tail.startsWith("/")) {
            tail = '/' + tail;
        }
        return "/repos/" + this.owner.login + "/" + this.name + tail;
    }

    public static class Contributor
    extends GHUser {
        private int contributions;

        public int getContributions() {
            return this.contributions;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ForkSort {
        NEWEST,
        OLDEST,
        STARGAZERS;

    }

    private static class GHRepoPermission {
        boolean pull;
        boolean push;
        boolean admin;

        private GHRepoPermission() {
        }
    }
}

