/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHTeam {
    private String name;
    private String permission;
    private String slug;
    private int id;
    private GHOrganization organization;
    protected GHOrganization org;

    GHTeam wrapUp(GHOrganization owner) {
        this.org = owner;
        return this;
    }

    GHTeam wrapUp(GitHub root) {
        this.organization.wrapUp(root);
        return this.wrapUp(this.organization);
    }

    static GHTeam[] wrapUp(GHTeam[] teams, GHOrganization owner) {
        for (GHTeam t : teams) {
            t.wrapUp(owner);
        }
        return teams;
    }

    public String getName() {
        return this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getSlug() {
        return this.slug;
    }

    public int getId() {
        return this.id;
    }

    public PagedIterable<GHUser> listMembers() throws IOException {
        return new PagedIterable<GHUser>(){

            @Override
            public PagedIterator<GHUser> _iterator(int pageSize) {
                return new PagedIterator<GHUser>(GHTeam.this.org.root.retrieve().asIterator(GHTeam.this.api("/members"), GHUser[].class, pageSize)){

                    protected void wrapUp(GHUser[] page) {
                        GHUser.wrap(page, GHTeam.this.org.root);
                    }
                };
            }
        };
    }

    public Set<GHUser> getMembers() throws IOException {
        return Collections.unmodifiableSet(this.listMembers().asSet());
    }

    public boolean hasMember(GHUser user) {
        try {
            this.org.root.retrieve().to("/teams/" + this.id + "/members/" + user.getLogin());
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public Map<String, GHRepository> getRepositories() throws IOException {
        TreeMap<String, GHRepository> m = new TreeMap<String, GHRepository>();
        for (GHRepository r : this.listRepositories()) {
            m.put(r.getName(), r);
        }
        return m;
    }

    public PagedIterable<GHRepository> listRepositories() {
        return new PagedIterable<GHRepository>(){

            @Override
            public PagedIterator<GHRepository> _iterator(int pageSize) {
                return new PagedIterator<GHRepository>(GHTeam.this.org.root.retrieve().asIterator(GHTeam.this.api("/repos"), GHRepository[].class, pageSize)){

                    protected void wrapUp(GHRepository[] page) {
                        for (GHRepository r : page) {
                            r.wrap(GHTeam.this.org.root);
                        }
                    }
                };
            }
        };
    }

    public void add(GHUser u) throws IOException {
        this.org.root.retrieve().method("PUT").to(this.api("/memberships/" + u.getLogin()), null);
    }

    public void remove(GHUser u) throws IOException {
        this.org.root.retrieve().method("DELETE").to(this.api("/members/" + u.getLogin()), null);
    }

    public void add(GHRepository r) throws IOException {
        this.org.root.retrieve().method("PUT").to(this.api("/repos/" + r.getOwnerName() + '/' + r.getName()), null);
    }

    public void remove(GHRepository r) throws IOException {
        this.org.root.retrieve().method("DELETE").to(this.api("/repos/" + r.getOwnerName() + '/' + r.getName()), null);
    }

    public void delete() throws IOException {
        this.org.root.retrieve().method("DELETE").to(this.api(""));
    }

    private String api(String tail) {
        return "/teams/" + this.id + tail;
    }

    public GHOrganization getOrganization() {
        return this.org;
    }
}

